<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\Garage;
use App\Models\Guarantee;
use App\Models\Permission;
use App\Models\Role;
use App\Models\TypeDocument;
use App\Models\TypeExpertise;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    //Asign permissions to a user
    public function store(Request $request, $id)
    {

        $user = User::whereId($id)->with('permission', 'company', 'role', 'role.permission', 'typeexpertise')->first();
        if ($user->role_id == 5) {
            return redirect()->route('user.index')->with('error', 'Vous étes un agent');
        }
        if ($request->has('permission')) {
            $user->permission()->detach();
            foreach ($request->permission as $p) {
                $permission = Permission::findOrFail($p);
                $user->permission()->syncWithoutDetaching($permission);
            }
        } else {
            $user->permission()->detach();
        }


        if ($request->has('company')) {
            $user->company()->detach();
            foreach ($request->company as $c) {
                $company = Company::findOrFail($c);
                $user->company()->syncWithoutDetaching($company);
            }
        } else {
            $user->company()->detach();
        }

        // dd($request->typeexpertise);
        if ($request->has('typeexpertise')) {

            $user->typecompany()->detach();
            foreach ($request->typeexpertise as $id => $types) {
                // $typeexpertise = TypeExpertise::findOrFail($c);
                $company = Company::findOrFail($id);
                foreach ($types as $type) {
                    $typeexpertise = TypeExpertise::findOrFail($type);
                    $user->typecompany()->attach($company->id,['type_expertise_id'=>$typeexpertise->id]);
                }
            }
        } else {
            $user->typeexpertise()->detach();
        }

        if ($request->has('guarantee')) {
            $user->guarantee()->detach();
            foreach ($request->guarantee as $c) {
                $guarantee = Guarantee::findOrFail($c);
                $user->guarantee()->syncWithoutDetaching($guarantee);
            }
        } else {
            $user->guarantee()->detach();
        }
        if ($request->has('type')) {
            $user->typedocument()->detach();
            foreach ($request->type as $p) {
                $type = TypeDocument::findOrFail($p);
                $user->typedocument()->syncWithoutDetaching($type);
            }
        } else {
            $user->typedocument()->detach();
        }

        if ($request->has('garage')) {
            $user->manygarage()->detach();
            foreach ($request->garage as $p) {
                $garage = Garage::findOrFail($p);
                $user->manygarage()->syncWithoutDetaching($garage);
            }
        } else {
            $user->manygarage()->detach();
        }
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Permission  $permission
     * @return \Illuminate\Http\Response
     */

    //Asign permissions to a role
    public function store2(Request $request, $id)
    {

        $role = Role::whereId($id)->with('permission')->first();
        if ($request->has('permission')) {
            $role->permission()->detach();
            //dd($request->permission);
            foreach ($request->permission as $p) {
                $permission = Permission::findOrFail($p);
                $role->permission()->syncWithoutDetaching($permission);
            }
        } else {
            $role->permission()->wherePivot('role_id', '=', $id)->detach();
        }

        return redirect()->route('user.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Permission  $permission
     * @return \Illuminate\Http\Response
     */
    public function edit(Permission $permission)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Permission  $permission
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Permission $permission)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Permission  $permission
     * @return \Illuminate\Http\Response
     */
    public function destroy(Permission $permission)
    {
        //
    }
}
