<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Guarantee extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = ['guarantee','tauxRP'];

    public function dossier()
    {
        return $this->hasMany(Dossier::class)->withTrashed();
    }

    public function user()
    {
        return $this->belongsToMany(User::class,'guarantee_user');
    }
}
