<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>AMEA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <link rel="stylesheet" href="{{ asset('css/imageuploadify.css') }}">

</head>

<body>
    <div class="container-fluid mt-4">

        <div class="row">
            <img class="img-fluid" style="width: 300px" src="{{ asset('img/amea2.png') }}" alt="">
        </div>
        <div class="row mt-2">
            <div class="col-12">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="container-fluid">
                            <form action="{{ $url }}" id="myForm" method="post" class=" mt-2 "
                                enctype="multipart/form-data">
                                @csrf
                                <div class="row mt-2">
                                    @foreach ($docs->typedocument as $type)
                                    <div class="mb-5 mt-3 col-md-6">
                                        <label for="type" style="font-size: 25px" class="form-label">{{ $type->type }} :</label>
                                            <input multiple name="{{ $type->type }}[]" class="@error('files') is-invalid @enderror"
                                                onchange="onUpload(this.files)" type="file"
                                                value="{{ $type->id }}" id="{{ $type->type }}"
                                                name="{{ $type->type }}[]" accept="image/*,.pdf" multiple />
                                            <input type="hidden" name="pdfs" id="pdf" value="">
                                        </div>
                                    @endforeach

                                    {{-- <div class="col-6 mt-2">
                                        @if ($errors->any())
                                            {!! implode('', $errors->all('<div style="color: red;margin-top:3px;">:message</div>')) !!}
                                        @endif
                                    </div> --}}

                                    <div class="row">
                                        <button type="submit" id="btn" class="btn btn-info mt-3">Upload</button>
                                    </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

<script src="{{ asset('js/vendor.js') }}"></script>
<script src="{{ asset('js/app.js') }}" defer></script>
<script src="{{ asset('js/imageuploadify.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.2.228/pdf.min.js"></script>
<script>
    $(document).ready(function() {
        $('input[type="file"]').imageuploadify();
    });
    var table = [];

    function onUpload(files) {
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file.type === 'application/pdf') {
                const reader = new FileReader();
                reader.onload = e => {
                    const data = atob(e.target.result.replace(/.*base64,/, ''));
                    renderPDF(data);
                }
                reader.readAsDataURL(file);
            }
        }
    }

    async function renderPDF(data) {
        const pdf = await pdfjsLib.getDocument({
            data
        }).promise;
        for (let i = 1; i <= pdf.numPages; i++) {
            const image = document.createElement('img');
            const page = await pdf.getPage(i);
            const viewport = page.getViewport({
                scale: 2
            });
            const canvas = document.createElement('canvas');
            const canvasContext = canvas.getContext('2d');
            canvas.height = viewport.height;
            canvas.width = viewport.width;
            await page.render({
                canvasContext,
                viewport
            }).promise;
            const dataUrl = canvas.toDataURL('image/png');
            image.src = dataUrl;
            image.classList.add('img');
            table.push(dataUrl);
            console.log(dataUrl);
        }
        const btn = document.getElementById('btn');
        btn.addEventListener('click', e => {
            e.preventDefault();
            const input = document.getElementById('pdf');
            input.value = JSON.stringify(table);
            document.getElementById('myForm').submit();
        });
    }
</script>

</html>
