@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        @if ($demande->status_rendezvous_id == 2)
            <div class="row">
                <div class="col-12 mb-2 mt-2">
                    <form action="{{ route('Demande.update', $demande->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div style="float: left" class="page-title-box">
                            <button name="action" type="submit" value="annuler" class="btn btn-danger"> Refuser </button>
                        </div>
                        <div style="float: right" class="page-title-box">
                            <button name="action" type="submit" value="terminer" class="btn btn-success"> Accepter
                            </button>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="col-md-6 mb-3">
                            <label for="date" class="form-label">Observation :</label>
                            <textarea class="form-control mb-2  @error('observation') is-invalid @enderror" name="observation" id=""
                                cols="10" rows="3"></textarea>
                            @error('observation')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </form>
                </div>
            </div>
        @endif
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Utilisateur</th>
                                        <th>Status</th>
                                        <th>Afficher Dossier</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $demande->id }}</td>
                                        <td>{{ $demande->user->name ?? null }}</td>
                                        <td> <span
                                                class="badge bg-{{ $demande->status->color }}">{{ $demande->status->status ?? null }}</span>
                                        </td>
                                        <td>
                                            <a class="btn btn-sm btn-info rounded-pill"
                                                href="{{ route('Dossier.show', [$demande->dossier_id]) }}"><i
                                            class="uil uil-eye fs-5"></i></a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <div class="row">
                                <label class="form-label" for="">Motif</label>
                                <textarea class="form-control" readonly name="" id="" cols="30" rows="10">
                               {{ $demande->motif ?? null }}
                            </textarea>

                            </div>


                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
