@extends('layouts.dashboard.app')
@section('style')
@endsection
@section('content')
    <div class="row">
        <div class="row mt-2">
            <div class="col-12">
                <div class="card mb-2">
                    <div class="card-body">
                        <div class="col-12">
                            <div class="page-title-box">
                                <h4 class="page-title" style="font-size: 25px">
                                    Devis
                                </h4>
                            </div>
                        </div>

                        <form action="{{ route('Devis.store') }}" id="myForm" method="post"
                            enctype="multipart/form-data">
                            @csrf

                            <input type="hidden" value="{{ $dossier->id }}" name="dossier_id">
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label for="">Ref Devis :</label>
                                    <input class="form-control @error('ref') is-invalid @enderror" name="ref"
                                        value="{{ old('ref') }}" type="text">

                                    @error('ref')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-6 ">
                                    <label for="">Date Reception Devis *:</label>
                                    <input class="form-control @error('date') is-invalid @enderror" name="date"
                                        value="" type="date">

                                    @error('date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-6 mt-4">
                                    <label for="">Montant Devis *:</label>
                                    <input class="form-control @error('montant_devis') is-invalid @enderror" 
                                        value="{{ old('montant_devis') }}" name="montant_devis" type="text">

                                    @error('montant_devis')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-6 mt-4">
                                    <label for=""> Devis *:</label>
                                    <input class="form-control @error('files') is-invalid @enderror" multiple name="files[]"
                                        onchange="onUpload(this.files)" type="file">
                                    <input type="hidden" name="pdfs" id="pdf" value="">

                                    @error('files')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            @if ($errors->any())
                                {!! implode('', $errors->all('<div style="color: red;margin-bottom:3px">:message</div>')) !!}
                            @endif

                            <button type="submit" id="btn" class="btn mt-2 btn-success">Ajouter</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.2.228/pdf.min.js"></script>

    <script>
        document.getElementById("myForm").addEventListener("submit", function() {
            document.getElementById("btn").disabled = true;

            // You can use AJAX or other methods to handle form submission here
            // After the submission is complete, re-enable the button
            // Example using a timeout (simulated submission)
            setTimeout(function() {
                document.getElementById("btn").disabled = false;
            }, 3000); // Adjust the delay as needed
        });
        const table = [];

        function onUpload(files) {
            for (let i = 0; i < files.length; i++) {
                var file = files[i];
                var reader = new FileReader();
                reader.onload = e => {
                    var data = atob(e.target.result.replace(/.*base64,/, ''));
                    renderPDF(data);
                }
                reader.readAsDataURL(file);

            }
        }
        async function renderPDF(data) {
            const pdf = await pdfjsLib.getDocument({
                data
            }).promise;
            for (let i = 1; i <= pdf.numPages; i++) {
                const image = document.createElement('img');
                const page = await pdf.getPage(i);
                const viewport = page.getViewport({
                    scale: 2
                });
                const canvas = document.createElement('canvas');
                const canvasContext = canvas.getContext('2d');
                canvas.height = viewport.height;
                canvas.width = viewport.width;
                await page.render({
                    canvasContext,
                    viewport
                }).promise;
                const data = canvas.toDataURL('image/png');
                image.src = data;
                image.classList.add('img');
                table.push(data);
            }
            console.log(table);
            let btn = document.getElementById('btn');
            btn.addEventListener('click', (e) => {
                e.preventDefault();
                document.getElementById('pdf').value = table;
                document.getElementById("myForm").submit();
            });
        }
    </script>
@endsection
