@extends('layouts.dashboard.app')
@section('style')
    <style>
        .container {
            position: relative;
            width: 33%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 15px;
        }
    </style>
@endsection

@section('content')
    @can('update', App\Models\Devis::class)
        <form action="{{ route('Devis.status', $devis->id) }}" class="" method="post">
            <div class="row mt-2">
                <div class="page-title-box">
                    <div class="page-title-left mb-1">
                        <a href="{{ route('Dossier.show', $devis->dossier_id) }}" class=" btn btn-outline-dark">Dossier</a>
                        <a href="{{ route('Devis.index', $dossier->id) }}" class="mr-3 btn btn-outline-info">
                            Devis
                        </a>
                    </div>
                    <div class="page-title-right mb-1">
                        @if (intval($devis->devis) == 1)
                            <span class="badge bg-dark">{{ $devis->devis }}er Devis </span>
                        @elseif(intval($devis->devis) > 1)
                            <span class="badge bg-dark">{{ $devis->devis }}éme Devis </span>
                        @endif
                    </div>
                </div>
                <div class="page-title-box">
                    @if ($devis->devisstatus)
                        @foreach ($devis->devisstatus as $item)
                            <span class="badge bg-{{ $item->color }}">{{ $item->status }}</span>
                            <input type="hidden" style="display:none"
                                value="{{ $user = App\Models\User::whereId($item->user_id)->first() }}">
                            <span class="badge bg-black">{{ $user->name ?? null }}</span>
                        @endforeach
                    @endif
                </div>


                <div class="col-12">
                    @csrf
                    @method('PUT')
                    @if ($devis->devis_status_id == 2)
                        @if (Auth::user()->role_id == 1 || Auth::user()->role_id == 4)
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button name="action" value="envoyer" class="btn btn-primary ml-3">
                                                Envoyer
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endif
                    @if ($devis->devis_status_id == 2 || $devis->devis_status_id == 6 || $devis->devis_status_id == 7)
                        @can('modifieraccord', App\Models\Devis::class)
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Modifier Accord
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endcan
                    @endif

                    @if ($devis->devis_status_id == 5)
                        @can('chiffrage', App\Models\Devis::class)
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>
                                            <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endcan
                    @elseif ($devis->devis_status_id == 4)
                        @can('chiffrage', App\Models\Devis::class)
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>
                                            @if (Auth::user()->role_id == 4)
                                                <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                    Rejeter
                                                </button>
                                            @endif
                                            <button style="" name="action" value="avis" class="btn btn-warning ml-3">
                                                Demander Avis
                                            </button>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endcan
                    @elseif ($devis->devis_status_id == 3 || $devis->devis_status_id == 8)
                        @can('controler', App\Models\Devis::class)
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>

                                            <button style="" name="action" value="retraiter" class="btn btn-warning ml-3">
                                                Retraiter
                                            </button>
                                            <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endcan


                        <div class="card mb-2">
                            <div class="card-body">
                                <div class="col-12">
                                    <span class="badge-bg-{{ $devis->status->color }}">{{ $devis->status->status }}</span>
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="col-md-4 mb-3">
                        <label for="date" class="form-label">Observation :</label>
                        <textarea class="form-control mb-2  @error('observation') is-invalid @enderror" name="observation" id=""
                            cols="10" rows="2"></textarea>
                        @error('observation')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>


                </div>

            </div>
            <div class="row mt-2">
                <div class="col-12">
                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="page-title-box mb-2">
                                <div style="float: left">
                                    @if ($dossier->typeexpertise)
                                        <span class="badge bg-warning"> {{ $dossier->typeexpertise->type ?? null }}</span>
                                    @endif
                                    @if ($dossier->mode)
                                        <span class="badge bg-info">
                                            {{ $dossier->mode->mode ?? null }}
                                        </span>
                                    @endif
                                    @if ($historiques > 0)
                                        <span class="badge bg-danger">
                                            Dossiers En cours (Meme Matricule) : {{ $historiques }}
                                        </span>
                                    @endif

                                </div>
                                <div style="float: right">

                                </div>
                            </div>
                            <br>
                            <div class="page-title-box">
                                <h4 class="page-title" style="font-size: 22px">
                                    Devis
                                    <span class="badge bg-{{ $devis->status->color }}">{{ $devis->status->status }}</span>
                                </h4>
                                @if ($devis->dossier->sinistre_douteux)
                                    <span class="badge bg-danger">Sinistre Douteux</span>
                                @endif
                            </div>
                            <div class="table-responsive">
                                <div class="col-12">

                                    <table class="table" id="">
                                        <thead>
                                            <tr>
                                                <th>Ref</th>
                                                <th>Date Reception</th>
                                                <th>Montant Devis</th>
                                                <th>Montant Accord</th>
                                                <th>Montant Facture</th>
                                                <th>Montant Rapport</th>
                                                {{-- @if ($devis->devis_status_id != 2)
                                            <th>Modifier</th>
                                        @endif --}}

                                            </tr>
                                        </thead>

                                        <tbody>

                                            <tr>
                                                <td>
                                                    {{ $devis->dossier->ref ?? null }}
                                                </td>
                                                <td>
                                                    {{ $devis->date_reception ?? null }}
                                                </td>
                                                <td class="col-3">
                                                    <input type="text" name="montant_devis" readonly
                                                        value="{{ $montant->devis->montant_devis ?? null }}"
                                                        name="montant_devis"
                                                        class="form-control  @error('montant_devis') is-invalid @enderror">
                                                    @error('montant_devis')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </td>
                                                <td class="col-3">
                                                    <input type="text" name="montant_accord"
                                                        @if (Auth::user()->role_id == 4 ||
                                                                $devis->devis_status_id == 4 ||
                                                                $devis->devis_status_id == 3 ||
                                                                $devis->devis_status_id == 5 ||
                                                                $devis->devis_status_id == 8) @else
                                                         readonly @endif
                                                        @if (
                                                            $dossier->type_expertise_id == 4 ||
                                                                $dossier->type_expertise_id == 3 ||
                                                                $dossier->type_expertise_id == 5 ||
                                                                $dossier->type_expertise_id == 6 ||
                                                                $dossier->type_expertise_id == 7) @if ($dossier->mode_id != 2 && $dossier->mode_id != 3)
                                                                 readonly @endif
                                                        @endif
                                                    value="{{ $montant->montant_accord ?? null }} " name="montant_accord"
                                                    class="form-control @error('montant_accord') is-invalid @enderror">
                                                    @error('montant_accord')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </td>
                                                <td class="col-3">
                                                    <input type="text"readonly
                                                        value="{{ $montant->facture->montant_facture ?? null }}"
                                                        name="montant_facture"
                                                        class="form-control @error('montant_facture') is-invalid @enderror">
                                                    @error('montant_facture')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </td>
                                                <td class="col-3">
                                                    <input type="text" value="{{ $montant->montant_rapport ?? null }}"
                                                        name="montant_rapport" readonly
                                                        class="form-control @error('montant_rapport') is-invalid @enderror">
                                                    @error('montant_rapport')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </td>
                                                {{-- @if ($devis->devis_status_id != 2)
                                        <button style="float: right" type="button" class=" mt-3 btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#full-width-modal">Taux Devis</button>
                                            <td class="col-3">
                                                <a href="{{ route('Montant.edit', $montant->id) }}"
                                                    class="btn btn-sm btn-outline-primary" href="">
                                                    <i class="uil uil-pen fs-5"></i>
                                                </a>
                                                </button>
                                            </td>
                                        @endif --}}
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </form>
    @endcan
    <div style="" id="galley" class="row mt-5">
        <div class="col-6">
            <div class="card mb-2">
                <div class="card-body">
                    <h4 class="page-title text-dark" style="font-size: 22px">
                        Devis
                    </h4>
                    <hr>
                    @if ($docdevis)
                        <div class="row" id="">

                            @foreach ($docdevis as $doc)
                                <div class="col-3 container ">
                                    <img src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) ?? null }}"
                                        data-original="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) ?? null }}"alt="img"
                                        class="img-fluid m-1" srcset="">
                                    <div class="middle">
                                        @if ($doc->devis[0]->id == $devis->id)
                                            <a href="{{ route('Devis.show', ['id' => $devis->id, 'doc_id' => $doc->id]) }}"
                                                class="text append icon dripicons-document-edit"></a>
                                        @endif
                                    </div>
                                    <span class="badge bg-info m-1"
                                        style="display: block;">{{ $doc->devis[0]->devis ?? null }}
                                        {{ $doc->typedocument->type ?? null }}</span>

                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-6 mt-4">
            <div class="">
                <ul class="nav nav-tabs nav-stacked ">
                    <li class="nav-item ">
                        <button type="button" data-filter="ALL" class="link nav-link" style=" cursor: pointer;"
                            value="ALL">ALL
                        </button>
                    </li>
                    @foreach ($typedocuments as $type)
                        <li class="nav-item ">
                            <button type="button" data-filter="{{ $type->type }}" class="link nav-link"
                                style=" cursor: pointer;" value="{{ $type->id }}">{{ $type->type }} </button>
                        </li>
                    @endforeach
                </ul>
                <div class="card-body m-1" style="height: 300px; overflow-y:auto">
                    <input type="hidden" id="id" name="dossier_id" value="{{ $dossier->id }}">
                    @if ($dossier->document)
                        <ul style="list-style-type: none;" id="row" class="row">
                            @foreach ($dossier->document as $doc)
                                @if ($doc->type_document_id != 10)
                                    <li class="box container col-3 media {{ $doc->typedocument->type ?? null }} ">
                                        @php
                                            // Generate a unique cache key based on the document ID
                                            $cacheKey = 'document_' . $doc->id;

                                            // Check if the document image URL is already cached
                                            $imageUrl = Cache::remember($cacheKey, 30, function () use ($doc) {
                                                // If not cached, generate the temporary URL and return it
                                                return Storage::disk('s3')->temporaryUrl(
                                                    $doc->path,
                                                    now()->addMinutes(30),
                                                );
                                            });
                                        @endphp
                                        <img data-original="{{ $imageUrl }}" src="{{ $imageUrl }}"
                                            alt="img" class="img-fluid m-1" srcset="">
                                        <div class="middle">
                                            <a href="{{ route('Document.edit', $doc->id) }}"
                                                class="text append icon dripicons-document-edit"></a>
                                            {{-- @if (Auth::user()->role_id == 4)
                                                @if ($doc->type_document_id != 4 && $doc->type_document_id != 8)
                                                    <form class="deleteForm"
                                                        action="{{ route('Document.destroy', $doc->id) }}"
                                                        method="post">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="confirmDelete"
                                                            style="padding: 0;border: none;background: none;"
                                                            type="button"><i
                                                                class="text append icon dripicons-trash"></i></button>
                                                    </form>
                                                @endif
                                            @endif --}}
                                        </div>
                                        @if ($doc->edited)
                                            <span class="badge  bg-success m-1"
                                                style="display: block;">{{ $doc->typedocument->type ?? null }}</span>
                                        @else
                                            <span class="badge  bg-primary m-1"
                                                style="display: block;">{{ $doc->typedocument->type ?? null }}</span>
                                        @endif

                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    @endif
                </div>
            </div>
        </div>

    </div>

    @if ($devis->devis_status_id == 4 || $devis->devis_status_id == 5)
        @can('chiffrage', App\Models\Devis::class)
            @include('devis.editor_devis2')
        @endcan
    @elseif ($devis->devis_status_id == 8)
        @can('controler', App\Models\Devis::class)
            @include('devis.editor_devis2')
        @endcan
    @elseif (Auth::user()->role_id == 4 &&
            ($devis->devis_status_id == 2 || $devis->devis_status_id == 3 || $devis->devis_status_id == 7))
        @include('devis.editor_devis2')
    @endif

    {{-- @if (Auth::user()->role_id == 4 || $devis->devis_status_id == 4 || $devis->devis_status_id == 3 || $devis->devis_status_id == 5 || $devis->devis_status_id == 8)
        @can('chiffrage', App\Models\Devis::class)
        @endcan
    @endif --}}

    @if ($devis->devis_status_id == 4 || $devis->devis_status_id == 5)
        @can('chiffrage', App\Models\Devis::class)
            @include('devis.piece')
        @endcan
    @elseif ($devis->devis_status_id == 8)
        @can('controler', App\Models\Devis::class)
            @include('devis.piece')
        @endcan
    @elseif (Auth::user()->role_id == 4 &&
            ($devis->devis_status_id == 2 || $devis->devis_status_id == 3 || $devis->devis_status_id == 7))
        @include('devis.piece')
    @endif
    @can('chiffrage', App\Models\Devis::class)
        <div class="row">
            <div class="col-12">
                <button style="float: left;display:block" type="button" class=" col-1 mt-3 btn btn-info"
                    data-bs-toggle="modal" data-bs-target="#full-width-modal2">Valeurs </button>
            </div>
        </div>
        @include('devis.valeurs')
        <input type="hidden" value="{{ $devis->id }}" name="devis_id">
        <div class="row mt-2">
            <div class="col-12">
                <div class="card mb-2">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Categorie</th>
                                        <th>Piéce</th>
                                        <th>Operation</th>
                                        <th>Reparation</th>
                                        <th>Prix Unitaire</th>
                                        <th>Qte</th>
                                        <th>Gravite</th>
                                        <th>Etat</th>
                                        <th>Vetuste %</th>
                                        <th>Remise %</th>
                                        <th>Select</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($devis->piece as $piece)
                                        <tr>

                                            <td>
                                                @if (Auth::user()->role_id != 4 &&
                                                        ($devis->devis_status_id == 2 ||
                                                            $devis->devis_status_id == 7 ||
                                                            $devis->devis_status_id == 6 ||
                                                            $devis->devis_status_id == 1))
                                                    <input type="text" readonly class="form-control"
                                                        value="{{ $piece->piecetype->type ?? null }}">
                                                @else
                                                    <select class="form-select" name="op"
                                                        onchange="list({{ $piece->id }},this.value)"
                                                        id="pt{{ $piece->id }}">
                                                        <option value="{{ $piece->piecetype->id }}">
                                                            {{ $piece->piecetype->type }}</option>
                                                        @foreach ($piecetypes as $piecetype)
                                                            @if ($piecetype->id != $piece->piecetype->id)
                                                                <option value="{{ $piecetype->id }}">
                                                                    {{ $piecetype->type }}
                                                                </option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                                @endif
                                            </td>
                                            <td>
                                                @if (Auth::user()->role_id != 4 &&
                                                        ($devis->devis_status_id == 2 ||
                                                            $devis->devis_status_id == 7 ||
                                                            $devis->devis_status_id == 6 ||
                                                            $devis->devis_status_id == 1))
                                                    <input type="text" readonly class="form-control"
                                                        value="{{ $piece->piece ?? null }}">
                                                @else
                                                    <select class="form-select" name="op" id="pc{{ $piece->id }}">
                                                        <option selected value="{{ $piece->id }}">
                                                            {{ $piece->piece }}</option>
                                                    </select>
                                                @endif
                                            </td>
                                            <td>
                                                @if (Auth::user()->role_id != 4 &&
                                                        ($devis->devis_status_id == 2 ||
                                                            $devis->devis_status_id == 7 ||
                                                            $devis->devis_status_id == 6 ||
                                                            $devis->devis_status_id == 1))
                                                    <input type="text" readonly class="form-control"
                                                        value="{{ $piece->pivot->operation->operation ?? null }}">
                                                @else
                                                    <select class="form-select" name="op" id="o{{ $piece->id }}">
                                                        <option selected value="{{ $piece->pivot->operation->id }}">
                                                            {{ $piece->pivot->operation->operation }}</option>
                                                        @foreach ($operations as $operation)
                                                            @if ($operation->id != $piece->pivot->operation->id)
                                                                <option value="{{ $operation->id }}">
                                                                    {{ $operation->operation }}
                                                                </option>
                                                            @endif
                                                        @endforeach
                                                @endif
                                                </select>
                                            </td>
                                            <td>
                                                @if (Auth::user()->role_id != 4 &&
                                                        ($devis->devis_status_id == 2 ||
                                                            $devis->devis_status_id == 7 ||
                                                            $devis->devis_status_id == 6 ||
                                                            $devis->devis_status_id == 1))
                                                    <input type="text" readonly class="form-control"
                                                        value="{{ $piece->pivot->typereparation->type ?? null }}">
                                                @else
                                                    <select class="form-select" name="type" id="t{{ $piece->id }}">
                                                        <option selected value="{{ $piece->pivot->typereparation->id }}">
                                                            {{ $piece->pivot->typereparation->type }}</option>
                                                        @foreach ($types as $type)
                                                            @if ($type->id != $piece->pivot->typereparation->id)
                                                                <option value="{{ $type->id }}">{{ $type->type }}
                                                                </option>
                                                            @endif
                                                        @endforeach
                                                @endif
                                                </select>
                                            </td>
                                            <td>
                                                <input type="number" id="p{{ $piece->id }}" min="0"
                                                    @if (Auth::user()->role_id != 4 &&
                                                            ($devis->devis_status_id == 2 ||
                                                                $devis->devis_status_id == 7 ||
                                                                $devis->devis_status_id == 6 ||
                                                                $devis->devis_status_id == 1)) readonly @endif name="prix_unitaire"
                                                    class="form-control" id="p{{ $piece->id }}"
                                                    value="{{ $piece->pivot->prix_unitaire }}">
                                            </td>
                                            <td class="">
                                                <input class="form-control" name="qte" id="id{{ $piece->id }}"
                                                    @if (Auth::user()->role_id != 4 &&
                                                            ($devis->devis_status_id == 2 ||
                                                                $devis->devis_status_id == 7 ||
                                                                $devis->devis_status_id == 6 ||
                                                                $devis->devis_status_id == 1)) readonly @endif type="number"
                                                    value="{{ $piece->pivot->qte }}" min="1">
                                            </td>
                                            <td>
                                                @if (Auth::user()->role_id != 4 &&
                                                        ($devis->devis_status_id == 2 ||
                                                            $devis->devis_status_id == 7 ||
                                                            $devis->devis_status_id == 6 ||
                                                            $devis->devis_status_id == 1))
                                                    <input type="text" class="form-control" readonly
                                                        value="{{ $piece->pivot->gravite }}">
                                                @else
                                                    <select class="form-select" name="gravite" id="g{{ $piece->id }}">
                                                        <option selected value="{{ $piece->pivot->gravite }}">
                                                            {{ $piece->pivot->gravite }}</option>
                                                        @if ($piece->pivot->gravite == 'Moyen')
                                                            <option value="Faible">Faible</option>
                                                        @elseif($piece->pivot->gravite == 'Faible')
                                                            <option value="Moyen">Moyen</option>
                                                        @else
                                                            <option value="Moyen">Moyen</option>
                                                            <option value="Faible">Faible</option>
                                                        @endif
                                                    </select>
                                                @endif

                                            </td>
                                            <td>
                                                @if (Auth::user()->role_id != 4 &&
                                                        ($devis->devis_status_id == 2 ||
                                                            $devis->devis_status_id == 7 ||
                                                            $devis->devis_status_id == 6 ||
                                                            $devis->devis_status_id == 1))
                                                    <input type="text" class="form-control" readonly
                                                        value="{{ $piece->pivot->etat }}">
                                                @else
                                                    <select class="form-select" name="etat" id="e{{ $piece->id }}">
                                                        <option selected value="{{ $piece->pivot->etat }}">
                                                            {{ $piece->pivot->etat }}</option>
                                                        @if ($piece->pivot->etat == 'OUI')
                                                            <option value="NON">NON</option>
                                                        @elseif($piece->pivot->etat == 'NON')
                                                            <option value="OUI">OUI</option>
                                                        @else
                                                            <option value="OUI">OUI</option>
                                                            <option value="NON">NON</option>
                                                        @endif

                                                    </select>
                                                @endif
                                            </td>
                                            <td>

                                                <input type="number" id="v{{ $piece->id }}" min="0"
                                                    @if (Auth::user()->role_id != 4 &&
                                                            ($devis->devis_status_id == 2 ||
                                                                $devis->devis_status_id == 7 ||
                                                                $devis->devis_status_id == 6 ||
                                                                $devis->devis_status_id == 1)) readonly @endif name="vetuste"
                                                    class="form-control" value="{{ $piece->pivot->vetuste }}">
                                            </td>
                                            <td>
                                                <input type="number" id="r{{ $piece->id }}" name="remise"
                                                    @if (Auth::user()->role_id != 4 &&
                                                            ($devis->devis_status_id == 2 ||
                                                                $devis->devis_status_id == 7 ||
                                                                $devis->devis_status_id == 6 ||
                                                                $devis->devis_status_id == 1)) readonly @endif class="form-control"
                                                    value="{{ $piece->pivot->remise }}">
                                            </td>
                                            <td>
                                                <input class="form-check-input check" type="checkbox" name="piece" checked
                                                    @if (Auth::user()->role_id != 4 &&
                                                            ($devis->devis_status_id == 2 ||
                                                                $devis->devis_status_id == 7 ||
                                                                $devis->devis_status_id == 6 ||
                                                                $devis->devis_status_id == 1)) readonly
                                                        disabled="disabled" @endif
                                                    value="{{ $piece->id }}">
                                            </td>

                                        </tr>
                                    @endforeach
                                    {{-- @if ($devis->devis_status_id != 2 && $devis->devis_status_id != 7 && $devis->devis_status_id != 6)
                                        @foreach ($pieces as $piece)
                                            <tr>
                                                <td>{{ $piece->piece }}</td>
                                                <td>{{ $piece->piecetype->type ?? null }}</td>
                                                <td>{{ $piece->operation->operation ?? null }}</td>

                                                <td>{{ $piece->typereparation->type }}</td>
                                                <td>  <input class="form-control" value=" {{ $piece->prix_unitaire }}" name="prix_unitaire" id="p{{ $piece->id }}"
                                                    type="number" value="1" min="1">
                                                   </td>
                                                <td class="col-2">
                                                    <input class="form-control" name="qte"
                                                        id="id{{ $piece->id }}" type="number" value="1"
                                                        min="1">
                                                </td>
                                                <td>
                                                    <select class="form-select" name="gravite" id="g{{ $piece->id }}">
                                                        <option value="">Selectionner</option>
                                                        <option value="Moyen">Moyen</option>
                                                        <option value="Faible">Faible</option>
                                                    </select>
                                                </td>

                                                <td>
                                                    <select class="form-select" name="etat" id="e{{ $piece->id }}">
                                                        <option value="">Selectionner</option>
                                                        <option value="OUI">OUI</option>
                                                        <option value="NON">NON</option>
                                                    </select>
                                                </td>
                                                <td>

                                                    <input type="number" id="v{{ $piece->id }}" min="0"
                                                        name="vetuste" class="form-control" value="0">
                                                </td>
                                                <td>
                                                    <input type="number" id="r{{ $piece->id }}" name="remise"
                                                        class="form-control" value="0">
                                                </td>
                                                <td>
                                                    <input class="form-check-input check" type="checkbox" name="piece"
                                                        value="{{ $piece->id }}">
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif --}}
                                </tbody>

                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if ($dossier->dossier_status_id != 3)
            @if ($devis->devis_status_id == 4 || $devis->devis_status_id == 5)
                @can('chiffrage', App\Models\Devis::class)
                    <a class="btn btn-success savedevis mt-3"> Enregistrer Piece</a>
                @endcan
            @elseif ($devis->devis_status_id == 8)
                @can('controler', App\Models\Devis::class)
                    <a class="btn btn-success savedevis mt-3"> Enregistrer Piece</a>
                @endcan
            @elseif (Auth::user()->role_id == 4 &&
                    ($devis->devis_status_id == 2 || $devis->devis_status_id == 3 || $devis->devis_status_id == 7))
                <a class="btn btn-success savedevis mt-3"> Enregistrer Piece</a>
            @endif
        @endif


        @if ($devis->devis_status_id == 4 || $devis->devis_status_id == 5)
            @can('chiffrage', App\Models\Devis::class)
                <button style="float: right" type="button" class=" mt-3 btn btn-primary" data-bs-toggle="modal"
                    data-bs-target="#full-width-modal">Taux Devis</button>

                @include('devis.taux')
            @endcan
        @elseif ($devis->devis_status_id == 8)
            @can('controler', App\Models\Devis::class)
                <button style="float: right" type="button" class=" mt-3 btn btn-primary" data-bs-toggle="modal"
                    data-bs-target="#full-width-modal">Taux Devis</button>

                @include('devis.taux')
            @endcan
        @elseif (Auth::user()->role_id == 4 &&
                ($devis->devis_status_id == 2 || $devis->devis_status_id == 3 || $devis->devis_status_id == 7))
            <button style="float: right" type="button" class=" mt-3 btn btn-primary" data-bs-toggle="modal"
                data-bs-target="#full-width-modal">Taux Devis</button>

            @include('devis.taux')
        @endif
    @endcan


    {{-- <div class="container-fluid">
        <div class="row mt-3">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Liste des Ancien Piece du {{ $dossier->vehiculemodel->name ?? 'Modéle' }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Categorie</th>
                                        <th>Piéce</th>
                                        <th>Operation</th>
                                        <th>Reparation</th>
                                        <th>Prix Unitaire</th>
                                        <th>Gravite</th>
                                        <th>Etat</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($pieces as $piece)
                                        <tr>
                                            <td>{{ $piece->piecetype->type ?? null }}</td>
                                            <td>{{ $piece->piece ?? null }}</td>
                                            <td>{{ $piece->operation->operation ?? null }}</td>
                                            <td>{{ $piece->typereparation->type ?? null }}</td>
                                            <td>{{ $piece->rapport[0]->pivot->prix_unitaire ?? null }}</td>
                                            <td>{{ $piece->rapport[0]->pivot->gravite ?? null }}</td>
                                            <td>{{ $piece->rapport[0]->pivot->etat ?? null }}</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}
    <div class="row mt-2">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-3" style="color: black">Observation</h4>
                    @if ($observations)
                        <div class="accordion" id="">
                            @foreach ($observations as $key => $observation)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse-{{ $key }}"
                                            aria-expanded="false" aria-controls="">
                                            {{ $observation->user->name }}
                                        </button>
                                    </h2>
                                    <div id="collapse-{{ $key }}" class="accordion-collapse collapse "
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <strong class="text-dark">{{ $observation->observation }}.</strong>
                                            <span>{{ $observation->created_at }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    @can('update', App\Models\Devis::class)
                        <form method="POST" action="{{ route('Observation.store') }}">
                            @csrf
                            <div class="col-md-12 mt-1 ml-3">
                                <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                                <textarea name="observation" class="form-control @error('observation') is-invalid @enderror mb-2" id="observation"
                                    cols="30" rows="10"></textarea>
                                @error('observation')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                <button class="mt-2 btn btn-info">Créer</button>
                            </div>
                        </form>
                    @endcan
                </div>
            </div>
        </div>
    </div>

@endsection
