<div class="leftside-menu menuitem-active">

    <!-- Enhanced Sidebar Styles -->
    <style>
        .leftside-menu {
            background: linear-gradient(180deg, #1a1a2e 0%, #16213e 100%) !important;
            display: flex;
            flex-direction: column;
            height: 100vh;
        }

        .wrapper .leftside-menu {
            padding-top: 0 !important;
        }

        /* Logo styling */
        .leftside-menu .logo {
            background: transparent !important;
            position: sticky;
            top: 0;
            z-index: 100;
            height: 70px;
            min-height: 70px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.08);
            padding: 0 !important;
            margin: 0 !important;
        }

        body[data-leftbar-theme="dark"] .leftside-menu .logo {
            background: transparent !important;
        }

        .leftside-menu .logo img {
            max-height: 45px;
            width: auto;
            /* Green tint filter */
            filter: brightness(0) saturate(100%) invert(52%) sepia(87%) saturate(394%) hue-rotate(93deg) brightness(95%) contrast(87%);
        }

        .leftside-menu .logo-sm img {
            max-height: 40px;
        }

        /* Scrollable content area */
        #leftside-menu-container {
            flex: 1;
            overflow-y: auto;
            overflow-x: hidden;
        }

        .side-nav-item { margin: 2px 8px; }

        .side-nav-link {
            display: flex !important;
            align-items: center;
            justify-content: space-between;
            padding: 10px 15px !important;
            border-radius: 8px;
            transition: all 0.2s ease;
            cursor: pointer;
            color: rgba(255, 255, 255, 0.7) !important;
            text-decoration: none !important;
        }

        .side-nav-link:hover {
            background: rgba(255, 255, 255, 0.08);
            color: #fff !important;
        }

        .side-nav-link i { width: 20px; font-size: 16px; margin-right: 10px; }

        .side-nav-title {
            font-size: 10px !important;
            text-transform: uppercase !important;
            letter-spacing: 1.5px !important;
            padding: 15px 15px 8px !important;
            color: rgba(255, 255, 255, 0.5) !important;
            font-weight: 600 !important;
        }

        /* Dropdown Styles */
        .nav-dropdown { margin: 4px 8px; }

        .nav-dropdown-toggle {
            display: flex !important;
            align-items: center;
            justify-content: space-between;
            padding: 12px 15px !important;
            border-radius: 8px;
            cursor: pointer;
            color: rgba(255, 255, 255, 0.85) !important;
            background: rgba(255, 255, 255, 0.05);
            transition: all 0.2s ease;
            border: none;
            width: 100%;
            text-align: left;
            font-size: 13px;
            font-weight: 600;
        }

        .nav-dropdown-toggle:hover {
            background: rgba(255, 255, 255, 0.1);
            color: #fff !important;
        }

        .nav-dropdown-toggle i.dropdown-icon {
            transition: transform 0.2s ease;
            font-size: 12px;
            margin-left: auto;
            margin-right: 0;
        }

        .nav-dropdown.open .nav-dropdown-toggle i.dropdown-icon {
            transform: rotate(180deg);
        }

        .nav-dropdown-toggle .toggle-left {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .nav-dropdown-toggle .toggle-left i { font-size: 16px; width: 20px; }

        .category-badge {
            background: rgba(255, 153, 0, 0.2);
            color: #ff9900;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 11px;
            font-weight: 600;
            margin-left: 8px;
        }

        .category-badge.zero {
            background: rgba(255, 255, 255, 0.1);
            color: rgba(255, 255, 255, 0.5);
        }

        .nav-dropdown-content {
            display: none;
            padding: 5px 0 5px 10px;
            margin-top: 2px;
        }

        .nav-dropdown.open .nav-dropdown-content { display: block; }

        .nav-dropdown-content .side-nav-item { margin: 1px 0; }

        .nav-dropdown-content .side-nav-link {
            padding: 8px 12px !important;
            font-size: 12.5px;
            border-left: 2px solid transparent;
            border-radius: 0 8px 8px 0;
        }

        .nav-dropdown-content .side-nav-link:hover {
            border-left-color: #3498db;
            background: rgba(255, 255, 255, 0.05);
        }

        .count-badge {
            background: rgba(255, 255, 255, 0.12);
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 11px;
            font-weight: 600;
            min-width: 24px;
            text-align: center;
            transition: transform 0.2s ease, background 0.3s ease;
        }

        .side-nav-link.has-count { color: #ff9900 !important; }
        .side-nav-link.has-count .count-badge { background: #ff9900; color: #1a1a2e; }

        .side-nav-link.is-success { color: #10b981 !important; }
        .side-nav-link.is-success .count-badge { background: #10b981; color: #fff; }
        
        .category-badge {
            transition: transform 0.2s ease, background 0.3s ease;
        }

        .simplebar-scrollbar::before {
            background: rgba(255, 255, 255, 0.25) !important;
            border-radius: 4px !important;
        }

        .direct-link { margin: 4px 8px; }
        .direct-link .side-nav-link { background: rgba(255, 255, 255, 0.03); }

        /* ============================================
           MOBILE FIX - Sidebar above overlay
           ============================================ */
        @media (max-width: 767.98px) {
            .leftside-menu {
                position: fixed !important;
                top: 0;
                left: 0;
                z-index: 1060 !important; /* ABOVE overlay */
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }
            
            body.sidebar-open .leftside-menu,
            .leftside-menu.show {
                transform: translateX(0);
            }
            
            /* Overlay must be BELOW sidebar */
            body.sidebar-open::before,
            .sidebar-overlay {
                z-index: 1050 !important; /* Below sidebar 1060 */
            }
            
            /* Ensure ALL sidebar elements are clickable */
            .leftside-menu,
            .leftside-menu *,
            .leftside-menu .nav-dropdown,
            .leftside-menu .nav-dropdown-toggle,
            .leftside-menu .nav-dropdown-content,
            .leftside-menu .nav-dropdown-content * {
                pointer-events: auto !important;
            }
            
            /* Dropdown content needs proper stacking */
            .nav-dropdown-content {
                position: relative;
                z-index: 1;
            }
            
            .nav-dropdown-content .side-nav-item,
            .nav-dropdown-content .side-nav-link {
                position: relative;
                z-index: 2;
                pointer-events: auto !important;
                cursor: pointer !important;
            }
        }
    </style>

    <!-- LOGO - Sticky Header -->
    <a href="{{ route('home') }}" class="logo text-center logo-light">
        <span class="logo-lg"><img src="{{ asset('img/logo_white.png') }}" alt="Logo" height="45"></span>
        <span class="logo-sm"><img src="{{ asset('img/icon_white.png') }}" alt="Logo" height="40"></span>
    </a>
    
    <!-- Mobile Close Button -->
    <button class="sidebar-close-btn" onclick="closeSidebar()">
        <i class="uil uil-times"></i>
    </button>

    <div class="h-100 show" id="leftside-menu-container" data-simplebar="init">
        <div class="simplebar-wrapper" style="margin: 0px;">
            <div class="simplebar-height-auto-observer-wrapper"><div class="simplebar-height-auto-observer"></div></div>
            <div class="simplebar-mask">
                <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                    <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">
                        <div class="simplebar-content" style="padding: 0px;">

                            <ul class="side-nav">
                                <li class="side-nav-title side-nav-item">Navigation</li>

                                <!-- Dashboard -->
                                <li class="side-nav-item direct-link">
                                    <a href="{{ route('home') }}" class="side-nav-link">
                                        <i class="uil-home-alt"></i><span>Dashboard</span>
                                    </a>
                                </li>
                                
                                <!-- Configuration - Links to Dossier.index -->
                                <li class="side-nav-item direct-link">
                                    <a href="{{ route('Dossier.index') }}" class="side-nav-link">
                                        <i class="uil uil-bright"></i><span>Configuration</span>
                                    </a>
                                </li>

                                <!-- Direct Tickets Link (outside dropdown) -->
                                @if (Auth::user()->role_id != 4)
                                    @can('viewAny', App\Models\Ticket::class)
                                    <li class="side-nav-item direct-link">
                                        <a class="side-nav-link {{ ($ticketcount ?? 0) > 0 ? 'is-success' : '' }}" href="{{ route('Ticket.list') }}">
                                            <i class="uil uil-ticket"></i><span>Tickets</span>
                                            <span id="counter-ticketcount" class="count-badge">{{ $ticketcount ?? 0 }}</span>
                                        </a>
                                    </li>
                                    @endcan
                                @endif

                                <!-- Tickets A Cloturer -->
                                @can('create', App\Models\Ticket::class)
                                <li class="side-nav-item direct-link">
                                    <a class="side-nav-link {{ ($ticketcountterminer ?? 0) > 0 ? 'is-success' : '' }}" href="{{ route('Ticket.listterminer') }}">
                                        <i class="uil uil-check-circle"></i><span>Tickets A Clôturer</span>
                                        <span id="counter-ticketcountterminer" class="count-badge">{{ $ticketcountterminer ?? 0 }}</span>
                                    </a>
                                </li>
                                @endcan

                                <li class="side-nav-title side-nav-item">Gestion Dossiers</li>

                                {{-- ========== VALIDATION ========== --}}
                                @php $validationTotal = ($senddevis ?? 0) + ($sendfacture ?? 0) + ($sendrapport ?? 0); @endphp
                                @if(Auth::user()->role_id == 1 || Auth::user()->role_id == 4)
                                <li class="nav-dropdown" id="dropdown-validation">
                                    <button class="nav-dropdown-toggle" onclick="toggleDropdown('dropdown-validation')">
                                        <span class="toggle-left"><i class="uil uil-check-circle"></i>Validation</span>
                                        <span id="badge-validation" class="category-badge {{ $validationTotal == 0 ? 'zero' : '' }}">{{ $validationTotal }}</span>
                                        <i class="uil uil-angle-down dropdown-icon"></i>
                                    </button>
                                    <ul class="nav-dropdown-content">
                                        @can('devisacc', App\Models\Dashboard::class)
                                        <li id="collapse13" class="side-nav-item">
                                            <a class="side-nav-link {{ ($senddevis ?? 0) > 0 ? 'is-success' : '' }}">
                                                <span>Accord Devis</span><span id="counter-senddevis" class="count-badge">{{ $senddevis ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('factureacc', App\Models\Dashboard::class)
                                        <li id="collapse14" class="side-nav-item">
                                            <a class="side-nav-link {{ ($sendfacture ?? 0) > 0 ? 'is-success' : '' }}">
                                                <span>Accord Facture</span><span id="counter-sendfacture" class="count-badge">{{ $sendfacture ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('rapportenv', App\Models\Dashboard::class)
                                        <li id="collapse15" class="side-nav-item">
                                            <a class="side-nav-link {{ ($sendrapport ?? 0) > 0 ? 'is-success' : '' }}">
                                                <span>Accord Rapport</span><span id="counter-sendrapport" class="count-badge">{{ $sendrapport ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                    </ul>
                                </li>
                                @endif

                                {{-- ========== SUIVI DOSSIERS ========== --}}
                                @php $suiviTotal = ($enexp ?? 0) + ($aexpcount ?? 0) + ($basedoc ?? 0) + ($attdevis ?? 0) + ($attexpap ?? 0) + ($attfacture ?? 0) + ($attfactureap ?? 0) + ($attdevisav ?? 0) + ($deuxdevis ?? 0) + ($deuxfacture ?? 0); @endphp
                                @if(Auth::user()->role_id == 1 || Auth::user()->role_id == 4)
                                <li class="nav-dropdown" id="dropdown-suivi">
                                    <button class="nav-dropdown-toggle" onclick="toggleDropdown('dropdown-suivi')">
                                        <span class="toggle-left"><i class="uil uil-file-search-alt"></i>Suivi Dossiers</span>
                                        <span id="badge-suivi" class="category-badge {{ $suiviTotal == 0 ? 'zero' : '' }}">{{ $suiviTotal }}</span>
                                        <i class="uil uil-angle-down dropdown-icon"></i>
                                    </button>
                                    <ul class="nav-dropdown-content">
                                        @can('enexp', App\Models\Dashboard::class)
                                        <li id="collapse92" class="side-nav-item">
                                            <a class="side-nav-link {{ ($enexp ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente Expertise</span><span id="counter-enexp" class="count-badge">{{ $enexp ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('attphav', App\Models\Dashboard::class)
                                        <li id="collapse1" class="side-nav-item">
                                            <a class="side-nav-link {{ ($aexpcount ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente Photos</span><span id="counter-aexpcount" class="count-badge">{{ $aexpcount ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('attdocbase', App\Models\Dashboard::class)
                                        <li id="collapse72" class="side-nav-item">
                                            <a class="side-nav-link {{ ($basedoc ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente Documents</span><span id="counter-basedoc" class="count-badge">{{ $basedoc ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('attdevis', App\Models\Dashboard::class)
                                        <li id="collapse2" class="side-nav-item">
                                            <a class="side-nav-link {{ ($attdevis ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente Devis</span><span id="counter-attdevis" class="count-badge">{{ $attdevis ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('attphap', App\Models\Dashboard::class)
                                        <li id="collapse96" class="side-nav-item">
                                            <a class="side-nav-link {{ ($attexpap ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente Photos Après</span><span id="counter-attexpap" class="count-badge">{{ $attexpap ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('attfacture', App\Models\Dashboard::class)
                                        <li id="collapse3" class="side-nav-item">
                                            <a class="side-nav-link {{ ($attfacture ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente Facture</span><span id="counter-attfacture" class="count-badge">{{ $attfacture ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('factureattph', App\Models\Dashboard::class)
                                        <li id="collapse81" class="side-nav-item">
                                            <a class="side-nav-link {{ ($attfactureap ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Facture Sans Photo</span><span id="counter-attfactureap" class="count-badge">{{ $attfactureap ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('devisattpa', App\Models\Dashboard::class)
                                        <li id="collapse80" class="side-nav-item">
                                            <a class="side-nav-link {{ ($attdevisav ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Devis Sans Photo</span><span id="counter-attdevisav" class="count-badge">{{ $attdevisav ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('att2emedevis', App\Models\Dashboard::class)
                                        <li id="collapse16" class="side-nav-item">
                                            <a class="side-nav-link {{ ($deuxdevis ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente 2ème Devis</span><span id="counter-deuxdevis" class="count-badge">{{ $deuxdevis ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('att2emefacture', App\Models\Dashboard::class)
                                        <li id="collapse17" class="side-nav-item">
                                            <a class="side-nav-link {{ ($deuxfacture ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente 2ème Facture</span><span id="counter-deuxfacture" class="count-badge">{{ $deuxfacture ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                    </ul>
                                </li>
                                @endif

                                {{-- ========== A TRAITER ========== --}}
                                @php $traiterTotal = ($traitdevis ?? 0) + ($traitfacture ?? 0) + ($count ?? 0) + ($count2 ?? 0); @endphp
                                @if(Auth::user()->role_id == 1 || Auth::user()->role_id == 2 || Auth::user()->role_id == 4)
                                <li class="nav-dropdown" id="dropdown-traiter">
                                    <button class="nav-dropdown-toggle" onclick="toggleDropdown('dropdown-traiter')">
                                        <span class="toggle-left"><i class="uil uil-file-edit-alt"></i>A Traiter</span>
                                        <span id="badge-traiter" class="category-badge {{ $traiterTotal == 0 ? 'zero' : '' }}">{{ $traiterTotal }}</span>
                                        <i class="uil uil-angle-down dropdown-icon"></i>
                                    </button>
                                    <ul class="nav-dropdown-content">
                                        @can('traitdevis', App\Models\Dashboard::class)
                                        <li id="collapse77" class="side-nav-item">
                                            <a class="side-nav-link {{ ($traitdevis ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Devis à Traiter</span><span id="counter-traitdevis" class="count-badge">{{ $traitdevis ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('traitfacture', App\Models\Dashboard::class)
                                        <li id="collapse9" class="side-nav-item">
                                            <a class="side-nav-link {{ ($traitfacture ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Facture à Traiter</span><span id="counter-traitfacture" class="count-badge">{{ $traitfacture ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('retraitdevis', App\Models\Dashboard::class)
                                        <li id="collapse5" class="side-nav-item">
                                            <a class="side-nav-link {{ ($count ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Devis à Retraiter</span><span id="counter-count" class="count-badge">{{ $count ?? 0 }}</span>
                                            </a>
                                        </li>
                                        <li id="collapse6" class="side-nav-item">
                                            <a class="side-nav-link {{ ($count2 ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Facture à Retraiter</span><span id="counter-count2" class="count-badge">{{ $count2 ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                    </ul>
                                </li>
                                @endif

                                {{-- ========== RAPPORT ========== --}}
                                @php $rapportTotal = ($attrapport ?? 0) + ($count3 ?? 0) + ($sendrapport ?? 0) + ($deuxrapport ?? 0); @endphp
                                @if(Auth::user()->role_id == 1 || Auth::user()->role_id == 4)
                                <li class="nav-dropdown" id="dropdown-rapport">
                                    <button class="nav-dropdown-toggle" onclick="toggleDropdown('dropdown-rapport')">
                                        <span class="toggle-left"><i class="uil uil-file-check-alt"></i>Rapport</span>
                                        <span id="badge-rapport" class="category-badge {{ $rapportTotal == 0 ? 'zero' : '' }}">{{ $rapportTotal }}</span>
                                        <i class="uil uil-angle-down dropdown-icon"></i>
                                    </button>
                                    <ul class="nav-dropdown-content">
                                        @can('attrapport', App\Models\Dashboard::class)
                                        <li id="collapse4" class="side-nav-item">
                                            <a class="side-nav-link {{ ($attrapport ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Attente Rapport</span><span id="counter-attrapport" class="count-badge">{{ $attrapport ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('instacerapport', App\Models\Dashboard::class)
                                        <li id="collapse95" class="side-nav-item">
                                            <a class="side-nav-link {{ ($count3 ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Instance Rapport</span><span id="counter-count3" class="count-badge">{{ $count3 ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('rapportenv', App\Models\Dashboard::class)
                                        <li id="collapse15b" class="side-nav-item">
                                            <a class="side-nav-link {{ ($sendrapport ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Rapport à Envoyer</span><span id="counter-sendrapport2" class="count-badge">{{ $sendrapport ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('rapportref', App\Models\Dashboard::class)
                                        <li id="collapse05" class="side-nav-item">
                                            <a class="side-nav-link {{ ($deuxrapport ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Rapport Refusé</span><span id="counter-deuxrapport" class="count-badge">{{ $deuxrapport ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                    </ul>
                                </li>
                                @endif

                                {{-- ========== A SIGNER ========== --}}
                                @php $signerTotal = ($rapportasigner ?? 0) + ($docasigner ?? 0) + ($docsigner ?? 0); @endphp
                                <li class="nav-dropdown" id="dropdown-signer">
                                    <button class="nav-dropdown-toggle" onclick="toggleDropdown('dropdown-signer')">
                                        <span class="toggle-left"><i class="uil uil-pen"></i>A Signer</span>
                                        <span id="badge-signer" class="category-badge {{ $signerTotal == 0 ? 'zero' : '' }}">{{ $signerTotal }}</span>
                                        <i class="uil uil-angle-down dropdown-icon"></i>
                                    </button>
                                    <ul class="nav-dropdown-content">
                                        @can('rappsigner', App\Models\Dashboard::class)
                                        <li id="collapse8" class="side-nav-item">
                                            <a class="side-nav-link {{ ($rapportasigner ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Rapport à Signer</span><span id="counter-rapportasigner" class="count-badge">{{ $rapportasigner ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('docasigner', App\Models\Dashboard::class)
                                        <li id="collapse50" class="side-nav-item">
                                            <a class="side-nav-link {{ ($docasigner ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Documents à Signer</span><span id="counter-docasigner" class="count-badge">{{ $docasigner ?? 0 }}</span>
                                            </a>
                                        </li>
                                        <li id="collapse88" class="side-nav-item">
                                            <a class="side-nav-link {{ ($docsigner ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Documents Signés</span><span id="counter-docsigner" class="count-badge">{{ $docsigner ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                    </ul>
                                </li>

                                {{-- ========== CONTRÔLE ========== --}}
                                @php $controleTotal = ($controldevis ?? 0) + ($avisdevis ?? 0) + ($avisfacture ?? 0); @endphp
                                <li class="nav-dropdown" id="dropdown-controle">
                                    <button class="nav-dropdown-toggle" onclick="toggleDropdown('dropdown-controle')">
                                        <span class="toggle-left"><i class="uil uil-search"></i>Contrôle</span>
                                        <span id="badge-controle" class="category-badge {{ $controleTotal == 0 ? 'zero' : '' }}">{{ $controleTotal }}</span>
                                        <i class="uil uil-angle-down dropdown-icon"></i>
                                    </button>
                                    <ul class="nav-dropdown-content">
                                        @can('controldevis', App\Models\Dashboard::class)
                                        <li id="collapse93" class="side-nav-item">
                                            <a class="side-nav-link {{ ($controldevis ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Devis à Contrôler</span><span id="counter-controldevis" class="count-badge">{{ $controldevis ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('avisdevis', App\Models\Dashboard::class)
                                        <li id="collapse10" class="side-nav-item">
                                            <a class="side-nav-link {{ ($avisdevis ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Demande Avis Devis</span><span id="counter-avisdevis" class="count-badge">{{ $avisdevis ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('avisfacture', App\Models\Dashboard::class)
                                        <li id="collapse11" class="side-nav-item">
                                            <a class="side-nav-link {{ ($avisfacture ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Demande Avis Facture</span><span id="counter-avisfacture" class="count-badge">{{ $avisfacture ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                    </ul>
                                </li>

                                {{-- ========== DEMANDE ========== --}}
                                @can('demandes', App\Models\Dashboard::class)
                                <li class="side-nav-item direct-link">
                                    <a href="{{ route('Demande.index') }}" class="side-nav-link {{ ($demandes ?? 0) > 0 ? 'has-count' : '' }}">
                                        <i class="uil uil-envelope"></i><span>Demandes</span>
                                        <span id="counter-demandes" class="count-badge">{{ $demandes ?? 0 }}</span>
                                    </a>
                                </li>
                                @endcan

                                {{-- ========== DIVERS ========== --}}
                                @php $diversTotal = ($douteux ?? 0) + ($tribunale ?? 0) + ($rdv ?? 0) + ($rapide ?? 0); @endphp
                                <li class="nav-dropdown" id="dropdown-divers">
                                    <button class="nav-dropdown-toggle" onclick="toggleDropdown('dropdown-divers')">
                                        <span class="toggle-left"><i class="uil uil-layer-group"></i>Divers</span>
                                        <span id="badge-divers" class="category-badge {{ $diversTotal == 0 ? 'zero' : '' }}">{{ $diversTotal }}</span>
                                        <i class="uil uil-angle-down dropdown-icon"></i>
                                    </button>
                                    <ul class="nav-dropdown-content">
                                        @can('douteux', App\Models\Dashboard::class)
                                        <li id="collapse20" class="side-nav-item">
                                            <a class="side-nav-link {{ ($douteux ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Dossiers Douteux</span><span id="counter-douteux" class="count-badge">{{ $douteux ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('tribunale', App\Models\Dashboard::class)
                                        <li id="collapse21" class="side-nav-item">
                                            <a class="side-nav-link {{ ($tribunale ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Tribunal</span><span id="counter-tribunale" class="count-badge">{{ $tribunale ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('rdv', App\Models\Dashboard::class)
                                        <li class="side-nav-item">
                                            <a href="{{ route('RendezVous.index') }}" class="side-nav-link {{ ($rdv ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Rendez-Vous</span><span id="counter-rdv" class="count-badge">{{ $rdv ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @if (Auth::user()->role_id != 3 && Auth::user()->role_id != 6)
                                        @can('rapide', App\Models\Dashboard::class)
                                        <li id="collapse71" class="side-nav-item">
                                            <a class="side-nav-link {{ ($rapide ?? 0) > 0 ? 'has-count' : '' }}">
                                                <span>Dossier Rapide</span><span id="counter-rapide" class="count-badge">{{ $rapide ?? 0 }}</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @endif
                                    </ul>
                                </li>

                                {{-- ========== DOSSIERS A FACTURER ========== --}}
                                @if (Auth::user()->role_id == 3 || Auth::user()->role_id == 4)
                                @can('afacturé', App\Models\Dashboard::class)
                                <li id="collapse85" class="side-nav-item direct-link">
                                    <a class="side-nav-link {{ ($dossiersfacture ?? 0) > 0 ? 'has-count' : '' }}">
                                        <i class="uil uil-receipt"></i><span>Dossiers à Facturer</span>
                                        <span id="counter-dossiersfacture" class="count-badge">{{ $dossiersfacture ?? 0 }}</span>
                                    </a>
                                </li>
                                @endcan
                                @endif

                            </ul>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="simplebar-placeholder" style="width: auto; height: 1518px;"></div>
        </div>
        <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
            <div class="simplebar-scrollbar" style="width: 0px; display: none;"></div>
        </div>
        <div class="simplebar-track simplebar-vertical" style="visibility: visible;">
            <div class="simplebar-scrollbar" style="height: 114px; transform: translate3d(0px, 0px, 0px); display: block;"></div>
        </div>
    </div>

    <script>
        function toggleDropdown(id) {
            event.stopPropagation();
            var dropdown = document.getElementById(id);
            if (dropdown) {
                dropdown.classList.toggle('open');
            }
        }

        // Mobile sidebar toggle
        function closeSidebar() {
            document.body.classList.remove('sidebar-open');
        }

        // Sidebar counters - Auto refresh system
        (function() {
            var REFRESH_INTERVAL = 15000; // 15 seconds - frequent enough to feel real-time
            var refreshTimer = null;

            // Load counters from API
            function loadSidebarCounters() {
                fetch('/api/sidebar/counts', {
                    method: 'GET',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    },
                    credentials: 'same-origin'
                })
                .then(function(response) { return response.json(); })
                .then(function(data) { updateCounters(data); })
                .catch(function(error) { console.log('Counter refresh failed:', error); });
            }

            // Update all counter badges in the DOM
            function updateCounters(data) {
                var counterMap = {
                    'counter-senddevis': data.senddevis,
                    'counter-sendfacture': data.sendfacture,
                    'counter-sendrapport': data.sendrapport,
                    'counter-sendrapport2': data.sendrapport,
                    'counter-enexp': data.enexp,
                    'counter-aexpcount': data.aexpcount,
                    'counter-basedoc': data.basedoc,
                    'counter-attdevis': data.attdevis,
                    'counter-attexpap': data.attexpap,
                    'counter-attfacture': data.attfacture,
                    'counter-attfactureap': data.attfactureap,
                    'counter-attdevisav': data.attdevisav,
                    'counter-deuxdevis': data.deuxdevis,
                    'counter-deuxfacture': data.deuxfacture,
                    'counter-traitdevis': data.traitdevis,
                    'counter-traitfacture': data.traitfacture,
                    'counter-count': data.count,
                    'counter-count2': data.count2,
                    'counter-attrapport': data.attrapport,
                    'counter-count3': data.count3,
                    'counter-deuxrapport': data.deuxrapport,
                    'counter-rapportasigner': data.rapportasigner,
                    'counter-docasigner': data.docasigner,
                    'counter-docsigner': data.docsigner,
                    'counter-controldevis': data.controldevis,
                    'counter-avisdevis': data.avisdevis,
                    'counter-avisfacture': data.avisfacture,
                    'counter-douteux': data.douteux,
                    'counter-tribunale': data.tribunale,
                    'counter-rdv': data.rdv,
                    'counter-rapide': data.rapide,
                    'counter-ticketcount': data.ticketcount,
                    'counter-ticketcountterminer': data.ticketcountterminer,
                    'counter-demandes': data.demandes,
                    'counter-dossiersfacture': data.dossiersfacture
                };

                for (var id in counterMap) {
                    var el = document.getElementById(id);
                    if (el) {
                        var value = counterMap[id] || 0;
                        var oldValue = parseInt(el.textContent) || 0;
                        
                        // Only update if changed
                        if (value !== oldValue) {
                            el.textContent = value;
                            
                            // Flash animation on change
                            el.style.transform = 'scale(1.2)';
                            setTimeout(function(element) {
                                element.style.transform = 'scale(1)';
                            }, 200, el);
                            
                            // Update parent link styling
                            var link = el.closest('.side-nav-link');
                            if (link) {
                                if (value > 0) {
                                    link.classList.add('has-count');
                                } else {
                                    link.classList.remove('has-count');
                                    link.classList.remove('is-success');
                                }
                            }
                        }
                    }
                }

                // Update category totals
                updateCategoryBadge('badge-validation', (data.senddevis || 0) + (data.sendfacture || 0) + (data.sendrapport || 0));
                updateCategoryBadge('badge-suivi', (data.enexp || 0) + (data.aexpcount || 0) + (data.basedoc || 0) + (data.attdevis || 0) + (data.attexpap || 0) + (data.attfacture || 0) + (data.attfactureap || 0) + (data.attdevisav || 0) + (data.deuxdevis || 0) + (data.deuxfacture || 0));
                updateCategoryBadge('badge-traiter', (data.traitdevis || 0) + (data.traitfacture || 0) + (data.count || 0) + (data.count2 || 0));
                updateCategoryBadge('badge-rapport', (data.attrapport || 0) + (data.count3 || 0) + (data.sendrapport || 0) + (data.deuxrapport || 0));
                updateCategoryBadge('badge-signer', (data.rapportasigner || 0) + (data.docasigner || 0) + (data.docsigner || 0));
                updateCategoryBadge('badge-controle', (data.controldevis || 0) + (data.avisdevis || 0) + (data.avisfacture || 0));
                updateCategoryBadge('badge-divers', (data.douteux || 0) + (data.tribunale || 0) + (data.rdv || 0) + (data.rapide || 0));
            }

            function updateCategoryBadge(id, total) {
                var badge = document.getElementById(id);
                if (badge) {
                    var oldValue = parseInt(badge.textContent) || 0;
                    if (total !== oldValue) {
                        badge.textContent = total;
                        badge.style.transform = 'scale(1.1)';
                        setTimeout(function() { badge.style.transform = 'scale(1)'; }, 200);
                    }
                    if (total === 0) {
                        badge.classList.add('zero');
                    } else {
                        badge.classList.remove('zero');
                    }
                }
            }

            // Start auto-refresh
            function startAutoRefresh() {
                if (refreshTimer) clearInterval(refreshTimer);
                refreshTimer = setInterval(loadSidebarCounters, REFRESH_INTERVAL);
            }

            // Stop auto-refresh (when tab is hidden)
            function stopAutoRefresh() {
                if (refreshTimer) {
                    clearInterval(refreshTimer);
                    refreshTimer = null;
                }
            }

            // Initialize
            document.addEventListener('DOMContentLoaded', function() {
                // Create overlay for mobile
                var overlay = document.createElement('div');
                overlay.className = 'sidebar-overlay';
                overlay.onclick = closeSidebar;
                document.body.appendChild(overlay);
                
                // Load counters immediately
                loadSidebarCounters();
                
                // Start auto-refresh
                startAutoRefresh();
                
                // Refresh when tab becomes visible again
                document.addEventListener('visibilitychange', function() {
                    if (document.visibilityState === 'visible') {
                        loadSidebarCounters(); // Immediate refresh
                        startAutoRefresh();
                    } else {
                        stopAutoRefresh(); // Save resources when tab hidden
                    }
                });
                
                // Refresh when window gains focus
                window.addEventListener('focus', function() {
                    loadSidebarCounters();
                });
            });

            // Close sidebar on escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') closeSidebar();
            });

            // Expose for manual refresh if needed
            window.refreshSidebarCounters = loadSidebarCounters;
        })();
    </script>

    <!-- Mobile Close Button -->
    <style>
        .sidebar-close-btn {
            display: none;
        }
        
        @media (max-width: 767.98px) {
            .sidebar-close-btn {
                display: flex;
                align-items: center;
                justify-content: center;
                position: absolute;
                top: 15px;
                right: 15px;
                width: 36px;
                height: 36px;
                background: rgba(255, 255, 255, 0.1);
                border: none;
                border-radius: 8px;
                color: #fff;
                font-size: 20px;
                cursor: pointer;
                z-index: 101;
                transition: all 0.2s ease;
            }
            
            .sidebar-close-btn:hover {
                background: rgba(255, 255, 255, 0.2);
            }
            
            /* Clickable overlay */
            .sidebar-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 1050;
                cursor: pointer;
            }
            
            body.sidebar-open .sidebar-overlay {
                display: block;
            }
        }
    </style>

</div>