<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\Company;
use App\Models\Garage;
use App\Models\GarageService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GarageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny',Garage::class);
        $garages= Garage::all();
        return view('configuration.Garage.index',compact('garages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create',Garage::class);
        $cities = City::all();
        return view('configuration.Garage.create',compact('cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create',Garage::class);

        $request->validate([
            'email'=>'required|email|unique:garages,email',
            'libelle'=>'required|string',
            'adress'=>'string|required',
            'city'=>'required',
            'tel'=>'nullable|unique:garages,tel',

        ]);
        if($request->verified === "on"){
            $check=1;
        }
        else{
            $check=0;
        }

        Garage::create([
            'email'=>$request->email,
            'adress'=>$request->adress,
            'libelle'=>$request->libelle,
            'tel'=>$request->tel,
            'lng'=>$request->lng,
            'lat'=>$request->lat,
            'city_id'=>$request->city,
            'user_id'=>Auth::user()->id,
            'url'=>$request->url,
            'verified'=>$check
        ]);

        return  redirect()->route('Garage.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Garage  $garage
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('view',Garage::class);

        $garage = Garage::whereId($id)->with('city','garageservice')->firstOrFail();
        $services = GarageService::all();
        $companies = Company::all();
        return view('configuration.Garage.show',compact('garage','services','companies'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Garage  $garage
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update',Garage::class);
        $garage = Garage::whereId($id)->with('city','garageservice')->firstOrFail();
        $cities = City::where('id','!=',$garage->city->id)->get();
        return view('configuration.Garage.edit',compact('garage','cities'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Garage  $garage
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update',Garage::class);

        $request->validate([
            'email'=>'required|email|unique:garages,email,'.$id.'',
            'libelle'=>'required|string',
            'adress'=>'string|required',
            'city'=>'required',
            
        ]);
        if($request->verified === "on"){
            $check=1;
        }
        else{
            $check=0;
        }


        $garage = Garage::whereId($id)->firstOrFail();
        $garage->email = $request->email;
        $garage->adress= $request->adress;
        $garage->libelle= $request->libelle;
        $garage->lng= $request->lng;
        $garage->lat= $request->lat;
        $garage->tel= $request->tel;
        $garage->city_id= $request->city;
        $garage->user_id= Auth::user()->id;
        $garage->url = $request->url;
        $garage->verified=$check;
        $garage->update();

        return redirect()->route('Garage.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Garage  $garage
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $garage = Garage::whereId($id)->firstOrFail();
        $garage->delete();
        return redirect()->route('Garage.index');

    }
    public function deleted()
    {
        $garages = Garage::onlyTrashed()->get();

       return view('configuration.Garage.deleted',compact('garages')) ;
    }

    public function restore($id)
    {
        $this->authorize('restore',Garage::class);

        Garage::withTrashed()->find($id)->restore();
         return redirect()->route('Garage.index');
    }

}
