<?php

namespace App\Http\Controllers;

use App\Models\Document;
use App\Models\Dossier;
use App\Models\ShockPoint;
use App\Models\TypeDocument;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ShockPointController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $shockpoints =  ShockPoint::all();
        return view('configuration.Types.point.index', compact('shockpoints'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $dossier = Dossier::where('id',$id)->with('shockpoint')->first();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        return view('dossiers.chock', compact('dossier'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($request->has('points')) {
            $points = array_map("intval", explode(",", $request->points));
            $dossier = Dossier::whereId($request->dossier_id)->first();
            if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
                return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
            }

            $dossier->shockpoint()->detach();
            $point = ShockPoint::whereIn('id', $points)->get();
            foreach ($point as $p) {
                $spoint = ShockPoint::findOrFail($p->id);
                $dossier->shockpoint()->syncWithoutDetaching($spoint);
            }
            if ($request->img) {
                $type = TypeDocument::whereId('18')->first();
                $array = explode(",", $request->img);
                    $image = base64_decode($array[1]);
                    $filename = uniqid() . '.' . 'png';
                    Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type .'/'. $filename, $image);
                    $path = 'documents/' . $dossier->ref . '/' . $type->type. '/' . $filename;

                    Document::updateOrCreate(['dossier_id' => $dossier->id,'type_document_id' => $type->id],[
                        'path' => $path,
                    ]);

            }
        }
        return redirect()->route('Dossier.show',$dossier->id);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ShockPoint  $shockPoint
     * @return \Illuminate\Http\Response
     */
    public function show(ShockPoint $shockPoint)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ShockPoint  $shockPoint
     * @return \Illuminate\Http\Response
     */
    public function edit(ShockPoint $shockPoint)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ShockPoint  $shockPoint
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ShockPoint $shockPoint)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ShockPoint  $shockPoint
     * @return \Illuminate\Http\Response
     */
    public function destroy(ShockPoint $shockPoint)
    {
        //
    }
}
