<?php

namespace App\Http\Controllers;

use App\Models\TypeDossier;
use Illuminate\Http\Request;

class TypeDossierController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $typedossiers= TypeDossier::all();
        return view('configuration.Types.dossier.index',compact('typedossiers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.Types.dossier.create');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'type'=>'required|unique:type_dossiers,type'
        ]);

        TypeDossier::create([
            'type'=>$request->type
        ]);
        return redirect()->route('TypeDossier.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TypeDossier  $typeDossier
     * @return \Illuminate\Http\Response
     */
    public function show(TypeDossier $typeDossier)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TypeDossier  $typeDossier
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $typedossier = TypeDossier::findOrFail($id);
        return view('configuration.Types.dossier.edit',compact('typedossier'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TypeDossier  $typeDossier
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'type'=>'required|unique:type_dossiers,type,'.$id.''
        ]);
        $typeDossier = TypeDossier::findOrFail($id);
        $typeDossier->type = $request->type;
        $typeDossier->update();
        return redirect()->route('TypeDossier.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TypeDossier  $typeDossier
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $typeDossier = TypeDossier::findOrFail($id);
        $typeDossier->delete();
        return redirect()->route('TypeDossier.index');
    }

    public function deleted()
    {
        $TypeDossiers = TypeDossier::onlyTrashed()->get();
        //dd($guarantees);
       return view('configuration.Types.dossier.deleted',compact('TypeDossiers')) ;
    }

    public function restore($id)
    {
        TypeDossier::withTrashed()->find($id)->restore();
        return redirect()->route('TypeExpert.index');

    }
}
