<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DevisStatus extends Model
{
    use HasFactory;

    protected $fillable=['status'];

    public function devis()
    {
        return $this->hasMany(Devis::class);
    }
    public function devisstatus()
    {
        return $this->belongsToMany(Devis::class,'devis_status');
    }
    public function facturestatus()
    {
        return $this->belongsToMany(Facture::class,'facture_status');
    }
    public function rapport()
    {
        return $this->hasMany(Rapport::class,'status_id');
    }
    public function facture()
    {
        return $this->hasMany(Facture::class,'status_id');
    }

}
