@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des Rendez Vous</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Ref Dossier</th>
                                        <th>Motif</th>
                                        <th>Type</th>
                                        <th>Status</th>
                                        <th>Modifier</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($rdvs as $rdv)
                                        <tr>
                                            <td>{{ $rdv->id }}</td>
                                            <td>{{ $rdv->ref }}</td>
                                            <td>{{ $rdv->motif }}</td>
                                            <td>{{ $rdv->typerendezvous->type }}</td>
                                            <td> <span class="badge bg-{{$rdv->statusrendezvous->color}}">{{ $rdv->statusrendezvous->status }}</span></td>
                                            <td> <a href="{{ route('RendezVous.show',$rdv->id) }}" class="btn btn-sm btn-info rounded-pill"><i class="uil uil-pen"></i></button> </a>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
