<div>
    <div class="card mb-3">
        <div class="card-body">
            <form wire:submit.prevent="createStep()" method="post" enctype="multipart/form-data" autocomplete="off">
                @csrf
                <div id="basicwizard">
                    <ul class="nav nav-pills nav-justified form-wizard-header mb-4">

                        <li class="nav-item">
                            <a data-bs-toggle="tab" data-toggle="tab"
                                class="nav-link rounded-0 pt-2 pb-2 {{ $count == 0 ? 'active' : '' }}">
                                <i class="mdi mdi-car me-1"></i>
                                <span class="d-none d-sm-inline">Assuré</span>
                            </a>
                        </li>

                        {{-- <li class="nav-item" >
                            <a  data-bs-toggle="tab" data-toggle="tab"
                             class="nav-link rounded-0 pt-2 pb-2 {{ $count == 1 ? 'active' : '' }}" >
                                <i class="mdi mdi-human-male me-1"></i>
                                <span class="d-none d-sm-inline">Assuré</span>
                            </a>
                        </li> --}}

                        <li class="nav-item" wire:click="">
                            <a data-bs-toggle="tab" data-toggle="tab"
                                class="nav-link rounded-0 pt-2 pb-2 {{ $count == 1 ? 'active' : '' }}">
                                <i class="mdi mdi-shield me-1"></i>
                                <span class="d-none d-sm-inline">Vehicule</span>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a data-bs-toggle="tab" data-toggle="tab"
                                class="nav-link rounded-0 pt-2 pb-2 {{ $count == 2 ? 'active' : '' }}">
                                <i class="mdi mdi-human-handsup me-1"></i>
                                <span class="d-none d-sm-inline">Adversaire</span>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a data-bs-toggle="tab" data-toggle="tab"
                                class="nav-link rounded-0 pt-2 pb-2 {{ $count == 3 ? 'active' : '' }}">
                                <i class="mdi mdi-file me-1"></i>
                                <span class="d-none d-sm-inline">Documents</span>
                            </a>
                        </li>
                        {{-- <li class="nav-item">
                            <a data-bs-toggle="tab" data-toggle="tab"
                                class="nav-link rounded-0 pt-2 pb-2 {{ $count == 4 ? 'active' : '' }}">
                                <i class="mdi mdi-file me-1"></i>
                                <span class="d-none d-sm-inline">Point de chock</span>
                            </a>
                        </li> --}}
                    </ul>

                    <div class="tab-content b-0 mb-0">
                        <div class="tab-pane {{ $count == 0 ? 'active' : '' }}" id="basictab1">
                            <div class="row g-2">

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Matricule WW<span style="color: #ff1212"><span
                                                style="color: rgb(148, 148, 148)">()</span></span>:</label>
                                    <input type="text" name="new_matricule"
                                        class="form-control @error('new_matricule') is-invalid @enderror"
                                        placeholder="Entrer le matricule WW: 000000"
                                        value="{{ $selectedDossier ? $selectedDossier['new_matricule'] : '' }}"
                                        wire:model="new_matricule">

                                    @error('new_matricule')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror

                                    @if ($dossiers1 && $dossiers1->count() > 0)
                                        <div class="text-right">
                                            <small class="text-dark">Un ou plusieurs dossier ont ce matricule</small>
                                            <a href="#" wire:click="toggleTable()">
                                                <small>{{ $hidden ? 'Afficher' : 'Reduire' }}</small>
                                            </a>
                                        </div>
                                    @endif

                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Matricule <span style="color: #ff1212"><span
                                                style="color: rgb(148, 148, 148)">()</span></span>:</label>
                                    <input type="text" name="matricule"
                                        class="form-control @error('matricule') is-invalid @enderror"
                                        placeholder="Entrer le matricule: 00000-A-00" wire:model="matricule"
                                        value="{{ $selectedDossier ? $selectedDossier['matricule'] : '' }}"
                                        wire:model="matricule">

                                    @error('matricule')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror

                                    @if ($dossiers && $dossiers->count() > 0)
                                        <div class="text-right">
                                            <small class="text-dark">Un ou plusieurs dossier ont ce matricule</small>
                                            <a href="#" wire:click="toggleTable()">
                                                <small>{{ $hidden ? 'Afficher' : 'Reduire' }}</small>
                                            </a>
                                        </div>
                                    @endif
                                </div>

                                <div class="mb-3 col-md-4 position-relative" id="sinistre">
                                    <label class="form-label" for="date_sinistre">Date de Sinistre <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <input type="date"
                                        class="form-control @error('date_sinistre') is-invalid @enderror"
                                        name="date_sinistre" id="date_sinistre" wire:model="date_sinistre">

                                    @error('date_sinistre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <br>
                                <br>
                                <hr>
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Civilité :</label>
                                    <select name="civility" wire:model="civility"
                                        class="form-control @error('civility') is-invalid @enderror" id="civility">
                                        <option value="" selected>Selectionner une valeur</option>
                                        <option value="Mr">Monsieur</option>
                                        <option value="Mme">Madame</option>
                                        <option value="Sociéte">Sociéte</option>

                                    </select>

                                    @error('civility')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Nom Assuré <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <input type="text" name="name"
                                        class="form-control @error('name') is-invalid @enderror"
                                        placeholder="Entrer le nom de l'assuré" wire:model="name">

                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Téléphone Assuré <span
                                            style="color: rgb(148, 148, 148)"></span> :</label>
                                    <div class="input-group mb-2">
                                        <input type="tel" name="telephone"
                                            class="form-control @error('telephone') is-invalid @enderror"
                                            min="10" max="10" placeholder="0611223355"
                                            wire:model="telephone">
                                        @error('telephone')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    {{--
                                    <label class="form-label">Téléphone Assuré:</label>
                                    <input type="text" name="telephone"
                                        class="form-control @error('telephone') is-invalid @enderror"
                                        placeholder="Entrer le téléphone de l'assuré" wire:model="telephone"> --}}


                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Numero de Police</label>
                                    <input type="text" name="numero_police"
                                        class="form-control @error('numero_police') is-invalid @enderror"
                                        placeholder="Entrer le numero de police" wire:model="numero_police">

                                    @error('numero_police')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <br>
                                <br>

                                <div class="mb-3 col-md-4">
                                    <label for="type_vehicule_id" class="form-label">Type de Vehicule :</label>
                                    <select name="type_vehicule_id" id="type_vehicule_id"
                                        class="form-control @error('type_vehicule_id') is-invalid @enderror"
                                        wire:model="type_vehicule_id">
                                        <option value="" selected>Selectionner un Type</option>
                                        @foreach ($typevehicules as $type)
                                            <option value="{{ $type->id }}">{{ $type->type }}</option>
                                        @endforeach
                                    </select>
                                    @error('type_vehicule_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label for="brand_id" class="form-label">Marque de Vehicule :</label>
                                    <select name="brand_id" id="brand_id"
                                        class="form-control @error('brand_id') is-invalid @enderror"
                                        wire:model="selectedBrand">
                                        <option value="" selected>Selectionner une marque</option>
                                        @foreach ($brands as $brand)
                                            <option value="{{ $brand->id }}">{{ $brand->brand }}</option>
                                        @endforeach
                                    </select>
                                    @error('brand_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label for="vehicule_model_id" class="form-label">Modele de Vehicule :</label>
                                    <select name="vehicule_model_id" id="vehicule_model_id"
                                        class="form-control @error('vehicule_model_id') is-invalid @enderror"
                                        wire:model="vehicule_model_id">
                                        <option value="" selected>Selectionner un model</option>
                                        @if ($models)
                                            @foreach ($models as $model)
                                                <option value="{{ $model->id }}">{{ $model->name }}</option>
                                            @endforeach
                                        @endif

                                        @error('vehicule_model_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </select>
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Garantie :</label>
                                    <select id="guarantee_id" name="guarantee_id"
                                        class="form-control @error('guarantee_id') is-invalid @enderror"
                                        wire:model="guarantee_id">
                                        <option value="" selected>Selectionner la garantie</option>
                                        @if ($warranties)
                                            @foreach ($warranties as $warranty)
                                                <option value="{{ $warranty->id }}">{{ $warranty->guarantee }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>

                                    @error('guarantee_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label" for="numero_sinistre">Numero de sinistre <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <input type="text"
                                        class="form-control @error('numero_sinistre') is-invalid @enderror"
                                        name="numero_sinistre" id="numero_sinistre" wire:model="numero_sinistre">

                                    @error('numero_sinistre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4">

                                    <label for="intermidiaire_id" class="form-label">Nom Intermidiaire :</label>
                                    <select name="intermidiaire_id" id="mySelect" data-live-search="true"
                                        class="form-control selectpicker @error('intermidiaire_id') is-invalid @enderror"
                                        wire:model="intermidiaire_id">
                                        <option value="" selected>Selectionner Intermidiaire</option>
                                        @foreach ($intermidiaires as $intermidiaire)
                                            <option value="{{ $intermidiaire->id }}">{{ $intermidiaire->company }}
                                            </option>
                                        @endforeach

                                    </select>

                                    @error('intermidiaire_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label for="company_id" class="form-label"> Compagnie <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <select name="company_id" id="company_id"
                                        class="form-control @error('company_id') is-invalid @enderror"
                                        wire:model="company_id">
                                        <option value="" selected>Selectionner le nom de la Compagnie</option>
                                        @foreach ($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->company }}</option>
                                        @endforeach
                                    </select>

                                    @error('company_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4 position-relative" id="reception">
                                    <label class="form-label" for="date_reception">Date de Reception <span
                                            style="color: rgb(148, 148, 148)">*</span>:</label>
                                    <input type="date"
                                        class="form-control @error('date_reception') is-invalid @enderror"
                                        name="date_reception" id="date_reception" wire:model="date_reception">

                                    @error('date_reception')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                {{--   --}}

                            </div>
                        </div>

                        {{-- <div class="tab-pane {{ $count == 1 ? 'active' : '' }}" id="basictab2">
                            <div class="row g-2">

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Civilité:</label>
                                    <select name="civility"
                                        class="form-control @error('civility') is-invalid @enderror" id="civility"
                                        wire:model="civility">
                                        <option  selected>Selectionner une valeur</option>
                                        <option value="Mr">Monsieur</option>
                                        <option value="Mme">Madame</option>
                                    </select>

                                    @error('civility')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Nom Assuré:</label>
                                    <input type="text" name="name"
                                        class="form-control @error('name') is-invalid @enderror"
                                        placeholder="Entrer le nom de l'assuré" wire:model="name">

                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Téléphone Assuré:</label>
                                    <input type="text" name="telephone"
                                        class="form-control @error('telephone') is-invalid @enderror"
                                        placeholder="Entrer le téléphone de l'assuré" wire:model="telephone">

                                    @error('telephone')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Numero de Police</label>
                                    <input type="text" name="numero_police"
                                        class="form-control @error('numero_police') is-invalid @enderror"
                                        placeholder="Entrer le numero de police" wire:model="numero_police">

                                    @error('numero_police')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                            </div>
                        </div> --}}

                        <div class="tab-pane {{ $count == 1 ? 'active' : '' }}" id="basictab3">
                            <div class="row g-2">

                                {{-- <div class="mb-3 col-md-6">

                                    <label for="intermidiaire_id" class="form-label">Nom Intermidiaire :</label>
                                    <select name="intermidiaire_id" id="intermidiaire_id" data-live-search="true"
                                        class="form-control selectpicker @error('intermidiaire_id') is-invalid @enderror"
                                        wire:model="intermidiaire_id">
                                        <option value="" selected>Selectionner Intermidiaire</option>
                                        @foreach ($intermidiaires as $intermidiaire)
                                            <option value="{{ $intermidiaire->id }}">{{ $intermidiaire->company }}
                                            </option>
                                        @endforeach

                                    </select>

                                    @error('intermidiaire_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="company_id" class="form-label"> Compagnie <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <select name="company_id" id="company_id"
                                        class="form-control @error('company_id') is-invalid @enderror"
                                        wire:model="company_id">
                                        <option value="" selected>Selectionner le nom de la Compagnie</option>
                                        @foreach ($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->company }}</option>
                                        @endforeach
                                    </select>

                                    @error('company_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div> --}}
                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Mode <span style="color: rgb(148, 148, 148)">*</span>
                                        :</label>
                                    <select id="mode_id" name="mode_id"
                                        class="form-control @error('mode_id') is-invalid @enderror"
                                        wire:model="mode_id">
                                        <option value="" selected>Selectionner Mode :</option>
                                        @if ($dossierTypes)
                                            @foreach ($dossierTypes as $type)
                                                <option value="{{ $type->id }}">{{ $type->mode }}</option>
                                            @endforeach
                                        @endif
                                    </select>

                                    @error('mode_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Numero de chassis :</label>
                                    <input type="text" name="chassis_number"
                                        class="form-control @error('chassis_number') is-invalid @enderror"
                                        placeholder="Entrer le numero de chassis" wire:model="chassis_number">

                                    @error('chassis_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>



                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Type Expertise <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <select id="type_expertise_id" name="type_expertise_id"
                                        class="form-control @error('type_expertise_id') is-invalid @enderror"
                                        wire:model="type_expertise_id">
                                        <option value="" selected>Selectionner le Type Expertise</option>
                                        @if ($typeexpertises)
                                            @foreach ($typeexpertises as $type)
                                                <option value="{{ $type->id }}">{{ $type->type }}</option>
                                            @endforeach
                                        @endif
                                    </select>

                                    @error('type_expertise_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>


                                <div wire:ignore class="mb-3 col-md-6">
                                    <label class="form-label">Selectionner un Garage :</label>
                                    <select id="garage_id" name="garage_id"
                                        class="selectGarage form-control @error('garage_id') is-invalid @enderror"
                                        wire:model="garage_id">
                                        <option value="{{ null }}" selected>Selectionner le Garage</option>
                                        @foreach ($garages as $garage)
                                            <option value="{{ $garage->id }}">{{ $garage->libelle }}</option>
                                        @endforeach
                                    </select>
                                    @error('garage_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4 position-relative" id="MEC">
                                    <label class="form-label" for="circulation_date">Date de mise en circulation
                                        :</label>
                                    <input type="date"
                                        class="form-control @error('circulation_date') is-invalid @enderror"
                                        name="circulation_date" id="circulation_date" value=""
                                        wire:model="circulation_date">

                                    @error('circulation_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4 " id="kl">
                                    <label class="form-label" for="kilometrage">Kilométrage :</label>
                                    <input type="number" min="0"
                                        class="form-control @error('kilometrage') is-invalid @enderror"
                                        placeholder="Entrer le Kilométrage" name="kilometrage" id="kilometrage"
                                        value="" wire:model="kilometrage">

                                    @error('kilometrage')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4 " id="kl">
                                    <label class="form-label" for="puissance_fiscale">Puissance Fiscale :</label>
                                    <input type="number"
                                        class="form-control @error('puissance_fiscale') is-invalid @enderror"
                                        placeholder="Entrer la Puissance Fiscale" name="puissance_fiscale"
                                        id="puissance_fiscale" min="1" value=""
                                        wire:model="puissance_fiscale">

                                    @error('puissance_fiscale')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4 " id="crb">
                                    <label class="form-label" for="carburant">Carburant :</label>
                                    <select id="carburant" name="carburant"
                                        class="form-control @error('carburant') is-invalid @enderror"
                                        wire:model="carburant">
                                        <option value="" selected>Selectionner Carburant</option>
                                        @foreach ($carburants as $carb)
                                            <option value="{{ $carb->id }}">{{ $carb->name }}</option>
                                        @endforeach

                                    </select>

                                    @error('carburant')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4 " id="city_id">
                                    <label class="form-label" for="city_id">Ville :</label>
                                    <select id="city_id" name="city_id" wire:model="city_id"
                                        class="form-control @error('city_id') is-invalid @enderror">
                                        <option value="" selected>Selectionner Ville</option>
                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}">{{ $city->city }}</option>
                                        @endforeach
                                    </select>
                                    @error('city_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                {{-- <div class="mb-3 col-md-4">
                                    <label class="form-label">Numero de chassis</label>
                                    <input type="text" name="chassis_number"
                                        class="form-control @error('chassis_number') is-invalid @enderror"
                                        placeholder="Entrer le numero de chassis" wire:model="chassis_number">

                                    @error('chassis_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div> --}}

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Numero de attestation :</label>
                                    <input type="text" name="numero_attestation"
                                        class="form-control @error('numero_attestation') is-invalid @enderror"
                                        placeholder="Entrer le numero de chassis" wire:model="numero_attestation">

                                    @error('numero_attestation')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>




                                {{-- <div class="mb-3 col-md-4 position-relative" id="sinistre">
                                    <label class="form-label" for="date_sinistre">Date de Sinistre <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <input type="date"
                                        class="form-control @error('date_sinistre') is-invalid @enderror"
                                        name="date_sinistre" id="date_sinistre" wire:model="date_sinistre">

                                    @error('date_sinistre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4 position-relative" id="sinistre">
                                    <label class="form-label" for="date_sinistre">Date de Sinistre <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <input type="date"
                                        class="form-control @error('date_sinistre') is-invalid @enderror"
                                        name="date_sinistre" id="date_sinistre" wire:model="date_sinistre">

                                    @error('date_sinistre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div> --}}
                                {{-- <div class="mb-3 col-md-4 position-relative" id="sinistre">
                                    <label class="form-label" for="date_sinistre">Date de Sinistre <span
                                            style="color: rgb(148, 148, 148)">*</span> :</label>
                                    <input type="date"
                                        class="form-control @error('date_sinistre') is-invalid @enderror"
                                        name="date_sinistre" id="date_sinistre" wire:model="date_sinistre">

                                    @error('date_sinistre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div> --}}




                            </div>
                        </div>

                        <div class="tab-pane {{ $count == 2 ? 'active' : '' }}" id="basictab5">
                            <div class="row g-2">

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Civilité:</label>
                                    <select name="civilityop" wire:model="civilityop"
                                        class="form-control @error('civilityop') is-invalid @enderror"
                                        id="civility">
                                        <option value="" selected>Selectionner une valeur : </option>
                                        <option value="Mr">Monsieur</option>
                                        <option value="Mme">Madame</option>
                                        <option value="Sociéte">Sociéte</option>

                                    </select>

                                    @error('civilityop')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Nom Adversaire :</label>
                                    <input type="text" name="nameop" wire:model="nameop"
                                        class="form-control @error('nameop') is-invalid @enderror"
                                        placeholder="Entrer le nom de l'adversaire">

                                    @error('nameop')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Matricule Adversaire :</label>
                                    <input type="text" name="matriculeop" wire:model="matriculeop"
                                        class="form-control @error('matriculeop') is-invalid @enderror"
                                        placeholder="Entrer le matricule de l'adversaire">

                                    @error('matriculeop')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Téléphone Adversaire :</label>
                                    <div class="input-group mb-2">
                                        <input type="tel" name="telephoneop" wire:model="telephoneop"
                                            class="form-control @error('telephoneop') is-invalid @enderror"
                                            placeholder="0644668899">
                                        @error('telephoneop')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    {{-- <input type="text" name="telephoneop" wire:model="telephoneop"
                                        class="form-control @error('telephoneop') is-invalid @enderror"
                                        placeholder="Entrer le téléphone de l'adversaire">

                                    @error('telephoneop')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror --}}
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label class="form-label">Numero de Police :</label>
                                    <input type="text" name="numero_attestationop"
                                        wire:model="numero_attestationop"
                                        class="form-control @error('numero_attestationop') is-invalid @enderror"
                                        placeholder="Entrer le téléphone de l'adversaire">

                                    @error('numero_attestationop')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label for="brandop_id" class="form-label">Marque de la voiture :</label>
                                    <select name="brandop_id" id="brandop_id" class="form-control"
                                        wire:model="selectedBrandop">
                                        <option value="" selected>Selectionner une marque</option>
                                        @foreach ($brands as $brand)
                                            <option value="{{ $brand->id }}">{{ $brand->brand }}</option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="mb-3 col-md-4">
                                    <label for="vehicule_modelop_id" class="form-label">Model de la voiture :</label>
                                    <select name="vehicule_modelop_id" id="vehicule_modelop_id"
                                        wire:model="vehicule_modelop_id"
                                        class="form-control @error('vehicule_modelop_id') is-invalid @enderror">
                                        <option value="" selected>Selectionner un model</option>
                                        @if ($modelsop)
                                            @foreach ($modelsop as $model)
                                                <option value="{{ $model->id }}">{{ $model->name }}</option>
                                            @endforeach
                                        @endif
                                    </select>

                                    @error('vehicule_modelop_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label for="model_id" class="form-label">Assurance :</label>
                                    <select name="companyop_id" id="companyop_id" wire:model="companyop_id"
                                        class="form-control @error('companyop_id') is-invalid @enderror">
                                        <option value="" selected>Selectionner une assurance </option>
                                        @if ($companies)
                                            @foreach ($companies as $company)
                                                <option value="{{ $company->id }}">{{ $company->company }}</option>
                                            @endforeach
                                        @endif
                                    </select>

                                    @error('companyop_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                            </div>
                        </div>

                        <div class="tab-pane {{ $count == 3 ? 'active' : '' }}" id="basictab4">
                            <div class="row g-2">
                                <div class="mb-3 col-md-4">
                                    <label for="pv">Pv<span style="color: #ff1212"><span
                                                style="color: rgb(148, 148, 148)">()</span>:</label>
                                    <input type="file" name="pv" wire:model="pv" multiple
                                        class="form-control @error('pv') is-invalid @enderror">

                                    @error('pv')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label for="">Constat<span style="color: #ff1212"><span
                                                style="color: rgb(148, 148, 148)">()</span>:</label>
                                    <input type="file" name="constat" wire:model="constat" multiple
                                        class="form-control @error('constat') is-invalid @enderror">

                                    @error('constat')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="mb-3 col-md-4">
                                    <label for="">Declaration
                                        <span style="color: #ff1212">
                                            <span style="color: rgb(148, 148, 148)">()</span>:</label>
                                    <input type="file" name="declaration" wire:model="declaration" multiple
                                        class="form-control @error('declaration') is-invalid @enderror">
                                    @error('declaration')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                            </div>
                        </div>
                        {{--
                        <div class="tab-pane {{ $count == 4 ? 'active' : '' }}" id="basictab6">
                            <div class="row mr-5 g-2 d-flex justify-content-center text-center" style="width: 550px">
                                <input hidden wire:model="points" id="point" >

                                <svg id="svg" xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 842 595">
                                    <defs>
                                        <style>
                                            .cls-1,
                                            .cls-3 {
                                                fill: #fff;
                                            }

                                            .cls-2,
                                            .cls-3 {
                                                stroke: #000;
                                                stroke-miterlimit: 10;
                                            }

                                            .cls-2 {
                                                stroke-width: 0.75px;
                                                fill: url(#linear-gradient);
                                            }

                                            .cls-4 {
                                                fill: #ececec;
                                            }

                                            .cls-5 {
                                                fill: #f9f9f9;
                                            }

                                            .cls-6 {
                                                fill: #e9e9e9;
                                            }

                                            .cls-7 {
                                                fill: #dcdcdc;
                                            }

                                            .fil {
                                                fill: #ff1212;
                                            }
                                        </style>
                                        <linearGradient id="linear-gradient" x1="221.22" y1="297.5"
                                            x2="620.78" y2="297.5" gradientUnits="userSpaceOnUse">
                                            <stop offset="0" stop-color="#e6e6e6" stop-opacity="0.4" />
                                            <stop offset="1" stop-color="#fff" />
                                        </linearGradient>
                                    </defs>
                                    <rect class="cls-1" width="842" height="595" />
                                    <rect id="rectangle_2" data-name="rectangle 2" class="cls-2" x="221.22"
                                        y="23" width="399.56" height="549" rx="40.47" />
                                    <circle id="_8" data-name="8" class="cls-3" cx="287"
                                        cy="136.5" r="17.56" />
                                    <circle id="_7" data-name="7" class="cls-3 " cx="287"
                                        cy="297.64" r="17.56" />
                                    <circle id="_6" data-name="6" class="cls-3" cx="287"
                                        cy="458.5" r="17.56" />
                                    <circle id="_5" data-name="5" class="cls-3" cx="421"
                                        cy="543.5" r="17.56" />
                                    <circle id="_4" data-name="4" class="cls-3" cx="555"
                                        cy="458.5" r="17.56" />
                                    <circle id="_3" data-name="3" class="cls-3" cx="555"
                                        cy="297.64" r="17.56" />
                                    <circle id="_2" data-name="2" class="cls-3" cx="555"
                                        cy="136.5" r="17.56" />
                                    <circle id="_1" data-name="1" class="cls-3" cx="421"
                                        cy="51.5" r="17.56" />
                                    <g id="voiture">
                                        <path
                                            d="M507.77,250.59v1.53q0,27.92,0,55.85c0,5.27-.14,10.54-.23,15.81-.07,4.26-.17,8.53-.24,12.8-.09,5.63-.15,11.26-.24,16.89-.07,5-.16,10-.24,15l-.24,15.8-.24,15.33c-.08,5.71-.15,11.42-.25,17.13,0,2.59,0,5.18-.26,7.76-.27,3.05-.73,6.09-1.16,9.12s-1.05,6.28-1.38,9.43c-.11,1,.62,2.13.61,3.2a49.31,49.31,0,0,1-.48,6.18c-.39,2.79-.89,5.57-1.41,8.35-.67,3.57-1.42,7.14-2.09,10.71a29.6,29.6,0,0,1-2.76,8.45,20.42,20.42,0,0,1-7.53,7.82c-3.31,2-7,2.87-10.75,3.53s-7.36,1.18-11.06,1.67c-2.07.27-4.17.35-6.26.51l-12.54,1h-.24c-2.63.08-5.26.21-7.88.23-11.07.1-22.15.23-33.22.23-4.85,0-9.71-.27-14.56-.47-2.61-.1-5.22-.25-7.83-.48-4-.35-7.93-.72-11.89-1.2s-7.87-1-11.78-1.69c-5.63-1-10.72-3.08-14.55-7.57A19.53,19.53,0,0,1,342.8,475q-2-8.7-3.6-17.47c-.63-3.36-1-6.76-1.45-10.15a5,5,0,0,1,.26-2.46c.85-2,.09-4-.13-5.92-.3-2.69-.73-5.37-1.12-8-1.14-7.63-.93-15.32-1-23,0-3.59-.15-7.18-.23-10.77l-.24-11.12c-.08-3.67-.18-7.34-.24-11q-.13-9.94-.24-19.89l-.24-17.37-.24-18c-.08-5.51-.2-11-.24-16.53q-.15-26-.24-52v-.72l-12.56,2.63c-1-3-.24-4.43,1.7-5.68a45.63,45.63,0,0,1,10.86-4.6v-1.4c0-7.21,0-14.41,0-21.62q.09-17.64.24-35.27c0-3.26.15-6.53.24-9.8.07-2.3.14-4.61.24-6.92.15-3.41.28-6.82.49-10.23.19-3.24.34-6.49.74-9.71.48-3.77,1.18-7.51,1.85-11.25.53-3,1-6.05,1.77-9a26.51,26.51,0,0,1,5.24-10c2.37-2.87,5.52-4.61,8.64-6.42a54.36,54.36,0,0,1,10.89-5c1.89-.6,3.74-1.31,5.61-1.94a5.53,5.53,0,0,1,1.15-.19c2.81-.34,5.64-.6,8.43-1.05,3.29-.52,6.54-1.23,9.82-1.8a6.21,6.21,0,0,1,1.63.2c3.92.44,7.8-.21,11.7-.47,1.46-.1,2.93-.19,4.39-.24,2.75-.1,5.49-.17,8.24-.24,3.75-.09,7.5-.29,11.24-.21,4.76.1,9.52.41,14.27.7,2.52.16,5,.51,7.54.68a9.13,9.13,0,0,0,2.71-.23c2.06-.5,4,.33,5.9.65,3.86.64,7.68,1.51,11.53,2.2a13.85,13.85,0,0,0,2.46-.18,6.1,6.1,0,0,1,4,1.2,5.25,5.25,0,0,0,1.65.54A56.36,56.36,0,0,1,491,112.85a44.72,44.72,0,0,1,5.31,4.1c2.5,2.23,4,5.21,5.2,8.23a41,41,0,0,1,2.73,11.74c.22,2.3.83,4.55,1.19,6.83.29,1.87.55,3.75.67,5.63.3,4.47.51,9,.74,13.43.18,3.45.37,6.9.47,10.35.13,4.79.22,9.58.24,14.37q.15,27,.22,54a1.6,1.6,0,0,0,1.41,1.86,35.17,35.17,0,0,1,10.3,4.74,3.84,3.84,0,0,1,1.24,4.61,1.11,1.11,0,0,1-1,.41C515.79,252.34,511.86,251.48,507.77,250.59Zm-166.1,65.46,0,0h2.8a18.12,18.12,0,0,1,0-2.34c.25-1.72.12-3.56,1.45-5a1.5,1.5,0,0,0,.2-1c-.05-1.75-.21-3.49-.21-5.24q0-17.17,0-34.35,0-9.07,0-18.14c0-.37,0-.93-.21-1.08-1.07-.77-2.22-1.43-3.37-2.14-.74,1.31-1.36,2.21-2.65,2.45-1.45.28-2.86.77-4.32,1-.81.16-1,.53-1,1.28q.15,25.38.26,50.76c0,5.87.16,11.74.24,17.61l.24,17.25.24,18.09q.12,9.59.24,19.17c.06,3.87.16,7.73.24,11.6L336,396.7c.08,3.66.17,7.33.24,11,.08,4.51.12,9,.25,13.52.07,2.38.24,4.75.48,7.11.34,3.33.72,6.66,1.22,10q1,6.39,2.14,12.76c.81,4.42,1.79,8.82,2.57,13.25.18,1,.61,1.1,1.35,1a1.47,1.47,0,0,1,1.76,1q1,2.56,2,5.13a20.4,20.4,0,0,0,7.43,9.58,28.24,28.24,0,0,0,8.15,3.42,109.34,109.34,0,0,0,22.7,3.42,24,24,0,0,1,3.9.29,5.06,5.06,0,0,0,3.67-.75,4,4,0,0,1,1.74-.48c1.87,0,3.74.15,5.6.21,2.59.09,5.17.17,7.76.24,3,.09,6.05.22,9.08.23,2.55,0,5.09-.15,7.64-.22,2.79-.09,5.57-.18,8.36-.24,4.11-.09,8.21-.18,12.32-.22a5.78,5.78,0,0,1,1.49.49,9.9,9.9,0,0,0,3,.85c2.64-.07,5.27-.4,7.9-.65s5-.39,7.42-.75c3.06-.46,6.12-1,9.13-1.68,4.06-1,8.21-1.87,11.58-4.56a22.1,22.1,0,0,0,6.09-7.49c1.08-2.16,1.86-4.48,2.75-6.73a1.49,1.49,0,0,1,1.59-1.13c.39,0,.79,0,1.19,0,.13-.43.27-.8.35-1.17.74-3.73,1.52-7.44,2.2-11.18s1.28-7.5,1.88-11.26c.45-2.79.85-5.59,1.23-8.39.41-3,.88-6.08,1.15-9.13.22-2.5.22-5,.26-7.52.1-5.79.17-11.58.25-17.37l.24-15.57c.08-5.78.15-11.57.24-17.36.07-4.35.17-8.7.24-13.05.09-5.15.16-10.3.24-15.45.08-4.78.19-9.57.23-14.36,0-3.77,0-7.54,0-11.31,0-1.43.22-2.85.22-4.28q0-27.93,0-55.85c0-1.06,0-1.88-1.4-1.86a5.09,5.09,0,0,1-1.83-.39c-1.65-.61-3.73-.55-4.36-3-1.24.71-2.35,1.32-3.43,2a.73.73,0,0,0-.27.49,29.54,29.54,0,0,0-.25,3q0,27.14,0,54.28c0,1.15-.11,2.28.83,3.22.27.26.29.79.37,1.21a47,47,0,0,1,.45,9.55,2.49,2.49,0,0,1-.73,1.75,1.54,1.54,0,0,0-.68,1.48q-.11,6.46-.24,12.93-.11,5.61-.24,11.24c-.07,3.23-.16,6.45-.24,9.68l-.24,9.68-.24,9.08c-.08,3.07-.17,6.14-.24,9.21-.09,4.32-.15,8.64-.24,13-.06,2.5,0,5-.29,7.51a40.53,40.53,0,0,1-1.39,5.46,4.35,4.35,0,0,1-.56-.38,2.58,2.58,0,0,1-.41-.57,86,86,0,0,1-3.79-8.3c-2-5.87-3.87-11.81-5.54-17.79-1.54-5.53-3-11.11-4-16.75s-1.61-11.3-2.19-17c-.37-3.55-.46-7.14-.5-10.71-.08-6.21,0-12.41,0-18.62,0-.32,0-.64,0-1q.47-5.85.95-11.7c.17-2.13.26-4.27.5-6.39.43-3.67.89-7.34,1.43-11a84.27,84.27,0,0,1,1.67-9.37c1-3.88,2.37-7.69,3.77-11.46,2-5.39,4.16-10.72,6.33-16,1.93-4.75,4-9.45,6-14.16a27.69,27.69,0,0,1,1.5-2.58c.63,2.25,1.66,3.65,3.85,3.68a4.72,4.72,0,0,1,.83.11l4.76,1.23a4.63,4.63,0,0,0,.1-.61q-.12-27-.25-54c0-4.51-.11-9-.24-13.52q-.17-5.79-.48-11.56c-.28-5-.58-10.05-1-15.06-.22-2.75-.6-5.48-1-8.21-.23-1.61-.89-2.95-2.84-3.23V139a20,20,0,0,1-3.14-2.51c-1.39-1.69-2.58-3.55-3.82-5.36a33.79,33.79,0,0,0-5.76-6.44v2.51l-.44,0c.84-2.33-.34-3.56-2.17-4.46-2.26-1.11-4.43-2.4-6.75-3.33a109.42,109.42,0,0,0-10.82-3.83c-4.7-1.32-9.49-2.34-14.26-3.38-2.75-.6-5.56-.93-8.33-1.49-2.43-.5-5-.52-7-2.48-.13-.14-.44-.13-.67-.14-1.62-.09-3.25-.19-4.87-.24-3.15-.1-6.3-.22-9.44-.23-2.67,0-5.34.15-8,.22l-9.56.24c-1.79,0-3.45,0-5.17,1.09-1.53,1-3.61,1.16-5.49,1.53-3.64.73-7.34,1.22-11,2-4.95,1.13-9.86,2.44-14.77,3.74a58.29,58.29,0,0,0-14.7,6.42c-1.3.77-2.83,1.39-2.57,3.39v-1.43a11,11,0,0,0-1.75,1.46c-2.28,3-4.41,6.12-6.78,9-1.07,1.33-2.13,2.91-4.24,3.2l.29-2.82c-1.31.63-2.43,1.28-2.64,2.75-.58,4.13-1.24,8.24-1.66,12.39-.39,3.9-.55,7.82-.74,11.74-.21,4.21-.35,8.43-.49,12.64-.1,3.19-.19,6.37-.24,9.56-.1,6.15-.21,12.3-.23,18.45,0,12.69,0,25.39,0,38.08v1.39a50.56,50.56,0,0,1,6.28-1.5,3.38,3.38,0,0,0,3.09-2.57,7.15,7.15,0,0,1,.51-.91c.94,1.81,1.86,3.36,2.55,5q2.94,7,5.7,14,3.78,9.6,7.46,19.24c2.1,5.5,2.88,11.3,3.69,17.08.59,4.21,1,8.45,1.44,12.68.39,3.9.72,7.8,1,11.7.18,2.86.26,5.74.25,8.6,0,5.71-.13,11.42-.24,17.13,0,2.07-.14,4.14-.24,6.2-.05,1.11-.11,2.22-.25,3.32-.45,3.66-.85,7.34-1.44,11-.66,4-1.29,8.06-2.34,12-1.68,6.34-3.65,12.61-5.59,18.88-1.27,4.1-2.62,8.18-4.1,12.21a34.49,34.49,0,0,1-2.51,4.59c-.3-.27-.43-.34-.47-.44a22.36,22.36,0,0,1-1.56-7.81c-.09-4.29-.32-8.58-.45-12.88-.06-1.64,0-3.3,0-4.95-.06-2.82-.15-5.65-.23-8.48s-.17-5.41-.24-8.12c-.09-3.06-.16-6.13-.24-9.2s-.17-6.21-.24-9.32q-.13-6-.24-12c-.09-4.95-.16-9.9-.26-14.85,0-.33-.1-.83-.32-.94-.85-.42-.87-1.14-.87-1.91,0-1.38,0-2.76,0-4.19a14.05,14.05,0,0,1-1.61,0A8.35,8.35,0,0,1,341.67,316.05Zm-3,128.67a9.83,9.83,0,0,0-.42,2.49c.41,3.39.83,6.79,1.44,10.15.94,5.16,2,10.29,3.09,15.42A21.89,21.89,0,0,0,348,483.65a21.32,21.32,0,0,0,10.77,6.19,132.49,132.49,0,0,0,18.13,2.85c4.05.43,8.12.7,12.18,1,3.21.22,6.42.36,9.63.48s6.13.19,9.2.25c1.8,0,3.6,0,5.4,0,8-.07,16-.12,24-.25,4.21-.07,8.42-.29,12.63-.47,3.25-.14,6.5-.31,9.75-.49,1-.05,2.06-.12,3.08-.25,3.86-.46,7.74-.85,11.59-1.45a88.54,88.54,0,0,0,9.54-1.93,19.65,19.65,0,0,0,12.95-10.42,37.44,37.44,0,0,0,2.63-8.1c.92-3.92,1.57-7.91,2.29-11.88.52-2.89,1-5.79,1.4-8.71.25-1.9.67-3.85-.1-5.91-.54,3.37-.95,6.6-1.58,9.79q-1.29,6.51-2.86,12.95c-.92,3.77-2.34,7.33-5.34,10a36.17,36.17,0,0,1-15.79,7.95,116.54,116.54,0,0,1-21.92,3.14,33.65,33.65,0,0,0-4.14.34,5.59,5.59,0,0,1-3.8-.78,3.34,3.34,0,0,0-1.49-.5c-2,0-4.05.14-6.07.21l-7.16.24c-3.07.09-6.13.23-9.2.23-2.79,0-5.57-.16-8.36-.22-4.94-.1-9.89-.16-14.84-.24h-.36c-2.29-.24-4.55-.72-6.74.67-1.13.71-2.54.51-3.9.33-2.9-.36-5.84-.41-8.73-.77-4.44-.56-8.89-1.12-13.29-1.94a39.42,39.42,0,0,1-16.72-6.79c-2.49-1.85-4.9-4-5.94-6.94a98.12,98.12,0,0,1-3.22-11.5C340.48,455.53,339.67,450.27,338.66,444.72Zm9-59.14a6,6,0,0,1,.63-.88c3.69-3.71,7.31-7.5,11.62-10.54.74-.53,1.78-.77,2.09-2a140.92,140.92,0,0,0,3-19.89c.34-3.75.36-7.54.51-11.31,0-.76,0-1.52,0-2.28V326.78L346,322.7c.11,2.19.27,4.29.33,6.4.11,4.1.16,8.21.25,12.31.07,3.51.15,7,.24,10.52.07,3.07.16,6.13.23,9.2.09,3.78.17,7.57.25,11.35l.24,12.68C347.58,385.23,347.62,385.3,347.7,385.58Zm128.61-58.84c0,5.32-.1,10.5,0,15.69.09,4,.41,8.07.7,12.1.17,2.4.39,4.8.74,7.18.47,3.13,1,6.26,1.7,9.36a4.28,4.28,0,0,0,1.25,2.23c3.11,2.74,6.32,5.37,9.49,8l4.1,3.45c-.19-.18,0-.77,0-1.37.1-3,.17-6,.25-8.95l.24-9.32c.08-3.15.18-6.3.24-9.44.09-5.07.15-10.14.25-15.21,0-1.82.2-3.65.22-5.47,0-4.08,0-8.16,0-12.28Zm27.31-190a2.18,2.18,0,0,0,.06-.52c-.64-2.86-1.11-5.77-2-8.56-1.5-4.9-3.89-9.37-8.17-12.4a58.25,58.25,0,0,0-17.25-8.66c-.35-.1-1-.14-1.1,0-.55,1.27-1.68.93-2.5.79-1.74-.32-3.83-.08-4.68-2.3-.07-.17-.46-.24-.72-.29-2.84-.57-5.66-1.26-8.53-1.63-2.53-.33-5-1.43-7.6-1a9.53,9.53,0,0,1-2.11.23c-2.84-.19-5.67-.51-8.51-.69-4.47-.28-8.95-.67-13.43-.69-6,0-12,.27-18,.44-2.07.06-4.13.14-6.2.24-1.42.07-2.84.2-4.27.29-2.21.14-4.48.65-6.62.33a21,21,0,0,0-7,.5l-9.72,1.76c-.71.12-1.52,0-1.59,1.1,0,.21-.42.47-.69.58a18.59,18.59,0,0,1-3.06,1.15c-.88.18-2.34.37-2.66-.07-1.11-1.56-2.26-.59-3.24-.25a65.88,65.88,0,0,0-13.47,6.64,23.13,23.13,0,0,0-6.59,6,32.71,32.71,0,0,0-5,11.95c-.36,1.52-.55,3.09-.86,4.87.75-.53,1.19-1.07,1.71-1.16.89-.16.83-.85,1-1.39s.29-1.14.5-1.68a17.57,17.57,0,0,1,1.05-2.48,35.66,35.66,0,0,1,6.77-8.56,30.69,30.69,0,0,1,10.4-6.36c4.55-1.65,9.19-3.07,13.87-4.27,3.6-.93,7.32-1.37,11-2,3.13-.55,6.25-1.11,9.39-1.61,2.83-.46,5.66-1,8.51-1.25s5.77-.39,8.66-.5c3.39-.12,6.78-.22,10.16-.23,2.43,0,4.85.14,7.28.22,2.62.08,5.25.15,7.88.25,1.14,0,2.29.11,3.43.25,3,.37,6.09.72,9.12,1.2,2.67.42,5.3,1,8,1.49s5.52.77,8.22,1.43c4.78,1.15,9.58,2.32,14.23,3.88a55,55,0,0,1,9.23,4.33,27.83,27.83,0,0,1,8,7.21,21.54,21.54,0,0,1,4.54,8.67A3.45,3.45,0,0,0,503.62,136.69Zm-138.1,181c-.25-2.79-.46-5.11-.66-7.43-.25-2.95-.41-5.91-.74-8.86-.41-3.59-.82-7.19-1.45-10.74-.72-4.12-1.25-8.35-2.63-12.26-3.11-8.88-6.68-17.6-10.09-26.38a3.07,3.07,0,0,0-.94-1.5,15.27,15.27,0,0,0-2.64-1v.92q.12,28.91.21,57.82a1.45,1.45,0,0,0,.95,1.43c4.11,2.1,8.19,4.27,12.37,6.24A44.76,44.76,0,0,0,365.52,317.67Zm110.73-.33a5.18,5.18,0,0,0,1,0c.83-.19,1.68-.37,2.49-.64,5.17-1.7,9.86-4.39,14.55-7.07a1.76,1.76,0,0,0,1-1.83q0-27.87,0-55.72c0-.86.14-1.71.22-2.59a2.41,2.41,0,0,0-.61.13c-.91.47-2.27.74-2.65,1.49-1.33,2.65-2.36,5.45-3.44,8.22q-3,7.59-5.85,15.21a58,58,0,0,0-3.29,12.21c-.41,2.92-.84,5.84-1.21,8.76-.35,2.73-.65,5.47-.95,8.21-.2,1.93-.34,3.86-.52,5.78C476.75,312.05,476.51,314.6,476.25,317.34Zm.06,8.81c2.38-.47,4.91-.94,7.42-1.48,3.82-.81,7.61-1.76,11.45-2.47,1.25-.23,1.78-.77,1.77-1.88,0-2.7-.09-5.4-.27-8.1a14.44,14.44,0,0,0-.79-2.82l-6.33,3.47c-4,2.19-8,4.24-12.58,5-.25,0-.64.42-.64.65C476.29,321.05,476.31,323.6,476.31,326.15ZM345.94,309.49a5.36,5.36,0,0,0-.51,1.44c-.21,3.32-.38,6.65-.45,10,0,.36.61,1,1,1.07,2.52.66,5.07,1.23,7.63,1.77,4,.86,8,1.67,12.27,2.54-.13-1.26-.31-2.4-.36-3.54-.05-1.32.06-2.64,0-3.95a1.22,1.22,0,0,0-.76-.92,28.93,28.93,0,0,1-8.82-3.08C352.61,313.11,349.32,311.29,345.94,309.49ZM492.18,410.24l.41,0a55.38,55.38,0,0,0,1.2-6.7c.26-4,.13-8,.33-11.95a5.39,5.39,0,0,0-1.59-4.37,3.46,3.46,0,0,1-.39-.58c-3-4.44-7.07-7.67-11.54-10.71a6.92,6.92,0,0,0,.14.93c2.45,8.11,4.86,16.22,7.37,24.31A35,35,0,0,0,492.18,410.24ZM361.37,376.18l-.36-.27c-2.14,1.8-4.39,3.47-6.38,5.42-2.15,2.11-4.05,4.46-6.05,6.71a3.5,3.5,0,0,0-1,2.92,22.45,22.45,0,0,1,.24,2.47c.18,4.29.25,8.59.53,12.87a20.47,20.47,0,0,0,1.06,4h.33a44.31,44.31,0,0,0,2.37-4.85c1.62-4.56,3.14-9.17,4.6-13.78C358.3,386.5,359.81,381.33,361.37,376.18ZM392.12,110.6a7.63,7.63,0,0,0-5-1.72,71.83,71.83,0,0,0-8.75,1.18,94.44,94.44,0,0,0-16.94,4.58c-2.57,1-5,2.36-7.51,3.61a1.67,1.67,0,0,0-.81,1.12c-.1,1.38,0,2.77,0,4.25a2.29,2.29,0,0,0,.63-.21,40.75,40.75,0,0,1,11.18-5.66c4-1.46,8.18-2.59,12.33-3.66C382.14,112.82,387.11,111.76,392.12,110.6Zm96.31,12.94a33.28,33.28,0,0,0,.33-3.67,1.88,1.88,0,0,0-.73-1.4c-2.12-1.17-4.26-2.33-6.48-3.28a68.5,68.5,0,0,0-14-4.2c-3.8-.75-7.6-1.51-11.42-2.12a8.63,8.63,0,0,0-6.48,1.78C463,113.68,476.63,115.72,488.43,123.54ZM321.79,252.68c5.53-1.19,11.08-2.36,16.61-3.57,1.3-.29,2.73-.59,3-2.18a20.34,20.34,0,0,0,.33-4.12c0-.68-.24-1.22-1.38-1-6.09,1.38-12,3.14-17.39,6.46C321.69,249.11,320.78,251.25,321.79,252.68Zm198.52.06a14.16,14.16,0,0,0,0-2.27c-.3-1.87-1.95-2.48-3.33-3.24-4.91-2.72-10.27-4.2-15.7-5.41-.33-.07-1.09.37-1.11.61a35.64,35.64,0,0,0,.06,3.58c.07,1.86,1.27,2.68,2.89,3.05,2.32.53,4.66,1,7,1.5ZM340.57,138c2.43-1.38,3.69-3.5,5.07-5.47,2.13-3,4.15-6.12,6.95-8.31v-5.13C346.27,124,341.58,129.7,340.57,138ZM489.4,119.4a15.47,15.47,0,0,0-.34,2.06c-.05,1.38-.37,2.83,1.27,3.72a5.64,5.64,0,0,1,1.69,1.68c2,2.71,3.91,5.49,5.93,8.17a9.2,9.2,0,0,0,3.05,2.82C501.28,132,495.63,123.58,489.4,119.4Zm-51.16-13.2c-2.59-.17-5.15-.43-7.72-.48-4.17-.08-8.34,0-12.51,0-3.1,0-6.21.17-9.31.23-1.7,0-3.4,0-5.1,0l0,.35-.32,1.09h35.22Zm15.44,1.85L439,106.14c.22,1.37.77,2.44,2.07,2.8,1.87.51,3.78.92,5.68,1.31a4.2,4.2,0,0,0,2.18.11C450.53,109.71,452.09,108.83,453.68,108.05Zm-50.8-2-14,2.22c1.24.62,2.4,1.24,3.6,1.8a2.68,2.68,0,0,0,1.45.35c2.18-.41,4.35-.91,6.52-1.4C401.9,108.74,402.5,107.67,402.88,106.1Zm-49.67,374c-.95-1.16-1.89-2.27-2.79-3.42-2.21-2.82-3.42-6.15-4.6-9.47-.48-1.35-1.18-1.72-2.38-1.39A19.26,19.26,0,0,0,353.21,480.15Zm145.08-14.26c-1.09-.3-2-.11-2.26,1.23a11.07,11.07,0,0,1-.49,1.32c-1.06,2.77-2,5.6-3.88,8-1.09,1.38-2.31,2.66-3.61,4.14C493.68,477,497.43,472.48,498.29,465.89ZM361.67,373.83c-.15,0-.25,0-.3,0a71.91,71.91,0,0,0-11.82,10.41c-.84.92-2.45,1.75-1.59,3.55.79-.91,1.59-1.82,2.37-2.74a61.56,61.56,0,0,1,8.56-8.21C359.92,376,361.67,375.77,361.67,373.83ZM344.4,238.91c-.8,1.23-.8,1.23-.11,2,1.24,1.39,1.37,5,.12,6.6l4.44,2.33.19-.27ZM494,387.93h.23a5.74,5.74,0,0,0-.51-2.09,19.06,19.06,0,0,0-2.63-2.91q-3.57-3.31-7.24-6.52c-1.1-.95-2.34-1.75-3.52-2.62l-.31.28a5.32,5.32,0,0,0,.82,1.22c2.66,2.22,5.47,4.28,8,6.64A72.36,72.36,0,0,1,494,387.93Zm3.57-149.16c-1.71,3.83-3.26,7.35-4.82,10.86l.31.23,4.42-2.37c-1.58-2-1.16-5.85.7-7.24Zm.93,7.95c.84.07,1.27-.08,1-1.27a7.72,7.72,0,0,1,.08-3.06c.1-.65.1-1.19-.59-1.24a1.49,1.49,0,0,0-1.22.63,8.56,8.56,0,0,0-.71,2.79C496.91,246.31,497.25,246.71,498.48,246.72Zm-156.41-5.17.34,0c0,1.3,0,2.61,0,3.91,0,.4.14,1.09.33,1.13.66.14,1.48.3,1.87-.55.54-1.19-.25-4.17-1.35-5.15ZM468.49,105.29a8.44,8.44,0,0,0,5.43,1.59.89.89,0,0,0,.65-.39c.08-.13,0-.47-.17-.62C473.36,104.73,470,104.35,468.49,105.29Zm-101.44.94c1.23,1.3,5.52.35,6.09-1.38A7.88,7.88,0,0,0,367.05,106.23Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-4"
                                            d="M476.31,326.15c0-2.55,0-5.1,0-7.65,0-.23.39-.61.64-.65,4.56-.74,8.6-2.79,12.58-5l6.33-3.47a14.44,14.44,0,0,1,.79,2.82c.18,2.7.24,5.4.27,8.1,0,1.11-.52,1.65-1.77,1.88-3.84.71-7.63,1.66-11.45,2.47C481.22,325.21,478.69,325.68,476.31,326.15Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-4"
                                            d="M345.94,309.49c3.38,1.8,6.67,3.62,10,5.3a28.93,28.93,0,0,0,8.82,3.08,1.22,1.22,0,0,1,.76.92c.08,1.31,0,2.63,0,3.95.05,1.14.23,2.28.36,3.54-4.25-.87-8.26-1.68-12.27-2.54-2.56-.54-5.11-1.11-7.63-1.77-.43-.11-1-.71-1-1.07.07-3.32.24-6.65.45-10A5.36,5.36,0,0,1,345.94,309.49Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-1"
                                            d="M438.24,106.2l.29,1.18H403.31l.32-1.09,0-.35c1.7,0,3.4,0,5.1,0,3.1-.06,6.21-.2,9.31-.23,4.17,0,8.34-.07,12.51,0C433.09,105.77,435.65,106,438.24,106.2Zm-5.44.4v-.1H409.14v.1Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-1"
                                            d="M453.68,108.05c-1.59.78-3.15,1.66-4.8,2.31a4.2,4.2,0,0,1-2.18-.11c-1.9-.39-3.81-.8-5.68-1.31-1.3-.36-1.85-1.43-2.07-2.8Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-1"
                                            d="M402.88,106.1c-.38,1.57-1,2.64-2.43,3-2.17.49-4.34,1-6.52,1.4a2.68,2.68,0,0,1-1.45-.35c-1.2-.56-2.36-1.18-3.6-1.8Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-4"
                                            d="M361.67,373.83c0,1.94-1.75,2.21-2.78,3a61.56,61.56,0,0,0-8.56,8.21c-.78.92-1.58,1.83-2.37,2.74-.86-1.8.75-2.63,1.59-3.55a71.91,71.91,0,0,1,11.82-10.41C361.42,373.82,361.52,373.84,361.67,373.83Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-4"
                                            d="M494,387.93a72.36,72.36,0,0,0-5.17-6c-2.52-2.36-5.33-4.42-8-6.64a5.32,5.32,0,0,1-.82-1.22l.31-.28c1.18.87,2.42,1.67,3.52,2.62q3.68,3.19,7.24,6.52a19.06,19.06,0,0,1,2.63,2.91,5.74,5.74,0,0,1,.51,2.09Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-1"
                                            d="M468.49,105.29c1.53-.94,4.87-.56,5.91.58.14.15.25.49.17.62a.89.89,0,0,1-.65.39A8.44,8.44,0,0,1,468.49,105.29Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-1"
                                            d="M367.05,106.23a7.88,7.88,0,0,1,6.09-1.38C372.57,106.58,368.28,107.53,367.05,106.23Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M478.85,449.83v-3.71a44.37,44.37,0,0,1-5.54,2.37,89.47,89.47,0,0,1-9.71,2.15c-4,.63-8,1-12,1.46-1.1.13-2.2.2-3.31.25-2.22.09-4.45.17-6.67.24-2.75.09-5.49.2-8.24.24-7.9.1-15.81.19-23.71.23-2.31,0-4.61-.12-6.92-.23-4.23-.22-8.47-.39-12.69-.75s-8.39-.83-12.55-1.44a45.7,45.7,0,0,1-11.33-2.9A34.62,34.62,0,0,1,363,446v7.95h0a3,3,0,0,1-.34-.9c0-1.88-.06-3.77,0-5.65a2.77,2.77,0,0,0-1.16-2.59,13.31,13.31,0,0,1-4.39-7.5,21.08,21.08,0,0,1,0-8.7c.59-3.6,1.05-7.22,1.73-10.81.8-4.3,1.7-8.6,2.7-12.86,1.43-6.13,3-12.24,4.5-18.34a27,27,0,0,1,1.47-4.19,3.93,3.93,0,0,1,3.18-2.36,1.17,1.17,0,0,0,.82-.71c.37-3.61.79-7.23,1-10.85.26-5.17.37-10.35.5-15.52.11-4.47.23-8.94.23-13.41,0-4.27-.11-8.54-.23-12.8-.12-3.9-.25-7.79-.49-11.68s-.61-7.88-.94-11.82c-.23-2.76-.41-5.52-.74-8.26s-.75-5.53-1.28-8.27c-.5-2.56-1.22-5.09-1.81-7.64a1,1,0,0,0-1.14-.87,4.94,4.94,0,0,1-5.12-3.43c-2-4.84-4-9.68-5.86-14.58-2.1-5.56-4.17-11.14-6-16.8A143.51,143.51,0,0,1,346,229.08a16.51,16.51,0,0,1,2.4-12.32,18.72,18.72,0,0,1,7.82-7.27c2.23-1.07,4.5-2.05,6.7-3.18a2.24,2.24,0,0,0,.76-1.43c1.39-7.31,2.69-14.64,4.14-21.94,1-5,2.15-9.94,3.29-14.9,1.42-6.17,2.84-12.34,4.38-18.49a180.46,180.46,0,0,1,7.52-24c.94-2.3,2.22-4.46,3.34-6.68l.43.22c-.35.58-.71,1.14-1.05,1.72-2.69,4.6-4.27,9.66-5.87,14.68-1.51,4.77-2.8,9.61-4,14.46-1.51,6.11-2.86,12.27-4.22,18.41-1.32,5.92-2.61,11.85-3.8,17.8-1,4.87-1.8,9.78-2.69,14.68l-.87,4.9c.81-.31,1.5-.64,2.22-.84,3.42-1,6.82-2,10.28-2.79s6.76-1.34,10.16-1.91c2.52-.41,5.06-.69,7.6-1,3.2-.4,6.4-.82,9.6-1.18,2.05-.22,4.1-.43,6.15-.48,5.55-.14,11.1-.32,16.65-.21,3.86.07,7.72.57,11.58.91,2.51.21,5,.41,7.54.74,3.07.4,6.13.9,9.19,1.41,3.63.61,7.26,1.27,10.88,1.93a43.17,43.17,0,0,1,11.1,3.32c.06,0,.15,0,.33,0-.25-1.59-.45-3.17-.75-4.74-.68-3.65-1.4-7.3-2.13-11-1-5.14-2-10.29-3.12-15.42-1.32-6.24-2.6-12.49-4.12-18.68-1.59-6.49-3.4-12.93-5.17-19.37A82.15,82.15,0,0,0,456.84,122c-.49-1-1.13-1.94-1.69-2.91l.32-.18a49.43,49.43,0,0,1,2.67,5c1.64,4.14,3.33,8.28,4.58,12.55,2.21,7.58,4.26,15.21,6.1,22.88,2.09,8.75,3.92,17.57,5.78,26.37,1,4.94,1.94,9.91,2.89,14.88.27,1.42.56,2.85.71,4.29a1.9,1.9,0,0,0,1.24,1.67q3.57,1.66,7.1,3.41a17,17,0,0,1,6.06,5.38,18.49,18.49,0,0,1,3.44,9.09c.41,3.58-.47,7-1.35,10.31-1.2,4.61-2.63,9.18-4.24,13.66-2.68,7.42-5.57,14.78-8.43,22.14a51.19,51.19,0,0,1-2.57,5.52,3.8,3.8,0,0,1-3.72,2c-1.15-.06-1.63.31-1.85,1.42-.67,3.38-1.53,6.72-2.11,10.11-.61,3.64-1,7.32-1.44,11-.26,2.36-.38,4.74-.5,7.11-.26,5-.49,10-.73,15-.09,1.83-.21,3.65-.23,5.48-.1,9.39-.22,18.79-.22,28.18,0,3.93.22,7.87.48,11.79.21,3.31.61,6.61.94,9.9.06.59.21,1.16.34,1.84,3.74.05,4.42,3,5.15,5.8q2.1,8,3.93,16.07c1.4,6.14,2.79,12.28,4,18.47.7,3.7.94,7.49,1.51,11.22a15.14,15.14,0,0,1-2.44,10.65A30.13,30.13,0,0,1,480,445a3.15,3.15,0,0,0-.73,1.5c-.12.9,0,1.84-.05,2.76,0,.18-.21.35-.33.53ZM368.17,278c.63,2.9,1.33,5.48,1.72,8.1.89,5.94,1.7,11.91,2.38,17.88.41,3.54.56,7.11.75,10.66q.3,6,.48,11.92c.12,4.07.23,8.14.23,12.2,0,4.55-.2,9.1-.21,13.65a184.85,184.85,0,0,1-.73,19.55c-.29,2.74-.52,5.48-.79,8.36,3.29.38,6.65.8,10,1.15,4,.43,8.09.86,12.14,1.19,3,.24,5.93.38,8.91.48q5.19.19,10.4.25t10.35,0c2.79,0,5.57-.15,8.36-.23s5.33-.14,8-.25c2.9-.13,5.79-.27,8.68-.48,3.74-.28,7.48-.59,11.21-1,3.24-.32,6.47-.76,9.77-1.15-.17-1.84-.33-3.52-.47-5.19-.32-3.62-.68-7.24-.94-10.86-.17-2.26-.26-4.54-.24-6.8,0-8.79.1-17.59.24-26.38.07-5.17.3-10.34.46-15.52.07-2,.15-4.05.25-6.07.06-1.19.13-2.38.25-3.56.3-3,.62-6,.94-9.06.24-2.23.37-4.49.77-6.69.72-4,1.61-7.88,2.46-12-1.35-.45-2.84-1-4.36-1.45a122.36,122.36,0,0,0-20-3.59c-3.33-.41-6.67-.72-10-1-4.27-.31-8.55-.64-12.83-.7-5.27-.08-10.54.11-15.8.21-1.47,0-2.94.12-4.4.24-3.42.3-6.84.63-10.26.95-2.47.24-4.95.4-7.41.76-3.3.47-6.6,1-9.85,1.68C375.06,276.11,371.57,277.13,368.17,278Zm43.76-80.3v.23c-1.67.09-3.34.12-5,.28-2.78.27-5.56.61-8.33.93s-5.57.59-8.33,1q-4.71.72-9.37,1.66A102.25,102.25,0,0,0,370,204.23c-3.52,1.11-6.85,2.84-10.3,4.2-4.71,1.86-8.63,4.64-11.22,9.11a15.58,15.58,0,0,0-2.3,9.35,47,47,0,0,0,1.87,9.07c1.91,6.36,3.91,12.7,6.16,18.95,2.33,6.47,5,12.82,7.52,19.22a5.16,5.16,0,0,0,3.81,3.52A9.3,9.3,0,0,0,370,277c3.56-1,7.17-1.9,10.8-2.67,2.61-.55,5.27-.88,7.91-1.21,2.43-.31,4.87-.52,7.3-.75,3.46-.32,6.92-.67,10.38-.94,2.85-.22,5.7-.45,8.55-.46,4.39,0,8.78.06,13.16.23s8.48.43,12.71.71c3,.19,6,.36,9,.74,4.16.54,8.33,1.11,12.44,1.94,3.56.71,7,1.79,10.54,2.74,3.3.9,5.7.27,7.07-2.88,1.88-4.3,3.52-8.7,5.24-13.07a228.67,228.67,0,0,0,9.15-27c1-3.79,2-7.57,1.12-11.57A17.6,17.6,0,0,0,487.07,211a81.14,81.14,0,0,0-13.77-6.29,76.43,76.43,0,0,0-11.39-2.7q-6.24-1.23-12.52-2.14c-4-.59-8-1.09-12-1.44s-8.22-.61-12.34-.72C420.71,197.62,416.32,197.71,411.93,197.71ZM357,433c.16,1.09.26,1.87.37,2.65a13.85,13.85,0,0,0,7.45,10.77c4.63,2.49,9.69,3.28,14.76,4,3.55.53,7.12.92,10.69,1.2,4.34.35,8.71.52,13.06.75,2.19.11,4.37.24,6.56.23,7.75-.05,15.5-.08,23.24-.25,5.52-.12,11-.44,16.55-.71,2.33-.11,4.67-.21,7-.5,3.69-.47,7.39-1,11.05-1.67a27.64,27.64,0,0,0,10.11-3.62,14,14,0,0,0,6.76-13.08A79.26,79.26,0,0,0,483,421.33q-1.45-8-3.22-16c-1.23-5.49-2.61-10.95-4-16.41A49.47,49.47,0,0,0,474,383a3.62,3.62,0,0,0-3.51-2.44c-3.06.49-6.12,1-9.19,1.4-3.33.41-6.67.72-10,1-4.19.3-8.39.58-12.59.72-5.06.16-10.13.18-15.2.25q-2.65,0-5.31,0c-2.9-.06-5.81-.15-8.71-.23s-5.58-.14-8.36-.25c-3.49-.14-7-.31-10.47-.48-1.15-.06-2.3-.13-3.44-.26-2.78-.29-5.55-.6-8.33-.94-2.06-.26-4.13-.55-6.18-.88-1.49-.24-3.06-.62-4.07.88a12.09,12.09,0,0,0-1.6,3.48c-1.4,5.25-2.72,10.52-4,15.8q-1.21,5-2.25,10.07c-.87,4.26-1.71,8.53-2.45,12.81C357.81,427,357.44,430.11,357,433Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M344,435.82l-.13-.76a24.87,24.87,0,0,1-2.73,0c-.36,0-.92-.4-1-.7-.47-2.26-.94-4.53-1.22-6.82a28,28,0,0,1,0-4.58,1.45,1.45,0,0,1,1.76-1.57c.63.06,1.27,0,2,0l.11-2.39H343v2.23l.38-.17a9.78,9.78,0,0,1,1.3,2.15,30.86,30.86,0,0,1,.73,9.44,4.15,4.15,0,0,1-.54,1.41C344.56,434.67,344.26,435.29,344,435.82Zm1-5.74c-.12-1.62-.17-3.05-.34-4.46-.41-3.34-.85-3.74-3.45-3.8-1.17,0-1.75.49-1.8,1.54a23.67,23.67,0,0,0,0,4.21c.28,2.13.76,4.23,1.17,6.34a1,1,0,0,0,.33.59,2.82,2.82,0,0,0,3.72-1.44A21.14,21.14,0,0,0,345,430.08Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M339.16,300.17c0,2.16-.06,4.32,0,6.48a1.33,1.33,0,0,1-1.44,1.49,1.3,1.3,0,0,1-1.45-1.37q0-6.72,0-13.45a1.3,1.3,0,0,1,1.45-1.36,1.32,1.32,0,0,1,1.44,1.48C339.11,295.68,339.16,297.92,339.16,300.17Zm-.48,0c0-2.12,0-4.24,0-6.35a1.46,1.46,0,0,0-.79-1.13c-.78-.16-1.11.4-1.09,1.17,0,1,0,1.92,0,2.88,0,3.19,0,6.39,0,9.59,0,.77.3,1.19,1.12,1.21s.81-.56.81-1.14Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M504.17,380.29c0,2.2,0,4.4,0,6.59,0,1-.41,1.36-1.37,1.35s-1.29-.38-1.29-1.3c0-4.43,0-8.87,0-13.31,0-1,.39-1.52,1.39-1.5s1.3.48,1.28,1.45C504.13,375.81,504.17,378.05,504.17,380.29Zm-.48-.25c0-2.16,0-4.32,0-6.47,0-.33-.47-.64-.73-1-.3.3-.63.59-.9.92-.08.1,0,.31,0,.47q0,6.17,0,12.33c0,.7.1,1.41.92,1.33.3,0,.72-.82.73-1.28C503.73,384.27,503.69,382.15,503.69,380Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340.12,380.27c0,2.23,0,4.47,0,6.71,0,.78-.21,1.2-1,1.23s-1.49-.17-1.63-1.12a1,1,0,0,1,0-.24V373.54a1.29,1.29,0,0,1,1.4-1.42c.93-.05,1.26.42,1.25,1.31C340.11,375.71,340.12,378,340.12,380.27Zm-.48-.09c0-2.23,0-4.47,0-6.7,0-.3-.33-.79-.56-.82a1.13,1.13,0,0,0-.86.55,2.32,2.32,0,0,0-.22,1.12c0,3.88,0,7.75,0,11.62,0,.28-.09.64.05.82a7.1,7.1,0,0,0,1,1c.2-.36.58-.71.59-1.08C339.67,384.5,339.64,382.34,339.64,380.18Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M505.37,300.05c0,2.16-.05,4.32,0,6.48,0,1-.47,1.61-1.31,1.62s-1.38-.52-1.37-1.56q.06-6.54,0-13.09c0-1,.54-1.57,1.37-1.56s1.34.61,1.31,1.62C505.32,295.72,505.37,297.88,505.37,300.05Zm-.48,0c0-2.11,0-4.23,0-6.34,0-.72-.21-1.27-.88-1.27s-.85.51-.84,1.19c0,4.27,0,8.55.06,12.82,0,.4.51,1.1.82,1.12.58,0,.86-.48.84-1.17C504.86,304.32,504.89,302.2,504.89,300.08Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M501.94,296.6c0-.48.06-1,.06-1.43q0-22.14,0-44.28v-1.27h.24v1.17q0,22.31,0,44.63a4.61,4.61,0,0,1-.32,1.15Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340,307.61a4.46,4.46,0,0,1-.33-1.14q0-14.4,0-28.79c0-.43-.06-.86-.1-1.3h0a4.12,4.12,0,0,1,.34,1.14c0,9.59,0,19.18,0,28.78,0,.43.06.86.1,1.3Z"
                                            transform="translate(0.06 -0.14)" />
                                        <ellipse cx="348.69" cy="201.92" rx="0.06" ry="18.94" />
                                        <path
                                            d="M339.54,276.38a7.43,7.43,0,0,1-.13-.93q0-12.42,0-24.85a.7.7,0,0,1,.16-.47c0,.2.08.39.08.59v24.72a7.68,7.68,0,0,1-.11.95Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M501.67,319.62v-3.43l-1.08-.09V316l1.18-.15v-3c0-5,0-10,0-15a11.19,11.19,0,0,1,.16-1.28l0,0c0,1.07.09,2.15.09,3.22,0,4.68,0,9.35,0,14,0,.63.33,1.26.37,1.9,0,.31-.35.63-.37,1-.06.8,0,1.6,0,2.4,0,.18-.22.36-.33.54Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340.7,188.7c0,.44-.09.87-.09,1.3,0,6.95,0,13.91,0,20.86a4,4,0,0,1-.34,1.13h0c0-.43.1-.87.1-1.3q0-10.42,0-20.86a4.51,4.51,0,0,1,.33-1.13Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M501.17,195.67a4.12,4.12,0,0,1,.34,1.14q0,9.7,0,19.42c0,.43.06.87.1,1.3h0a4.12,4.12,0,0,1-.34-1.14c0-6.47,0-12.94,0-19.41,0-.43-.07-.86-.1-1.3Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340.23,327.31a3.68,3.68,0,0,1-.33-1c0-3.28.11-6.57-.1-9.83-.06-.87.24-1.66.12-2.52a19.34,19.34,0,0,1,0-3.23c0-1,.07-2.07.1-3.1h0c0,2.13.09,4.26.13,6.39,0,.59,0,1.18,0,1.78l1.52.3,0,0-1.55.17c0,1.65,0,3.32,0,5q0,3,.11,6.1Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M493,195.43c.12.14.33.28.33.42,0,6.36,0,12.72-.22,19.09V196.73c0-.44-.06-.87-.1-1.31Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M501.66,319.62c0,.67.1,1.34.1,2q0,7.37,0,14.74a3.51,3.51,0,0,1-.33,1h0c0-1.15.09-2.3.09-3.45,0-4.34,0-8.69,0-13a11.3,11.3,0,0,1,.14-1.29Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340.47,343.4c-.11-.14-.33-.28-.33-.42q0-7.73,0-15.45a.58.58,0,0,1,.08-.22h0c0,.47.12.94.13,1.41,0,4.46,0,8.92,0,13.39,0,.43.06.86.1,1.29Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M478.84,449.82c0,1.24.1,2.47.1,3.7,0,4.08,0,8.15-.14,12.24a2.7,2.7,0,0,1-.09-.48q0-7.26,0-14.51a5.91,5.91,0,0,1,.13-.94Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M501.42,337.39c0,1.6.09,3.19.1,4.78,0,3.15,0,6.31,0,9.46a2.92,2.92,0,0,1-.32.91l0,0q0-6.87.07-13.75c0-.48.09-.95.14-1.42Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M500.94,181c.11.1.32.2.32.3,0,4.78-.05,9.57-.08,14.35h0c-.05-.63-.12-1.26-.13-1.89Q501,187.41,501,181Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340.71,357.57c-.11-.09-.33-.19-.32-.29,0-4.63.05-9.25.08-13.88h0c0,.79.12,1.58.13,2.37,0,3.93.07,7.87.11,11.8Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M493,195.42c0-.74-.12-1.49-.13-2.24-.05-3.66-.07-7.31-.11-11h0c.12.1.33.2.33.3q0,6.45-.09,12.91Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M501,365.78q0-5.89.07-11.81c0-.47.12-.93.17-1.39l0,0q0,6.45.08,12.91c0,.1-.21.2-.32.31Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M363,453.92c0,.83.13,1.66.13,2.49,0,3.51,0,7-.17,10.54,0-.27-.06-.55-.06-.82V455a9.52,9.52,0,0,1,.11-1.06Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M341,369.83c-.11-.1-.33-.2-.32-.3,0-4,.05-8,.08-12h0c0,1.51.1,3,.13,4.52q.06,3.87.1,7.75Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path d="M339.67,240.93v-5.18l-1.28-.19,1.27-.22v-4.21h.24v9.8Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M500.7,377.52c0-3.45.07-6.9.11-10.35a13,13,0,0,1,.17-1.38l0,0c0,3.81.06,7.64.07,11.46,0,.1-.21.19-.32.29Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340.94,369.84c.05,1.66.1,3.32.14,5,0,1.86.07,3.72.1,5.59h0c-.11-.1-.32-.2-.32-.3,0-3.42.05-6.85.08-10.27Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M340.25,212c0,3.43.07,6.85.09,10.28,0,.1-.22.2-.33.29h0c0-3,.06-6.11.11-9.16,0-.47.09-.94.13-1.41Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path d="M340.71,188.71V178.56h.13c0,1.11,0,2.23,0,3.34q-.06,3.41-.14,6.81Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M349.11,178.13c0,2.64-.07,5.27-.1,7.91a4.71,4.71,0,0,1-.24,1.77v-6.49c0-.88,0-1.76,0-2.64,0-.19.21-.36.33-.54Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M500.7,377.51c0,3.11.07,6.21.08,9.32,0,.09-.21.19-.32.29h0c0-2.74.07-5.47.11-8.2,0-.47.09-.94.14-1.41Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M341.18,380.41c.05,2,.09,3.95.14,5.92,0,.91.07,1.82.1,2.73h0c-.11-.1-.32-.2-.32-.3,0-2.78.05-5.57.08-8.35Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M501.63,217.53q.06,3,.14,5.92c0,.75.06,1.5.1,2.25h0c-.12-.1-.33-.2-.33-.3q0-3.93.08-7.87Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M492.78,182.21c0-2-.09-4-.14-5.92,0-.75-.07-1.5-.1-2.25h0c.12.1.33.2.33.3,0,2.62-.05,5.25-.09,7.87Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path d="M340,222.56v7.75h0v-7.75Z" transform="translate(0.06 -0.14)" />
                                        <path d="M501.87,225.7v7.74h0v-7.75Z" transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M341.42,389.06v5.12h-.09v-2.59H339.7v-.22l1.55-.07c.07-.77.13-1.51.19-2.25Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M500.46,387.12c.06,2.1.13,4.19.2,6.43-.12-.07-.52-.19-.52-.3.08-2,.21-4.08.33-6.12Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path d="M349.12,178.14v-7h0v7Z" transform="translate(0.06 -0.14)" />
                                        <path d="M501,181v-6.54h0V181Z" transform="translate(0.06 -0.14)" />
                                        <path d="M492.54,174v-6.29h0v6.31Z" transform="translate(0.06 -0.14)" />
                                        <ellipse cx="421.02" cy="106.41" rx="16.73" ry="0.07" />
                                        <path class="cls-5"
                                            d="M368.17,278c3.4-.88,6.89-1.9,10.43-2.67,3.25-.71,6.55-1.21,9.85-1.68,2.46-.36,4.94-.52,7.41-.76,3.42-.32,6.84-.65,10.26-.95,1.46-.12,2.93-.21,4.4-.24,5.26-.1,10.53-.29,15.8-.21,4.28.06,8.56.39,12.83.7,3.34.24,6.68.55,10,1a122.36,122.36,0,0,1,20,3.59c1.52.44,3,1,4.36,1.45-.85,4.11-1.74,8-2.46,12-.4,2.2-.53,4.46-.77,6.69-.32,3-.64,6-.94,9.06-.12,1.18-.19,2.37-.25,3.56-.1,2-.18,4.05-.25,6.07-.16,5.18-.39,10.35-.46,15.52-.14,8.79-.2,17.59-.24,26.38,0,2.26.07,4.54.24,6.8.26,3.62.62,7.24.94,10.86.14,1.67.3,3.35.47,5.19-3.3.39-6.53.83-9.77,1.15-3.73.38-7.47.69-11.21,1-2.89.21-5.78.35-8.68.48-2.66.11-5.33.17-8,.25s-5.57.19-8.36.23q-5.18.06-10.35,0t-10.4-.25c-3-.1-5.95-.24-8.91-.48-4.05-.33-8.1-.76-12.14-1.19-3.35-.35-6.71-.77-10-1.15.27-2.88.5-5.62.79-8.36a184.85,184.85,0,0,0,.73-19.55c0-4.55.21-9.1.21-13.65,0-4.06-.11-8.13-.23-12.2s-.28-7.95-.48-11.92c-.19-3.55-.34-7.12-.75-10.66-.68-6-1.49-11.94-2.38-17.88C369.5,283.49,368.8,280.91,368.17,278Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-6"
                                            d="M413.27,204.2c-4.88.43-9.22.78-13.55,1.2-2.9.28-5.81.55-8.69,1-3.36.53-6.7,1.2-10,1.89-5.59,1.14-11.19,2.15-16.5,4.46a110.09,110.09,0,0,0-15.73,8.44,1.84,1.84,0,0,0-.68,1.3,46.58,46.58,0,0,0,1.56,11.31,172.09,172.09,0,0,0,6.52,21.41c2.17,5.78,4.48,11.51,6.7,17.27,1.37,3.54,4,4.5,7.4,3.31,1-.34,1.92-.68,2.89-1,6.9-2,14-2.81,21.09-3.6q4.18-.47,8.39-.72c3.6-.21,7.22-.45,10.83-.46q9.29,0,18.57.23c3.91.11,7.83.45,11.74.7,2.25.15,4.51.24,6.75.51,3.27.4,6.56.78,9.79,1.45a112.43,112.43,0,0,1,11.46,2.91c3,.95,5.57.18,6.92-2.65.32-.67.62-1.35.89-2,3.75-9.49,7.45-19,10.33-28.8a96.8,96.8,0,0,0,3.93-19,2.27,2.27,0,0,0-1.14-2.5,107.25,107.25,0,0,0-16.11-8.5c-6.07-2.51-12.56-3.55-19-4.8-4.43-.86-8.92-1.4-13.4-1.95-4.11-.5-8.24-.93-12.37-1.18-3.78-.23-7.58-.21-11.36-.27C417.91,204.17,415.32,204.2,413.27,204.2Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-1"
                                            d="M357,433c.4-2.84.77-6,1.3-9.07.74-4.28,1.58-8.55,2.45-12.81q1-5.06,2.25-10.07c1.29-5.28,2.61-10.55,4-15.8a12.09,12.09,0,0,1,1.6-3.48c1-1.5,2.58-1.12,4.07-.88,2,.33,4.12.62,6.18.88,2.78.34,5.55.65,8.33.94,1.14.13,2.29.2,3.44.26,3.49.17,7,.34,10.47.48,2.78.11,5.57.17,8.36.25s5.81.17,8.71.23q2.66,0,5.31,0c5.07-.07,10.14-.09,15.2-.25,4.2-.14,8.4-.42,12.59-.72,3.34-.25,6.68-.56,10-1,3.07-.37,6.13-.91,9.19-1.4A3.62,3.62,0,0,1,474,383a49.47,49.47,0,0,1,1.79,5.94c1.38,5.46,2.76,10.92,4,16.41q1.77,8,3.22,16a79.26,79.26,0,0,1,1.61,11.42,14,14,0,0,1-6.76,13.08,27.64,27.64,0,0,1-10.11,3.62c-3.66.66-7.36,1.2-11.05,1.67-2.32.29-4.66.39-7,.5-5.51.27-11,.59-16.55.71-7.74.17-15.49.2-23.24.25-2.19,0-4.37-.12-6.56-.23-4.35-.23-8.72-.4-13.06-.75-3.57-.28-7.14-.67-10.69-1.2-5.07-.75-10.13-1.54-14.76-4a13.85,13.85,0,0,1-7.45-10.77C357.3,434.82,357.2,434,357,433Zm86.36,18.2V451l4.39-.28c1.51-.09,3-.09,4.52-.26q5.81-.65,11.59-1.43A35.8,35.8,0,0,0,477,445.05a12,12,0,0,0,5.56-5.71c1.29-3.12,1.11-6.36.68-9.58s-1-6.18-1.64-9.25q-1.36-7-2.84-13.92c-.7-3.33-1.42-6.66-2.21-10-1-4.14-2.06-8.26-3.09-12.39a3.14,3.14,0,0,0-2.7-2.46,9,9,0,0,0-2.34.21c-4.49.55-9,1.16-13.47,1.65-3,.33-6,.55-9,.72q-5.47.33-10.95.49c-4.19.12-8.38.22-12.57.23-3.46,0-6.93-.12-10.39-.23-4.54-.14-9.07-.31-13.6-.47-2-.08-4.05-.15-6.08-.25-1.14-.06-2.29-.13-3.43-.25-2.9-.3-5.8-.61-8.7-.95-2.38-.28-4.77-.5-7.12-.95-3-.58-3.83.19-4.83,2.3a12.5,12.5,0,0,0-.77,2.57c-1.09,4.77-2.19,9.53-3.23,14.31-1,4.43-1.93,8.87-2.77,13.33-.74,3.89-1.31,7.82-2,11.72-.61,3.59-1.07,7.18-.21,10.81a12.37,12.37,0,0,0,3.41,6.33,18.44,18.44,0,0,0,8.06,4.2c6.17,1.67,12.52,2.25,18.85,2.86,4,.39,8.06.53,12.1.74,2.26.12,4.53.25,6.8.24,8.71-.05,17.42-.16,26.13-.22C437.59,451.13,440.5,451.15,443.4,451.15Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-1"
                                            d="M339.64,380.18c0,2.16,0,4.32,0,6.47,0,.37-.39.72-.59,1.08a7.1,7.1,0,0,1-1-1c-.14-.18-.05-.54-.05-.82,0-3.87,0-7.74,0-11.62a2.32,2.32,0,0,1,.22-1.12,1.13,1.13,0,0,1,.86-.55c.23,0,.56.52.56.82C339.66,375.71,339.64,378,339.64,380.18Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path
                                            d="M413.27,204.2c2.05,0,4.64,0,7.23,0,3.78.06,7.58,0,11.36.27,4.13.25,8.26.68,12.37,1.18,4.48.55,9,1.09,13.4,1.95,6.4,1.25,12.89,2.29,19,4.8a107.25,107.25,0,0,1,16.11,8.5,2.27,2.27,0,0,1,1.14,2.5,96.8,96.8,0,0,1-3.93,19c-2.88,9.8-6.58,19.31-10.33,28.8-.27.69-.57,1.37-.89,2-1.35,2.83-3.93,3.6-6.92,2.65a112.43,112.43,0,0,0-11.46-2.91c-3.23-.67-6.52-1.05-9.79-1.45-2.24-.27-4.5-.36-6.75-.51-3.91-.25-7.83-.59-11.74-.7q-9.28-.25-18.57-.23c-3.61,0-7.23.25-10.83.46q-4.2.25-8.39.72c-7.09.79-14.19,1.59-21.09,3.6-1,.28-1.93.62-2.89,1-3.38,1.19-6,.23-7.4-3.31-2.22-5.76-4.53-11.49-6.7-17.27a172.09,172.09,0,0,1-6.52-21.41,46.58,46.58,0,0,1-1.56-11.31,1.84,1.84,0,0,1,.68-1.3,110.09,110.09,0,0,1,15.73-8.44c5.31-2.31,10.91-3.32,16.5-4.46,3.34-.69,6.68-1.36,10-1.89,2.88-.45,5.79-.72,8.69-1C404.05,205,408.39,204.63,413.27,204.2Zm.22.48c-4.79.42-9.13.78-13.46,1.2-2.94.28-5.89.55-8.8,1-3.79.61-7.56,1.33-11.31,2.13a105,105,0,0,0-11.17,2.69c-7,2.29-13.32,5.88-19.48,9.81a1.7,1.7,0,0,0-.7,1.31,60.68,60.68,0,0,0,1.05,8.43c1.35,5.58,2.83,11.14,4.58,16.61s3.94,11.12,6,16.65q1.64,4.34,3.56,8.56a4,4,0,0,0,5.08,2.47,99.49,99.49,0,0,1,16.68-3.81c4.57-.6,9.16-1.07,13.76-1.46,4-.34,8-.68,12-.7,8.07-.05,16.14.11,24.21.21,1.47,0,2.94.11,4.4.24,4,.38,7.93.76,11.89,1.2,3.16.36,6.35.62,9.46,1.27,3.82.8,7.56,1.95,11.33,3,2.11.58,3.64.41,5-1.63a22.54,22.54,0,0,0,2.09-4.44c1.76-4.52,3.59-9,5.16-13.6,2.08-6.09,4-12.25,5.89-18.41a71.24,71.24,0,0,0,2.64-14.2,1.42,1.42,0,0,0-.74-1.67c-1.63-.85-3.18-1.86-4.77-2.8a81.34,81.34,0,0,0-13.75-6.63c-5.63-2-11.49-3-17.35-4-4.48-.79-9-1.56-13.48-2.13-3.88-.49-7.79-.74-11.69-1-3-.19-6-.22-9-.26C419.42,204.64,416.24,204.68,413.49,204.68Z"
                                            transform="translate(0.06 -0.14)" />
                                        <path class="cls-7"
                                            d="M443.4,451.15c-2.9,0-5.81,0-8.71,0-8.71.06-17.42.17-26.13.22-2.27,0-4.54-.12-6.8-.24-4-.21-8.08-.35-12.1-.74-6.33-.61-12.68-1.19-18.85-2.86a18.44,18.44,0,0,1-8.06-4.2,12.37,12.37,0,0,1-3.41-6.33c-.86-3.63-.4-7.22.21-10.81.66-3.9,1.23-7.83,2-11.72.84-4.46,1.8-8.9,2.77-13.33,1-4.78,2.14-9.54,3.23-14.31a12.5,12.5,0,0,1,.77-2.57c1-2.11,1.83-2.88,4.83-2.3,2.35.45,4.74.67,7.12.95,2.9.34,5.8.65,8.7.95,1.14.12,2.29.19,3.43.25,2,.1,4.05.17,6.08.25,4.53.16,9.06.33,13.6.47,3.46.11,6.93.24,10.39.23,4.19,0,8.38-.11,12.57-.23q5.48-.16,10.95-.49c3-.17,6-.39,9-.72,4.5-.49,9-1.1,13.47-1.65a9,9,0,0,1,2.34-.21,3.14,3.14,0,0,1,2.7,2.46c1,4.13,2.1,8.25,3.09,12.39.79,3.31,1.51,6.64,2.21,10q1.47,6.95,2.84,13.92c.6,3.07,1.22,6.15,1.64,9.25s.61,6.46-.68,9.58a12,12,0,0,1-5.56,5.71A35.8,35.8,0,0,1,463.91,449q-5.79.79-11.59,1.43c-1.5.17-3,.17-4.52.26l-4.39.28Z"
                                            transform="translate(0.06 -0.14)" />
                                    </g>
                                </svg>

                            </div>
                        </div> --}}


                    </div>

                    <ul class="list-inline wizard mb-0">
                        <li class="previous list-inline-item">
                            <button type="button" class="btn btn-info" {{ $count == 0 ? 'disabled' : '' }}
                                wire:click="previousStep()">Precedent</button>
                        </li>
                        <li class="next list-inline-item float-end">
                            @switch($count)
                                @case(0)
                                    <button type="button" class="btn btn-info" wire:click="vehiculeStep()">Suivant</button>
                                @break

                                @case(1)
                                    <button type="button" class="btn btn-info" wire:click="insuranceStep()">Suivant</button>
                                @break

                                @case(2)
                                    <button type="button" class="btn btn-info" wire:click="opponentStep()">Suivant</button>
                                @break

                                @case(3)
                                    <button type="" id="create" class="btn btn-info">Créer le dossier</button>
                                    {{-- <button type="button" class="btn btn-info" wire:click="pointStep()">Suivant</button> --}}
                                @break

                                {{--
                                    @case(4)
                                    <button type="" id="create" class="btn btn-info">Créer le dossier</button>
                                    @break
                                 --}}
                            @endswitch
                        </li>
                    </ul>

                </div> <!-- tab-content -->
            </form>
        </div>
    </div>

    @if ($dossiers && $dossiers->count() > 0)
        <div class="card border border-dark {{ $hidden ? 'd-none' : '' }}">
            <div class="card-body">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Matricule</th>
                            <th>Matricule WW</th>
                            <th>Propriétaire</th>
                            <th>date de creation</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($dossiers as $dossier)
                            <tr>
                                <td class="align-middle">{{ $dossier->ref }}</td>
                                <td class="align-middle">{{ $dossier->matricule }}</td>
                                <td class="align-middle">{{ $dossier->new_matricule }}</td>
                                <td class="align-middle">{{ $dossier->insured->name }}</td>
                                <td class="align-middle">{{ $dossier->created_at }}</td>
                                <td>
                                    <a class="btn btn-outline-success" target="_blank"
                                        href="{{ route('Dossier.show', $dossier->id) }}"> <i
                                            class="mdi mdi-eye"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif

    @if ($dossiers1 && $dossiers1->count() > 0)
        <div class="card border border-dark {{ $hidden ? 'd-none' : '' }}">
            <div class="card-body">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Réference</th>
                            <th>Matricule</th>
                            <th>Matricule WW</th>
                            <th>Assuré</th>
                            <th>date de creation</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($dossiers1 as $dossier)
                            <tr>
                                <td class="align-middle">{{ $dossier->ref }}</td>
                                <td class="align-middle">{{ $dossier->matricule }}</td>
                                <td class="align-middle">{{ $dossier->new_matricule }}</td>
                                <td class="align-middle">{{ $dossier->insured->name }}</td>
                                <td class="align-middle">{{ $dossier->created_at }}</td>
                                <td>
                                    <a class="btn btn-outline-success"
                                        href="{{ route('Dossier.show', $dossier->id) }}"> <i
                                            class="mdi mdi-eye"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
   
    <script>
         
        document.addEventListener('livewire:load', function() {
 
            const btn = document.getElementsByClassName('cls-3');

            for (var i = 0; i < btn.length; i++) {
                btn[i].addEventListener('click', function(e) {
                    // console.log(e.target);
                    // console.log(parseInt(e.target.dataset.name));
                    let cercle = document.getElementById(e.target.id);
                    if (cercle.classList.contains('fil')) {
                        cercle.classList.remove('fil');
                    } else {
                        cercle.classList.add('fil');
                    }
                    const fill = document.getElementsByClassName('fil');
                    const input = document.getElementById('point');
                    let array = [];
                    for (var i = 0; i < fill.length; i++) {
                        console.log(fill[i].dataset.name);
                        array.push(fill[i].dataset.name)
                    }
                    console.log(array);
                    input.value = array;

                });
            }


        })
    </script>
</div>
