<?php

namespace App\Exports;

use App\Models\Dossier;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class DossierEnCoursExport implements FromView
{
    /**
    * @return \Illuminate\Support\Collection
    */

   

    public function view(): View
    {
        if(Auth::user()->role_id == 4){
            $dossiers = Dossier::where('dossier_status_id', 2)
            ->with('insured', 'typevehicule', 'city', 'garage', 'vehiculemodel.brand', 'opponent', 'guarantee', 'company', 'garage', 'status', 'mode', 'opponent.vehiculemodel.brand')
            ->get();
        }else{
                $dossiers = Dossier::where('dossier_status_id', 2)
                ->with('insured', 'typevehicule', 'city', 'garage', 'vehiculemodel.brand', 'opponent', 'guarantee', 'company', 'garage', 'status', 'mode', 'opponent.vehiculemodel.brand')
                ->whereHas('step', function ($query)  {
                    $query->where('user_id', Auth::user()->id);
                })->get();
        }
        return view('configuration.chart.excel', compact('dossiers'));

    }
}
