<?php

namespace App\Http\Controllers;

use Image;
use Carbon\Carbon;
use App\Models\City;
use App\Models\Mode;
use App\Models\Step;
use App\Models\User;
use App\Models\Brand;
use App\Models\Devis;
use App\Models\Email;
use App\Models\Piece;
use App\Models\Garage;
use App\Models\Company;
use App\Models\Demande;
use App\Models\Dossier;
use App\Models\Insured;
use App\Models\Meeting;
use App\Models\Montant;
use App\Models\Rapport;
use App\Models\Currency;
use App\Models\Document;
use App\Models\Opponent;
use App\Mail\CarenceDocs;
use App\Models\Carburant;
use App\Models\Guarantee;
use App\Models\DevisPiece;
use App\Models\Observation;
use App\Models\Transaction;
use App\Models\Notification;
use App\Models\RapportPiece;
use App\Models\TypeDocument;
use App\Models\TypeVehicule;
use Illuminate\Http\Request;
use App\Models\DossierStatus;
use App\Models\Intermidiaire;
use App\Models\TypeExpertise;
use App\Models\VehiculeModel;
use App\Exports\ExportDossier;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use function GuzzleHttp\Promise\all;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\DossierEnCoursExport;
use App\Models\Ticket;
use Illuminate\Support\Facades\Storage;

use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;

class DossierController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $this->authorize('viewAny', Dossier::class);

        // $devispieces= DevisPiece::all();
        // foreach($devispieces as $d){
        //     $p = Piece::whereId($d->piece_id)->first();
        //     $devis = Devis::whereId($d->devis_id)->first();

        //     $devis->piece()->attach($p, [
        //         'qte' => $d->qte, 'prix_unitaire' => $p->prix_unitaire, 'gravite' => $p->gravite, 'etat' => $p->etat, 'vetuste' => $d->vetuste ?? 0, 'remise' => $d->remise ?? 0, 'montant_ht' => 0,
        //         'type_reparation_id' => $p->type_reparation_id, 'operation_id' => $p->operation_id
        //     ]);
        // }
        // $rppieces= RapportPiece::all();
        // foreach($rppieces as $d){
        //     $p = Piece::whereId($d->piece_id)->first();
        //     $rp = Rapport::whereId($d->rapport_id)->first();
        //     $rp->piece()->attach($p, [
        //         'qte' => $d->qte, 'prix_unitaire' => $p->prix_unitaire, 'gravite' => $p->gravite, 'etat' => $p->etat, 'vetuste' => $d->vetuste ?? 0, 'remise' => $d->remise ?? 0, 'montant_ht' => 0,
        //         'type_reparation_id' => $p->type_reparation_id, 'operation_id' => $p->operation_id
        //     ]);
        // }


        $id = Auth::user()->id;
        // $step = Step::whereHas('dossier', function ($query) use ($id) {
        //     $query->where('user_id', $id);
        // })->get();
        // dd($step);
        if (Auth::user()->role_id != 4) {
            $dossiers = Dossier::where('dossier_status_id', 2)->user()->with(['insured',  'currentStep', 'typeexpertise', 'company', 'mode', 'status', 'company.seuil', 'typeexpertise.usercompany'])

                ->paginate(10);
            // $dossiersAnomalie = Dossier::where('dossier_status_id', 1)
            //     ->whereHas('step', function ($query) use ($id) {
            //         $query->where('user_id', $id);
            //     })->paginate(10);
        } else {
            $dossiers = Dossier::where('dossier_status_id', 2)->with(['insured',  'currentStep', 'typeexpertise', 'company', 'mode', 'status'])->where('dossier_status_id', 2)->paginate(10);
            // $dossiersAnomalie = Dossier::with(['insured', 'opponent', 'guarantee', 'company', 'mode', 'observation', 'status', 'garage'])->where('dossier_status_id', 1)->paginate(10);
        }


        return view('dossiers.index', compact('dossiers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $this->authorize('create', Dossier::class);
        // $user = User::whereId(1)->first();
        // Mail::to("namatyyassine@gmail.com")->send(new CarenceDocs($user));
        return view('dossiers.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function export(Request $request)
    {
        return Excel::download(new DossierEnCoursExport(), 'dossiersencours.xlsx');
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {


        $dossier = Dossier::whereId($id)->with('insured', 'typevehicule', 'currency', 'city', 'carburant', 'contradictoire', 'shockpoint', 'garage', 'vehiculemodel.brand', 'opponent', 'guarantee', 'company', 'status', 'observation', 'status', 'mode', 'step', 'document', 'document.typedocument', 'devis', 'opponent.vehiculemodel.brand')
            ->with('document', function ($query) {
                $query->whereHas('typedocument', function ($query) {
                    $query->where('is_pdf', 0)->where('id', '!=', 9)->latest();
                });
            })->firstOrFail();


        $this->authorize('view', $dossier);
        $array = [];
        foreach ($dossier->step as $step) {
            array_push($array, $step->id);
        }
        // check if we have a document devis
        $d = 0;
        foreach ($dossier->devis as $devis) {
            if ($devis->devis_status_id === 2 || $devis->devis_status_id === 7) {
                $d = 1;
            }
        }
        $rap = Rapport::where('dossier_id', $id)->count();
        if (Auth::user()->role_id != 6) {
            $types = TypeDocument::where('is_pdf', false)->whereNotIn('id', [30, 29, 4, 8, 18, 9, 11])->get();
        } else {
            $user = User::whereId(Auth::user()->id)->with('typedocument')->first();
            $types = TypeDocument::where('is_pdf', false)->whereIn('id', $user->typedocument->pluck('id'))->whereNotIn('id', [30, 29, 4, 8, 18, 9, 11])->get();
        }
        // $check1 = Step::whereId('6')->with('dossier')->whereHas('dossier', function ($query) use ($dossier) {
        //     $query->where('dossier_id', $dossier->id);
        // })->count();

        // get time for this step
        if ($dossier->company_id) {
            $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                $query->where('step_id', $dossier->step_id)->first();
            })->first();
            $stepdate = DB::table('step_dossier')
                ->where('dossier_id', $dossier->id)
                ->where('step_id', $dossier->currentStep->id)
                ->latest()->first();

            // if ($company->step) {
            //     $monthdate = Carbon::parse($stepdate->created_at);
            //     $dateDiff = Carbon::now()->diffInHours($monthdate);
            //     $limit = $company->step[0]->pivot->time ?? 0;
            // }
            // $timeleft = $limit - $dateDiff;
            $limit = 0;
            $timeleft = 0;
        } else {
            $limit = 0;
            $timeleft = 0;
        }

        $raps = Rapport::where('dossier_id', $id)->where('rapport_status_id', 3)->count();
        $montant = Montant::where('dossier_id', $id)->first();
        $typedocuments = TypeDocument::where('is_pdf', '0')->whereHas('document', function ($query) use ($id) {
            $query->where('dossier_id', $id);
        })->get();
        $step = Step::whereHas('dossier', function ($query) use ($id) {
            $query->where('dossier_id', $id);
        })->with('dossier')->latest()->first();
        if ($dossier->dossier_status_id != 3) {
            $now = Carbon::now()->format('H:i');
            $time =  $dossier->created_at->diff($now);
        } else {
            $time =  $dossier->created_at->diff($dossier->date_fin);
        }

        $observations = Observation::where('dossier_id', $id)->with('user')->get();
        $count2 = count($array);
        $count1 = Step::count();
        if ($count2 <= 1) {
            $count = $count1 * 10;
        } else {
            $c = $count1 / $count2;
            $count = $c * 100;
        }
        // $check = DB::table('step_dossier')
        //     ->where('dossier_id', $dossier->id)
        //     ->where('step_id', 6)->count();

        // $count = Dossier::whereId($dossier->id)->whereHas('step', function ($query) {
        //     $query->where('user_id', Auth::user()->id);
        // })->with('step')->count();
        // if ($count > 0) {
        //     $user = 1;
        // }
        $auth = User::whereId(Auth::user()->id)->first();

        if ($auth->hasPermission('controler_devis') || $auth->hasRolePermission('controler_devis')) {
            $user = 1;
        } else {
            $user = User::whereId(Auth::user()->id)->wherehas('typecompany', function ($query) use ($dossier) {
                $query->where('company_id', $dossier->company_id)->where('type_expertise_id', $dossier->type_expertise_id);
            })->exists();
        }
        $historiques = Dossier::where('id', '!=', $dossier->id)
            ->where(function ($query) use ($dossier) {
                if (!empty($dossier->matricule)) {
                    $query->where('matricule', $dossier->matricule);
                }
                if (!empty($dossier->new_matricule)) {
                    $query->orWhere('new_matricule', $dossier->new_matricule);
                }
            })
            ->get();

        $ticketcount  = Ticket::where('dossier_id', $id)->where('user_id', Auth::user()->id)->where('status_rendezvous_id', 2)->count();


        return view('dossiers.show', compact('dossier','ticketcount' ,'id', 'historiques', 'timeleft', 'd', 'limit',  'rap', 'raps', 'step', 'array', 'time', 'observations', 'count', 'typedocuments', 'montant', 'user', 'types'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dossier = Dossier::whereId($id)->with('insured', 'typevehicule', 'city', 'currency', 'mode', 'garage', 'opponent', 'guarantee', 'carburant', 'company', 'intermidiaire', 'status', 'typeexpertise', 'mode', 'opponent.vehiculemodel', 'opponent.vehiculemodel.brand')->firstOrFail();
        $this->authorize('update', $dossier);
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $typevehicules = TypeVehicule::get()->sortBy(function ($type) {
            return strtolower($type->type);
        })
            ->values();
        $companies = Company::get()->sortBy(function ($company) {
            return strtolower($company->company);
        })
            ->values();
        $companiesop = Company::get()->sortBy(function ($company) {
            return strtolower($company->company);
        })
            ->values();
        $guarantees = Guarantee::get()->sortBy(function ($company) {
            return strtolower($company->guarantee);
        })
            ->values();
        $modes = Mode::get()->sortBy(function ($mode) {
            return strtolower($mode->mode);
        })
            ->values();
        $typeexpertises = TypeExpertise::get()->sortBy(function ($type) {
            return strtolower($type->type);
        })
            ->values();
        $intermidiaires = Intermidiaire::get()->sortBy(function ($company) {
            return strtolower($company->company);
        })
            ->values();
        $brands = Brand::get()->sortBy(function ($company) {
            return strtolower($company->brand);
        })
            ->values();
        $garages = Garage::get()->sortBy(function ($company) {
            return strtolower($company->libelle);
        })
            ->values();
        $models = VehiculeModel::get()->sortBy(function ($company) {
            return strtolower($company->name);
        })
            ->values();
        $modelsop = VehiculeModel::get()->sortBy(function ($company) {
            return strtolower($company->name);
        })
            ->values();
        $carburants = Carburant::get()->sortBy(function ($company) {
            return strtolower($company->name);
        })
            ->values();
        $cities = City::get()->sortBy(function ($company) {
            return strtolower($company->city);
        })
            ->values();
        $currencies = Currency::get()->sortBy(function ($company) {
            return strtolower($company->name);
        })
            ->values();

        return view('dossiers.edit', compact('dossier', 'currencies', 'companiesop', 'carburants', 'garages', 'typevehicules', 'cities', 'companies', 'guarantees', 'modes', 'typeexpertises', 'intermidiaires', 'brands', 'models', 'modelsop'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            'telephone' => 'nullable|min:10|max:10',
            'telephoneop' => 'nullable|min:10|max:10',
            'numero_chassis' => 'min:17|max:17|nullable',
            'matriculeop' => 'nullable',
            'date_sinistre' => 'required',
            'company' => 'required',
            // 'ref' => 'nullable|unique:dossiers,ref,' . $id,
            'numero_sinistre' => 'required|unique:dossiers,numero_sinistre,' . $id,
            'currency_id' => 'required',

        ]);
        $dossier = Dossier::whereId($id)->with('insured', 'garage', 'city',  'opponent', 'carburant', 'guarantee', 'company', 'status', 'observation', 'status')->firstOrFail();
        $this->authorize('update', $dossier);
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        // $step = DB::table('step_dossier')
        //     ->where('dossier_id', $dossier->id)
        //     ->latest()->first();
        // if (Auth::user()->id != $step->user_id) {
        //     return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Vous avez pas le droit de apporter des modification a ce dossier maintenant');
        // }

        // $currentDate = $dossier->created_at;
        // $targetDate = Carbon::create(2023, 8, 1);
        // if ($currentDate->greaterThan($targetDate)) {
        // } else {
        //     $dossier->ref = $request->ref;
        // }

        if ($dossier->opponent) {
            $opponent = Opponent::whereId($dossier->opponent->id)->first();
            $opponent->civility = $request->civilityop;
            $opponent->matricule = $request->matriculeop;
            $opponent->name = $request->nameop;
            $opponent->telephone = $request->telephoneop;
            $opponent->company_id = $request->company_op;
            $opponent->vehicule_model_id = $request->vehicule_modelop_id;
            $opponent->numero_attestation = $request->numero_attestationop;

            $opponent->update();
        } else {
            $opponent = Opponent::create([
                'civility' => $request->civilityop,
                'matricule' => $request->matriculeop,
                'name' => $request->nameop,
                'telephone' => $request->telephoneop,
                'company_id' => $request->companyop_id,
                'vehicule_model_id' => $request->vehicule_modelop_id,
                'numero_attestation' => $request->numero_attestationop
            ]);
        }

        $insured = Insured::whereId($dossier->insured->id)->first();
        $insured->civility = $request->civility;
        $insured->name = $request->name;
        $insured->telephone = $request->telephone;
        $insured->update();
        $dossier->matricule = $request->matricule;
        $dossier->new_matricule = $request->new_matricule;
        $dossier->opponent_id = $opponent->id;
        $dossier->company_id = $request->company;
        $dossier->type_vehicule_id = $request->typevehicule;
        $dossier->garage_id = $request->garage_id;
        $dossier->guarantee_id = $request->guarantee;
        $dossier->mode_id = $request->mode;
        $dossier->intermidiaire_id = $request->intermidiaire_id;
        $dossier->type_expertise_id = $request->typeexpertise;
        $dossier->vehicule_model_id = $request->vehicule_model_id;
        $dossier->city_id = $request->city_id;
        $dossier->currency_id = $request->currency_id;
        $dossier->numero_sinistre = $request->numero_sinistre;
        $dossier->numero_attestation = $request->numero_attestation;
        $dossier->numero_chassis = $request->numero_chassis;
        $dossier->numero_police = $request->numero_police;
        $dossier->date_sinistre = $request->date_sinistre;
        $dossier->date_circulation = $request->date_circulation;
        $dossier->date_reception = $request->date_reception;
        $dossier->carburant_id = $request->carburant;
        $dossier->kilometrage = $request->kilometrage;
        $dossier->puissance_fiscale = $request->puissance_fiscale;
        $dossier->montant_accord_adverse = $request->montant_accord_adverse;
        // $dossier->valeurepave = $request->valeurepave;
        // $dossier->valeurneuf = $request->valeurneuf;
        // $dossier->valeurvenale = $request->valeurvenale - $request->horssinistre;
        // $dossier->valeuradire = $request->valeurvenale - $request->valeurepave;
        // $dossier->horssinistre_ttc = $request->horssinistre_ttc;
        // $dossier->valeurepave_ttc = $request->valeurepave_ttc;
        // $dossier->valeurneuf_ttc = $request->valeurneuf_ttc;
        // $dossier->valeurvenale_ttc = $request->valeurvenale_ttc - $request->horssinistre_ttc;
        // $dossier->valeuradire_ttc = $request->valeurvenale_ttc - $request->valeurepave_ttc;
        // $dossier->ref = $request->ref;

        $dossier->update();
        \App\Services\SidebarCache::clear();

        return redirect()->route('Dossier.show', $dossier->id)->with('success', 'Modifier avec Succés');
    }

    public function anomalie($id)
    {
        $this->authorize('status', Dossier::class);
        $dossier = Dossier::whereId($id)->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        if ($dossier->dossier_status_id == 2) {
            $dossier->update(['dossier_status_id' => 1]);
            $status = DossierStatus::whereId(1)->first();
            $dossier->dossierstatus()->attach($status);
            \App\Services\SidebarCache::clear();
            return redirect()->route('Dossier.show', $dossier->id)->with('success', 'Dossier Declarer Anomalie');
        } else {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est cloturer ou deja declarer Anomalie');
        }
    }

    public function encours($id)
    {
        $this->authorize('status', Dossier::class);
        $dossier = Dossier::whereId($id)->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        if ($dossier->dossier_status_id != 2) {
            $dossier->update(['dossier_status_id' => 2]);
            $status = DossierStatus::whereId(2)->first();
            $dossier->dossierstatus()->attach($status);
            \App\Services\SidebarCache::clear();
            return redirect()->route('Dossier.show', $id)->with('success', 'Dossier Declarer Anomalie');
        } else {
            return redirect()->route('Dossier.show', $id)->with('error', 'Dossier est deja en Cours');
        }
    }

    public function envoyer($id)
    {
        //affecter au chiffreur qui respecte les condition du dossier et quia les moint dossier affecter aujourdhui
        $step = Step::whereId(4)->first();
        $dossier = Dossier::whereId($id)->with('step', 'company', 'city',  'typeexpertise', 'devis')->firstOrFail();
        // $step = DB::table('step_dossier')
        //     ->where('dossier_id', $dossier->id)
        //     ->latest()->first();
        // if (Auth::user()->id != $step->user_id) {
        //     return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Vous avez pas le droit de apporter des modification a ce dossier maintenant');
        // }
        // chiffreur qui ont les infos suivante
        $chiffreurs = User::where('role_id', 2)->whereHas('company', function ($query) use ($dossier) {
            $query->where('company_id', '=', $dossier->company->id);
        })->whereHas('typeexpertise', function ($query) use ($dossier) {
            $query->where('type_expertise_id', '=', $dossier->typeexpertise->id);
        })->whereHas('guarantee', function ($query) use ($dossier) {
            $query->where('guarantee_id', '=', $dossier->guarantee->id);
        })->whereHas('seuil', function ($query) {
            $query->where('accord', '>', 0);
        })->with('typeexpertise', 'company', 'guarantee', 'seuil')->get();

        if (count($chiffreurs) < 1) {
            return redirect()->route('Dossier.show', $id)->with('error', 'Pas de chiffreur Corespondant a cette mission.');
        }
        $array = [];
        foreach ($chiffreurs as $chiffreur) {
            array_push($array, $chiffreur->id);
        }
        if (empty($array)) {
            return redirect()->back();
        }

        $steps = DB::table('step_dossier')
            ->select('user_id')
            ->where('step_dossier.step_id', 4)
            ->whereIn('user_id', $array)
            ->get();
        // $steps = Step::whereHas('dossier', function ($query) use ($array) {
        //     $query->whereIn('user_id', $array);
        // })->with('dossier')->whereId(4)->first();
        $idarray = [];
        if ($steps) {
            for ($i = 0; $i < $steps->count(); $i++) {
                array_push($idarray, $steps[$i]->user_id);
            }
        }


        if ($steps) {
            $count = DB::table('step_dossier')
                ->select('user_id', DB::raw('COUNT(user_id) as count'))
                ->groupBy('user_id')
                ->orderBy('count')
                ->whereDate('step_dossier.created_at', Carbon::today())
                ->whereIn('user_id', $idarray)
                ->get();
        } else {
            $count = DB::table('step_dossier')
                ->select('user_id', DB::raw('COUNT(user_id) as count'))
                ->groupBy('user_id')
                ->orderBy('count')
                ->where('step_id', 4)
                ->whereDate('step_dossier.created_at', '=', Carbon::today())
                ->get();
        }
        if ($count->count() >= count($chiffreurs)) {
            $user = User::whereId($count[0]->user_id)->firstOrFail();
        } else if ($count->count() > 0) {
            $c = [];
            foreach ($count as $s) {
                array_push($c, $s->user_id);
            }
            $user = User::where('role_id', 2)->whereNotIn('id', $c)->firstOrFail();
        } else {
            $user = User::where('role_id', 2)->first();
        }

        $dossier->step()->attach($step, ['user_id' => $user->id]);

        return redirect()->route('Dossier.show', $id)->with('success', 'La mission est Affecter avec succés');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Dossier  $dossier
     * @return \Illuminate\Http\Response
     */
    public function douteux($id)
    {
        $this->authorize('douteux', Dossier::class);
        $user = User::findOrFail(Auth::user()->id);
        $dossier = Dossier::find($id);
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        if ($user->role_id === 4 || $user->hasPermission('sinistre_douteux') || $user->hasRolePermission('sinistre_douteux')) {
            if ($dossier->sinistre_douteux == 1) {
                $body = "A Declarer Dossier Non Douteux  :" . $dossier->ref;
                $dossier->sinistre_douteux = 0;
                $dossier->update();
                Notification::create([
                    'user_id' => Auth::user()->id,
                    'dossier_id' => $dossier->id,
                    'body' => $body
                ]);
                \App\Services\SidebarCache::clear();
                return redirect()->back()->with('success', 'Dossier est Declarer NON Douteux');
            } else {
                $dossier->sinistre_douteux = 1;
                $dossier->update();
                $body = "A Declarer Dossier Douteux Ref :" . $dossier->ref;
                Notification::create([
                    'user_id' => Auth::user()->id,
                    'dossier_id' => $dossier->id,
                    'body' => $body
                ]);
                \App\Services\SidebarCache::clear();
                return redirect()->back()->with('success', 'Dossier est Declarer Douteux');
            }
        }
        return redirect()->back();
    }

    public function url($dossier_id)
    {
        $dossier = Dossier::whereId($dossier_id)->first();
        // $this->authorize('viewAny', SignedUrl::class);
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        $typedocuments = TypeDocument::whereNotIn('id', [9, 10, 11, 12, 13, 14, 15, 18, 16, 11])->get();
        return view('dossiers.signedurl', compact('typedocuments', 'dossier'));
    }

    public function archive()
    {
        $this->authorize('viewAny', Dossier::class);
        $dossiers = Dossier::where('dossier_status_id', 3)->with('payment', 'typeexpertise', 'company')->paginate(10);
        //dd($dossiers);
        return view('dossiers.cloturer', compact('dossiers'));
    }


    public function facturation($id)
    {
        $this->authorize('cloturer', Dossier::class);
        $dossier = Dossier::whereId($id)->with('rapport')->firstOrFail();
        $count = 0;
        foreach ($dossier->rapport as $rap) {
            if ($rap->rapport_status_id == 2 || $rap->rapport_status_id == 3) {
                $count++;
            }
        }
        if ($dossier->dossier_status_id == 3) {
            return redirect()->back()->with('error', 'Dossier est Cloturer');
        }

        if ($count == 0) {
            return redirect()->back()->with('error', 'rapport pas encore signer');
        }
        return view('dossiers.facturation', compact('dossier'));
    }

    public function cloturer(Request $request)
    {
        $dossier = Dossier::whereId($request->dossier_id)->with('onerapport')->firstOrFail();
        $this->authorize('cloturer', Dossier::class);

        $validator = Validator::make(
            $request->all(),
            [
                'files' => 'required',
                'files.*' => 'required|file'
            ],
            [
                'files.*.required' => 'Ce champ est Obligatoire',
                'files.*.file' => 'Seuls les fichiers images et PDF sont autorisés',
            ]
        );


        if ($validator->fails()) {
            return Redirect::back()->withErrors($validator->messages());
        }

        if ($dossier->onerapport) {
            if ($dossier->onerapport->rapport_status_id != 3) {
                return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Merci de deamander au Gestionnaire de Envoyer le Rapport avant de Cloturé');
            }
        }

        $type  = TypeDocument::whereId(12)->firstOrFail();

        if ($dossier->dossier_status_id != 3) {
            if ($request->pdfs) {
                $array = explode(",", $request->pdfs);
                for ($i = 1; $i < count($array); $i += 2) {
                    $image = base64_decode($array[$i]);
                    $img = Image::make($image);
                    $watermark = Image::make(public_path('/img/amea2.png'))->resize(100, 120)->opacity(50);
                    $img->insert($watermark, 'top-left', 10, 10);
                    $text = $dossier->ref . " : " . $type->type . " par " . Auth::user()->name . " " . now();

                    $img->text($text, 80, 30, function ($font) {
                        $font->file(public_path('fonts/gnuolane.ttf'));
                        $font->size(21);
                        $font->color('#FF0000');
                        $font->align('top');
                        $font->valign('right');
                        $font->angle(0);
                    });
                    $filename = uniqid() . '.' . 'png';
                    Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $img->stream());
                    $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
                    Document::create([
                        'path' => $path,
                        'dossier_id' => $dossier->id,
                        'type_document_id' => $type->id
                    ]);
                }
            }

            if ($request->file('files')) {
                $files = $request->file('files');
                foreach ($files as $file) {
$pdfMimes = ['application/pdf', 'application/x-pdf', 'application/acrobat', 'application/vnd.pdf', 'text/pdf', 'text/x-pdf'];
                    $isPdf = in_array($file->getMimeType(), $pdfMimes) || strtolower($file->getClientOriginalExtension()) == 'pdf';
                    
                    if ($isPdf) {
                        // Convert PDF to images using Imagick
                        $tempDir = storage_path('app/temp/pdf_' . uniqid());
                        if (!file_exists($tempDir)) {
                            mkdir($tempDir, 0755, true);
                        }
                        
                        $tempPdfPath = $tempDir . '/' . uniqid() . '.pdf';
                        copy($file->getRealPath(), $tempPdfPath);
                        
                        if (extension_loaded('imagick')) {
                            $imagick = new \Imagick();
                            $imagick->setResolution(150, 150);
                            $imagick->readImage($tempPdfPath);
                            $pageCount = $imagick->getNumberImages();
                            
                            for ($i = 0; $i < $pageCount; $i++) {
                                $imagick->setIteratorIndex($i);
                                $imagick->setImageFormat('png');
                                $imagick->setImageCompressionQuality(90);
                                $imagick->setImageBackgroundColor('white');
                                $imagick->setImageAlphaChannel(\Imagick::ALPHACHANNEL_REMOVE);
                                
                                $tempImagePath = $tempDir . '/' . uniqid() . '.png';
                                $imagick->writeImage($tempImagePath);
                                
                                $img = Image::make($tempImagePath);
                                $watermark = Image::make(public_path('/img/amea2.png'))->resize(100, 120)->opacity(50);
                                $img->insert($watermark, 'top-left', 10, 10);
                                $text = $dossier->ref . " : " . $type->type . " par " . Auth::user()->name . " " . now();
                                $img->text($text, 80, 30, function ($font) {
                                    $font->file(public_path('fonts/gnuolane.ttf'));
                                    $font->size(21);
                                    $font->color('#FF0000');
                                    $font->align('top');
                                    $font->valign('right');
                                    $font->angle(0);
                                });
                                
                                $filename = uniqid() . '.png';
                                Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $img->stream());
                                $path3 = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
                                Document::create([
                                    'path' => $path3,
                                    'type_document_id' => $type->id,
                                    'dossier_id' => $dossier->id,
                                ]);
                                unlink($tempImagePath);
                            }
                            $imagick->clear();
                            $imagick->destroy();
                        }
                        
                        unlink($tempPdfPath);
                        rmdir($tempDir);
                    } else {
                        $img = Image::make($file);
                        $watermark = Image::make(public_path('/img/amea2.png'))->resize(100, 120)->opacity(50);
                        $img->insert($watermark, 'top-left', 10, 10);
                        $text = $dossier->ref . " : " . $type->type . " par " . Auth::user()->name . " " . now();
                        $img->text($text, 80, 30, function ($font) {
                            $font->file(public_path('fonts/gnuolane.ttf'));
                            $font->size(21);
                            $font->color('#FF0000');
                            $font->align('top');
                            $font->valign('right');
                            $font->angle(0);
                        });
                        $filename = uniqid() . '.' . File::extension($file->getClientOriginalName());
                        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $img->stream());
                        $path3 = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
                        // Store the file in the disk
                        Document::create([
                            'path' => $path3,
                            'type_document_id' => $type->id,
                            'dossier_id' => $dossier->id,
                        ]);
                    }
                }
            }
            $dossier->dossier_status_id = 3;
            $dossier->update = 1;
            $dossier->date_facturation = now();
            $dossier->update();
            $status = DossierStatus::whereId(3)->first();
            $dossier->dossierstatus()->attach($status);
            $meetings = Meeting::where('dossier_id', $dossier->id)->where('meeting_status_id', 2)->get();
            foreach ($meetings as $meet) {
                $meet->meeting_status_id = 1;
                $meet->update();
            }

            $body = "A Cloturer Dossier Ref :" . $dossier->ref;
            Notification::create([
                'user_id' => Auth::user()->id,
                'dossier_id' => $dossier->id,
                'body' => $body
            ]);
            $step = Step::whereId(14)->firstOrFail();
            $dossier->step()->attach($step, ['user_id' => Auth::user()->id]);
            \App\Services\SidebarCache::clear();
            return redirect()->route('Dossier.show', $dossier->id)->with('success', 'Dossier Est Cloturer Avec Succés');
        } else {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier Est Deja Cloturer ');
        }
    }

    public function annuler(Request $request)
    {
        $dossier = Dossier::whereId($request->dossier_id)->firstOrFail();
        $this->authorize('annuler', Dossier::class);

        if ($dossier->dossier_status_id != 3) {
            $dossier->dossier_status_id = 1;
            $dossier->update();
            $status = DossierStatus::whereId(1)->first();
            $dossier->dossierstatus()->attach($status);
            $meetings = Meeting::where('dossier_id', $dossier->id)->where('meeting_status_id', 2)->get();
            foreach ($meetings as $meet) {
                $meet->meeting_status_id = 1;
                $meet->update();
            }
            $body = "A Annuler Dossier Ref :" . $dossier->ref;
            Notification::create([
                'user_id' => Auth::user()->id,
                'dossier_id' => $dossier->id,
                'body' => $body
            ]);
            \App\Services\SidebarCache::clear();
            return redirect()->route('Dossier.show', $dossier->id)->with('success', 'Dossier Est Annuler Avec Succés');
        } else {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier Est Deja Cloturer ');
        }
    }

 /**
 * Optimized Archive Search 
 
 */
public function archiveSearch(Request $request)
{
    $this->authorize('viewAny', Dossier::class);

    $rawSearch = trim($request->search);
    
    // Remove dots, spaces, dashes, and slashes from search input
    $search = preg_replace('/[\.\s\-\/]+/', '', $rawSearch);

    // If empty or less than 3 characters, return latest 10
    if (empty($search) || strlen($search) < 3) {
        $dossiers = Dossier::with('insured')
            ->latest()
            ->take(10)
            ->get();
        
        return view('dossiers.cloturer', compact('dossiers'));
    }

    // Search with normalized input against normalized DB values
    $dossiers = Dossier::with('insured')
        ->where(function ($query) use ($search) {
            // Matricule
            $query->whereRaw("REPLACE(REPLACE(REPLACE(new_matricule, '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $search . '%'])
                  ->orWhereRaw("REPLACE(REPLACE(REPLACE(matricule, '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $search . '%'])
                  // Référence
                  ->orWhereRaw("REPLACE(REPLACE(REPLACE(ref, '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $search . '%'])
                  // N° Sinistre
                  ->orWhereRaw("REPLACE(REPLACE(REPLACE(numero_sinistre, '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $search . '%'])
                  // Dates (date_sinistre, date_reception, created_at)
                  ->orWhereRaw("REPLACE(date_sinistre, '-', '') LIKE ?", ['%' . $search . '%'])
                  ->orWhereRaw("REPLACE(date_reception, '-', '') LIKE ?", ['%' . $search . '%'])
                  ->orWhereRaw("REPLACE(DATE(created_at), '-', '') LIKE ?", ['%' . $search . '%'])
                  // Insured name
                  ->orWhereHas('insured', function ($q) use ($search) {
                      $q->whereRaw("REPLACE(REPLACE(REPLACE(name, '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $search . '%']);
                  });
        })
        ->latest()
        ->get();

    return view('dossiers.cloturer', compact('dossiers'));
}
/**
 * ============================================
 * ALTERNATIVE VERSION - Simpler (if REPLACE doesn't work well)
 * ============================================
 * 
 * This version keeps the original search logic but still normalizes input
 * and does a broader search by also searching the original (un-normalized) values
 */

public function archiveSearchAlt(Request $request)
{
    $this->authorize('viewAny', Dossier::class);

    $rawSearch = trim($request->search);
    
    // Remove dots, spaces, and dashes from search input
    $normalizedSearch = preg_replace('/[\.\s\-]+/', '', $rawSearch);

    // If empty or less than 3 characters, return latest 10
    if (empty($normalizedSearch) || strlen($normalizedSearch) < 3) {
        $dossiers = Dossier::with('insured')
            ->latest()
            ->take(10)
            ->get();
        
        $message = null;
        if (!empty($rawSearch) && strlen($normalizedSearch) < 3) {
            $message = 'Veuillez entrer au moins 3 caractères pour rechercher.';
        }
        
        return view('dossiers.cloturer', compact('dossiers', 'message'));
    }

    // Build search patterns - try both normalized and raw
    $patterns = [
        $normalizedSearch,                    // normalized: "ABC123"
        '%' . $normalizedSearch . '%',        // with wildcards
    ];
    
    // Also add versions with common separators re-inserted
    // e.g., if user types "12345A" it might be stored as "12345-A" or "123.45.A"

    $dossiers = Dossier::with('insured')
        ->where(function ($query) use ($normalizedSearch, $rawSearch) {
            // Search new_matricule
            $query->where(function($q) use ($normalizedSearch, $rawSearch) {
                $q->whereRaw("REPLACE(REPLACE(REPLACE(IFNULL(new_matricule,''), '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $normalizedSearch . '%'])
                  ->orWhere('new_matricule', 'like', '%' . $rawSearch . '%');
            })
            // Search matricule
            ->orWhere(function($q) use ($normalizedSearch, $rawSearch) {
                $q->whereRaw("REPLACE(REPLACE(REPLACE(IFNULL(matricule,''), '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $normalizedSearch . '%'])
                  ->orWhere('matricule', 'like', '%' . $rawSearch . '%');
            })
            // Search ref
            ->orWhere(function($q) use ($normalizedSearch, $rawSearch) {
                $q->whereRaw("REPLACE(REPLACE(REPLACE(IFNULL(ref,''), '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $normalizedSearch . '%'])
                  ->orWhere('ref', 'like', '%' . $rawSearch . '%');
            })
            // Search numero_sinistre
            ->orWhere(function($q) use ($normalizedSearch, $rawSearch) {
                $q->whereRaw("REPLACE(REPLACE(REPLACE(IFNULL(numero_sinistre,''), '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $normalizedSearch . '%'])
                  ->orWhere('numero_sinistre', 'like', '%' . $rawSearch . '%');
            })
            // Search insured name
            ->orWhereHas('insured', function ($q) use ($normalizedSearch, $rawSearch) {
                $q->whereRaw("REPLACE(REPLACE(REPLACE(IFNULL(name,''), '.', ''), ' ', ''), '-', '') LIKE ?", ['%' . $normalizedSearch . '%'])
                  ->orWhere('name', 'like', '%' . $rawSearch . '%');
            });
        })
        ->latest()
        ->get();

    return view('dossiers.cloturer', compact('dossiers'));
}
    public function historique($id)
    {
        $this->authorize('historique', Dossier::class);
        $dossier = Dossier::whereId($id)->with('transaction.document')->first();
        // $users = User::with('step')->whereHas('step', function ($query) use ($dossier) {
        //     $query->where('dossier_id', $dossier->id);
        // })->get();
        $historique = DB::select(DB::raw('SELECT users.name, steps.step, step_dossier.created_at FROM step_dossier
        INNER JOIN steps on step_dossier.step_id = steps.id
        INNER JOIN users on users.id = step_dossier.user_id
        WHERE step_dossier.dossier_id=' . $id));
        $users = User::where('role_id', '!=', 5)->get();



        // dd($dossier->dossierstatus);

        return view('dossiers.historique', compact('dossier', 'historique', 'users'));
    }


    public function affecter(Request $request)
    {
        $dossier = Dossier::whereId($request->dossier_id)->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $step = Step::whereId(17)->first();
        $user = User::whereId($request->user_id)->firstOrFail();
        $dossier->step()->attach($step, ['user_id' => $user->id]);
        return redirect()->route('Dossier.show', $dossier->id)->with('success', 'Dossier est Affecter a ' . $user->name);
    }


    public function historiquemail($id)
    {
        $this->authorize('historique', Dossier::class);
        $dossier = Dossier::whereId($id)->first();
        return view('dossiers.historique', compact('dossier', 'historique'));
    }

    public function open(Request $request, $id)
    {
        $this->authorize('open', Dossier::class);

        $dossier = Dossier::whereId($id)->firstOrFail();

        if ($dossier->dossier_status_id == 3 || $dossier->update == 1 || $dossier->dossier_status_id == 1) {
            $dossier->dossier_status_id = 2;
            $dossier->update = 0;
            $dossier->update();
            \App\Services\SidebarCache::clear();
            return redirect()->route('Dossier.show', $dossier->id)->with('success', 'Le Dossier est EnCours');
        } else {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Le Dossier est EnCours');
        }
    }

    public function reformeTechnique($id)
    {
        $dossier = Dossier::whereId($id)->with('document', 'document.typedocument')
            ->with('document', function ($query) {
                $query->whereHas('typedocument', function ($query) {
                    $query->where('is_pdf', 0)->where('id', '!=', 9)->latest();
                });
            })->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $chock = Document::where('dossier_id', $dossier->id)->where('type_document_id', 18)->first();

        if (!$chock) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Merci de selectionner les Point de chock  ');
        }
        $docs = Document::where('dossier_id', $id)->with('typedocument')->get();

        return view('dossiers.reformeTechnique', compact('dossier', 'docs'));
    }

    public function pdf($id)
    {

        $dossier = Dossier::whereId($id)->with('observation')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $ref = Document::where('dossier_id', $id)->where('type_document_id', 14)->first();
        if (!$ref) {
            return redirect()->route('dossier.technique', $dossier->id);
        }
        $doc = Document::where('dossier_id', $id)->where('type_document_id', 14)->latest()->first();
        return view('dossiers.pdf', compact('doc', 'dossier'));
    }

    public function avisdommage($id)
    {
        $dossier = Dossier::whereId($id)->with('rapport', 'document', 'company')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $today = Carbon::now();
        $pdf = Pdf::loadView('configuration.pdf.avis', compact('dossier', 'today'));

        return $pdf->stream('avis.pdf', compact('dossier', 'today'));
    }

    public function destroy($id)
    {
        $dossier = Dossier::whereId($id)->firstOrFail();
        $meetings = Meeting::where('dossier_id', $id)->where('meeting_status_id', 2)->get();
        foreach ($meetings as $meet) {
            $meet->meeting_status_id = 1;
            $meet->update();
        }
        $dossier->deleted_at = now();
        $dossier->update();
        \App\Services\SidebarCache::clear();
        return redirect()->route('home')->with('success', 'Dossier Supprimer Avec Succés');
    }

    public function demandesHistorique($id)
    {

        $demandes = Demande::where("dossier_id", $id)->with("user", "status")->get();
        return view('dossiers.dossierDemandes', compact('demandes', 'id'));
    }
}
