<?php

namespace App\Http\Controllers;

use App\Models\TypeRendezvous;
use Illuminate\Http\Request;

class TypeRendezvousController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $types = TypeRendezvous::all();
        return view('configuration.Types.rdv.index',compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.Types.rdv.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'type'=>'required|unique:type_rendezvouses,type'
        ]);
        
        if($request->direction){
            $d = 1;
        }
        else{
            $d = 0;
        }
        TypeRendezvous::create([
            'type'=>$request->type,
            'for_direction'=> $d
        ]);

        return redirect()->route('TypeRendezVous.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TypeRendezvous  $typeRendezvous
     * @return \Illuminate\Http\Response
     */
    public function show(TypeRendezvous $typeRendezvous)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TypeRendezvous  $typeRendezvous
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $type = TypeRendezvous::whereId($id)->firstOrFail();
        return view('configuration.Types.rdv.edit',compact('type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TypeRendezvous  $typeRendezvous
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'type'=>'required|unique:type_rendezvouses,type,'.$id,
            'for_direction'=>$request->direction
        ]);
        $type = TypeRendezvous::whereId($id)->firstOrFail();
        $type->type = $request->type;
        $type->update();
        return redirect()->route('TypeRendezVous.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TypeRendezvous  $typeRendezvous
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $type = TypeRendezvous::whereId($id)->firstOrFail();
        $type->delete();
        return redirect()->route('TypeRendezVous.index');

    }
}
