<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Meeting extends Model
{
    use HasFactory;

    protected $fillable = ['user_id','adress','meeting_status_id','dossier_id','start','garage_id','assure','date','type','lat','lng','date_fin'];

    public function user()
    {
        return $this->belongsTo(User::class)->withTrashed();
    }

    public function dossier()
    {
        return $this->belongsTo(Dossier::class)->withTrashed();
    }

    public function garage()
    {
        return $this->belongsTo(Garage::class)->withTrashed();
    }
    public function meetingstatus()
    {
        return $this->belongsTo(MeetingStatus::class ,'meeting_status_id');
    }
    // public function type()
    // {
    //     return $this->belongsTo(TypeDocument::class ,'type');
    // }

}
