<?php

use App\Models\NoteHonoraireStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('note_honoraires', function (Blueprint $table) {
            $table->id();
            $table->foreignId('type_expertise_id')->constrained()->onDelete(null);
            $table->foreignId('company_id')->constrained()->onDelete(null);
            $table->decimal('montant',10,2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('note_honoraires');
    }
};
