<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('marketvalues', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dossier_id')->constrained()->cascadeOnDelete();
            $table->date('date_mise_circulation');
            $table->integer('puissance_fiscale');
            $table->string('carburant');
            $table->string('categorie_pf');
            $table->decimal('prix_achat',10,2);
            $table->decimal('valeur_assure',10,2);
            $table->decimal('valeur_venale',10,2);
            $table->string('categorie_vehicule');
            $table->boolean('tax');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('marketvalues');
    }
};
