@extends('layouts.dashboard.app')


@section('style')
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css" />
    <style>
        #map { height: 60vh; width: 100%; border-radius: 8px; }
        .leaflet-control-geocoder-form input {
            height: 44px;
            font-size: 15px;
        }
    </style>
@endsection



@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Libelle</th>
                                        <th>Email</th>
                                        <th>Adresse</th>
                                        <th>Ville</th>
                                        <th>Agreer</th>
                                        <th>Site</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $garage->id }}</td>
                                        <td>{{ $garage->libelle ?? null }}</td>
                                        <td>{{ $garage->email ?? null }}</td>
                                        <td>{{ $garage->adress ?? null }}</td>
                                        <td>{{ $garage->city->city ?? null }}</td>
                                        <td>
                                            {{ $garage->tel ?? null }}
                                        </td>
                                        <td> <a class="btn btn-sm btn-dark rounded-pill" target="_blank"
                                                href="{{ $garage->url }}">Site</a>
                                        </td>
                                        @can('update', $garage)
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Garage.edit', [$garage->id]) }}"><i
                                                        class="uil uil-pen fs-5">
                                                    </i></a>
                                            </td>
                                        @endcan
                                        @can('delete', $garage)
                                            <td>
                                                <form action="{{ route('Garage.destroy', [$garage->id]) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit"><i
                                                            class="uil uil-trash fs-5"></i></button>
                                                </form>
                                            </td>
                                        @endcan

                                    </tr>
                                </tbody>
                                <input type="hidden" value="{{ $garage->lat }}" name="lat" id="lat">
                                <input type="hidden" value="{{ $garage->lng }}" name="lng" id="lng">

                            </table>
                        </div>
                        <form action="{{ route('GarageCompany.asign', $garage->id) }}" method="POST" class="mb-4">
                            @csrf
                            <div class="col-md-12 mr-2 mb-2 mt-1">
                                <h4>Agréer par :</h4>
                                <hr>
                                @forelse ($companies as $company)
                                    @if ($garage->hascompany($company->company))
                                        <div class="form-check form-check-inline form-checkbox-primary ">
                                            <input type="checkbox" checked class="form-check-input"
                                                value="{{ $company->id }}" name="company[]"
                                                id="customSwitch3{{ $company->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $company->id }}">{{ $company->company }}</label>
                                        </div>
                                    @else
                                        <div class="form-check form-check-inline form-checkbox-dark ">
                                            <input type="checkbox" class="form-check-input" value="{{ $company->id }}"
                                                name="company[]" id="customSwitch3{{ $company->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $company->id }}">{{ $company->company }}</label>
                                        </div>
                                    @endif

                                @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse


                            </div>
                            @can('update', $garage)
                                <button style="float:right" type="submit" class="btn btn-outline-primary mb-">Asigner
                                    Companie</button>
                            @endcan
                        </form>
                        <form action="{{ route('GarageService.asign', $garage->id) }}" method="POST" class="mb-4">
                            @csrf
                            <div class="col-md-12 mr-2 mb-2 mt-1">
                                <h4>Assigner un Service</h4>
                                <hr>
                                @forelse ($services as $service)
                                    @if ($garage->hasService($service->service))
                                        <div class="form-check form-check-inline form-checkbox-success ">
                                            <input type="checkbox" checked class="form-check-input"
                                                value="{{ $service->id }}" name="service[]"
                                                id="customSwitch3{{ $service->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $service->id }}">{{ $service->service }}</label>
                                        </div>
                                    @else
                                        <div class="form-check form-check-inline form-checkbox-warning ">
                                            <input type="checkbox" class="form-check-input" value="{{ $service->id }}"
                                                name="service[]" id="customSwitch3{{ $service->id }}">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3{{ $service->id }}">{{ $service->service }}</label>
                                        </div>
                                    @endif

                                @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse


                            </div>
                            @can('update', $garage)
                                <button style="float:right" type="submit" class="btn btn-outline-success mb-">Asigner
                                    Service</button>
                            @endcan
                        </form>
                        <div class="col-md-12 mt-3">
                            <h3>Localisation :</h3>
                            <hr>
                            <div id="map" class="gmaps" style="height: 60vh">
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Get current lat/lng from input fields (with fallback to Casablanca)
            let lat = parseFloat(document.getElementById('lat').value) || 33.5731;
            let lng = parseFloat(document.getElementById('lng').value) || -7.5898;

            // Initialize map
            const map = L.map('map').setView([lat, lng], 15);

            // OpenStreetMap tiles - 100% free
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; OpenStreetMap contributors'
            }).addTo(map);

            // Create draggable marker
            const marker = L.marker([lat, lng], { draggable: true }).addTo(map);

            // Update input fields when marker is dragged
            marker.on('dragend', function (e) {
                const position = marker.getLatLng();
                document.getElementById('lat').value = position.lat.toFixed(8);
                document.getElementById('lng').value = position.lng.toFixed(8);
            });

            // Click anywhere on map → move marker
            map.on('click', function (e) {
                marker.setLatLng(e.latlng);
                document.getElementById('lat').value = e.latlng.lat.toFixed(8);
                document.getElementById('lng').value = e.latlng.lng.toFixed(8);
            });

            // Add search box (free, fast, supports French/Arabic/Moroccan cities)
            L.Control.geocoder({
                defaultMarkGeocode: false,
                placeholder: "Rechercher une adresse au Maroc...",
                errorMessage: "Aucun résultat",
                collapsed: false,
                geocoder: L.Control.Geocoder.photon({  // Photon = faster & better than Nominatim
                    lang: 'fr'
                })
            })
            .on('markgeocode', function (e) {
                const latlng = e.geocode.center;
                map.setView(latlng, 16);
                marker.setLatLng(latlng);

                document.getElementById('lat').value = latlng.lat.toFixed(8);
                document.getElementById('lng').value = latlng.lng.toFixed(8);
            })
            .addTo(map);

            // Optional: If fields are empty, center on Morocco
            if (!document.getElementById('lat').value || !document.getElementById('lng').value) {
                map.setView([31.7917, -7.0926], 6);
            }
        });
    </script>
@endsection