@extends('layouts.config_dashboard.app')

@section('content')
<div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('Piece.create') }}"
                                        class="btn btn-success rounded-pill"> Créer</a>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Type Piece</th>
                                        <th>Restaurer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($typepieces as $piece)
                                        <tr>
                                            <td>{{ $piece->id }}</td>
                                            <td>{{ $piece->type }}</td>
                                            <td>
                                                <form action="{{ route('PieceType.restore', [$piece->id]) }}"
                                                    method="post">
                                                    @csrf
                                                    <button class="btn btn-sm btn-warning rounded-pill" type="submit">
                                                        Restaurer
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
