@extends('layouts.dashboard.app')


@section('content')
    <div class="row">
        <!-- Right Sidebar -->
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <!-- Left sidebar -->
                    <div class="col-12">
                        <div class="page-aside-right">

                            <div class="mt-3">

                                <div class="d-flex mb-3 mt-1">
                                    <img class="d-flex me-2 rounded-circle"
                                        src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSuQVDZzmYwKrMZsWyCUCfRqP-QK7vHJqTl0gCCqkuu0g&s"
                                        alt="placeholder image" height="32">
                                    <div class="w-100 overflow-hidden">
                                        <small class="float-end">{{ $message->date }}</small>
                                        <h6 class="m-0 font-14">{{ $message->from[0]->personal }}</h6>
                                        <small class="text-muted">{{ $message->from[0]->mail }}</small>
                                    </div>
                                </div>

                                {{ $message->subject }}
                                <hr />
                                {{ $message->content }}
                                <hr>


                                <h5 class="mb-3">Attachments</h5>
                                <div class="row">
                                    @foreach ($attachments as $attachment)
                                        <div class="col-xl-4">
                                            <div class="card mb-1 shadow-none border">
                                                <div class="p-2">
                                                    <div class="row align-items-center">
                                                        <div class="col-auto">
                                                            <div class="avatar-sm">
                                                                <span
                                                                    class="avatar-title bg-primary-lighten text-primary rounded">
                                                                    {{ $attachment->getExtension() }}
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <div class="col ps-0">
                                                            <a href="javascript:void(0);"
                                                                class="text-muted fw-bold ml-1">{{ $attachment->name }}</a>
                                                            <p class="mb-0">2.3 MB</p>
                                                        </div>
                                                        <div class="col-auto">
                                                            <!-- Button -->
                                                            <p>{{ $attachment->getName() }}</p>
                                                            <a href="{{ asset('attachments/' . $attachment->getname()) }}"
                                                                target="_blank" class="btn btn-link btn-lg text-muted">
                                                                <i class="dripicons-download"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    @endforeach

                                </div>
                                <!-- end row-->
                            </div>
                            <!-- end .mt-4 -->
                        </div>
                    </div>
                    <!-- end inbox-rightbar-->
                </div>

                <div class="clearfix"></div>
            </div> <!-- end card-box -->

        </div> <!-- end Col -->
    </div><!-- End row -->
@endsection
