<div class="leftside-menu menuitem-active">

    <!-- Enhanced Sidebar Styles -->
    <style>
        /* ============================================
           SIDEBAR REDESIGN - Modern Style
           Matching config_dashboard sidebar design
           ============================================ */
        
        .leftside-menu {
            background: linear-gradient(180deg, #1a1a2e 0%, #16213e 100%) !important;
            display: flex;
            flex-direction: column;
            height: 100vh;
            width: 260px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 10;
            padding-top: 0 !important;
        }

        /* Logo - Sticky at top, matches topbar height (70px) */
        .leftside-menu .logo {
            position: sticky !important;
            top: 0;
            z-index: 100;
            height: 70px;
            min-height: 70px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: transparent !important;
            border-bottom: 1px solid rgba(255, 255, 255, 0.08);
            padding: 0 !important;
            margin: 0 !important;
            width: 100%;
            line-height: normal !important;
        }

        /* Override dark theme logo background */
        body[data-leftbar-theme="dark"] .leftside-menu .logo {
            background: transparent !important;
        }

        .leftside-menu .logo img {
            max-height: 45px;
            width: auto;
            /* Change white logo to green (#10b981) */
            filter: brightness(0) saturate(100%) invert(52%) sepia(87%) saturate(394%) hue-rotate(93deg) brightness(95%) contrast(87%);
        }

        .leftside-menu .logo-sm img {
            max-height: 40px;
        }

        /* Scrollable content area */
        #leftside-menu-container {
            flex: 1;
            overflow-y: auto;
            overflow-x: hidden;
            padding-top: 10px;
        }

        /* Custom scrollbar */
        #leftside-menu-container::-webkit-scrollbar {
            width: 4px;
        }

        #leftside-menu-container::-webkit-scrollbar-track {
            background: transparent;
        }

        #leftside-menu-container::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 4px;
        }

        #leftside-menu-container::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        /* Side Nav Reset */
        .side-nav {
            padding: 0 8px;
            list-style: none;
            margin: 0;
        }

        .side-nav-item {
            margin: 2px 0;
        }

        /* Navigation Title */
        .side-nav-title {
            font-size: 10px !important;
            text-transform: uppercase !important;
            letter-spacing: 1.5px !important;
            padding: 20px 15px 10px !important;
            color: rgba(255, 255, 255, 0.4) !important;
            font-weight: 700 !important;
            margin: 0;
        }

        /* Main Nav Links */
        .side-nav-link {
            display: flex !important;
            align-items: center;
            padding: 11px 15px !important;
            border-radius: 8px;
            transition: all 0.2s ease;
            cursor: pointer;
            color: rgba(255, 255, 255, 0.7) !important;
            text-decoration: none !important;
            font-size: 13.5px;
            position: relative;
        }

        .side-nav-link:hover {
            background: rgba(255, 255, 255, 0.08);
            color: #fff !important;
        }

        .side-nav-link.active,
        .side-nav-item.menuitem-active > .side-nav-link {
            background: rgba(16, 185, 129, 0.15);
            color: #10b981 !important;
        }

        .side-nav-link i {
            width: 22px;
            font-size: 18px;
            margin-right: 12px;
            text-align: center;
            flex-shrink: 0;
        }

        .side-nav-link span:not(.menu-arrow) {
            flex: 1;
        }

        /* Menu Arrow */
        .side-nav-link .menu-arrow {
            position: absolute;
            right: 15px;
            transition: transform 0.2s ease;
            font-size: 14px;
            opacity: 0.5;
        }

        .side-nav-link[aria-expanded="false"] .menu-arrow {
            transform: rotate(90deg);
        }

        /* Second Level Menu */
        .side-nav-second-level {
            list-style: none;
            padding: 5px 0 5px 0;
            margin: 0;
        }

        .side-nav-second-level li {
            margin: 2px 0;
        }

        .side-nav-second-level li a {
            display: block;
            padding: 8px 15px 8px 49px;
            color: rgba(255, 255, 255, 0.6) !important;
            font-size: 13px;
            border-radius: 6px;
            margin: 0 8px;
            transition: all 0.2s ease;
            text-decoration: none !important;
        }

        .side-nav-second-level li a:hover {
            color: #fff !important;
            background: rgba(255, 255, 255, 0.05);
        }

        .side-nav-second-level li.active a,
        .side-nav-second-level li a.active {
            color: #10b981 !important;
            background: rgba(16, 185, 129, 0.1);
        }

        /* Collapse styling */
        .collapse {
            background: rgba(0, 0, 0, 0.15);
            border-radius: 8px;
            margin: 5px 0;
        }

        /* Badge styling */
        .side-nav-link .badge {
            margin-left: auto;
            font-size: 10px;
            padding: 4px 8px;
            border-radius: 10px;
        }

        /* Simplebar overrides */
        .simplebar-content-wrapper {
            overflow-x: hidden !important;
        }

        .simplebar-track.simplebar-vertical {
            width: 4px !important;
            right: 2px;
        }

        .simplebar-scrollbar::before {
            background: rgba(255, 255, 255, 0.2) !important;
            border-radius: 4px !important;
        }

        /* ============================================
           RESPONSIVE
           ============================================ */
        @media (max-width: 767.98px) {
            .leftside-menu {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                z-index: 1060 !important; /* Higher than any overlay */
            }
            
            body.sidebar-open .leftside-menu {
                transform: translateX(0);
            }
            
            /* Mobile overlay - must be BEHIND sidebar */
            body.sidebar-open::before {
                content: '';
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 1050; /* Below sidebar (1060) */
            }
            
            /* Ensure all sidebar elements are fully interactive */
            .leftside-menu,
            .leftside-menu * {
                pointer-events: auto !important;
            }
            
            /* Fix for collapse/dropdown inside sidebar */
            .leftside-menu .collapse,
            .leftside-menu .collapsing,
            .leftside-menu .nav-dropdown-content {
                position: relative;
                z-index: 1;
            }
            
            .leftside-menu .side-nav-second-level li a,
            .leftside-menu .nav-dropdown-content .side-nav-link {
                pointer-events: auto !important;
                cursor: pointer !important;
                position: relative;
                z-index: 1;
            }
            
            /* Make sure toggle buttons work */
            .leftside-menu .nav-dropdown-toggle,
            .leftside-menu [data-bs-toggle="collapse"] {
                pointer-events: auto !important;
                cursor: pointer !important;
            }
        }
    </style>

    <!-- LOGO -->
    <a href="{{ route('home') }}" class="logo text-center logo-light">
        <span class="logo-lg">
            <img src="{{ asset('img/logo_white.png') }}" alt="" height="50">
        </span>
        <span class="logo-sm">
            <img src="{{ asset('img/icon_white.png') }}" alt="" height="60">
        </span>
    </a>

    <div class="h-100 show" id="leftside-menu-container" data-simplebar="init">
        <div class="simplebar-wrapper" style="margin: 0px;">
            <div class="simplebar-height-auto-observer-wrapper">
                <div class="simplebar-height-auto-observer"></div>
            </div>
            <div class="simplebar-mask">
                <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                    <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content"
                        style="height: 100%; overflow: hidden scroll;">
                        <div class="simplebar-content" style="padding: 0px;">

                            <!--- Sidemenu -->
                            <ul class="side-nav">

                                <li class="side-nav-title side-nav-item">Navigation</li>

                                <!-- Dashboard -->
                                <li class="side-nav-item">
                                    <a href="{{ route('home') }}" class="side-nav-link">
                                        <i class="uil-home-alt"></i>
                                        <span> Dashboard </span>
                                    </a>
                                </li>

                                <!-- Inbox -->
                                @can('inbox', App\Models\Email::class)
                                    <li class="side-nav-item">
                                        <a href="{{ route('Email.inbox') }}" class="side-nav-link">
                                            <i class="uil-envelope"></i>
                                            <span> Inbox </span>
                                        </a>
                                    </li>
                                @endcan

                                <!-- Utilisateurs -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarUsers"
                                        aria-controls="sidebarUsers" class="side-nav-link">
                                        <i class="uil uil-users-alt"></i>
                                        <span> Utilisateurs </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarUsers">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\User::class)
                                                <li>
                                                    <a href="{{ route('user.index') }}">Liste</a>
                                                </li>
                                            @endcan
                                            @can('create', App\Models\User::class)
                                                <li>
                                                    <a href="{{ route('user.create') }}">Créer</a>
                                                </li>
                                            @endcan
                                            @can('restore', App\Models\User::class)
                                                <li>
                                                    <a href="{{ route('user.trash') }}">Restaurer</a>
                                                </li>
                                            @endcan
                                            @can('viewAny', App\Models\Role::class)
                                                <li>
                                                    <a href="{{ route('Role.index') }}">Gestion des Role et Permission</a>
                                                </li>
                                            @endcan
                                            @can('update', App\Models\User::class)
                                                <li>
                                                    <a href="{{ route('Seuil.index') }}">Seuil</a>
                                                </li>
                                            @endcan
                                            <li>
                                                <a href="{{ route('Location.index') }}">Location</a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>

                                <!-- Dossier -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarinster"
                                        aria-controls="sidebarinster" class="side-nav-link">
                                        <i class="uil uil-shield-check"></i>
                                        <span> Dossier </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarinster">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\Dossier::class)
                                                <li>
                                                    <a href="{{ route('Dossier.index') }}">Liste</a>
                                                </li>
                                            @endcan
                                            @can('viewAny', App\Models\Meeting::class)
                                                <li>
                                                    <a href="{{ route('Meeting.historique') }}">Meeting</a>
                                                </li>
                                            @endcan
                                            @can('create', App\Models\Dossier::class)
                                                <li>
                                                    <a href="{{ route('Dossier.create') }}">Créer</a>
                                                </li>
                                            @endcan
                                            @can('viewAny', App\Models\Dossier::class)
                                                <li>
                                                    <a href="{{ route('Dossier.archive') }}">Archive</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Tickets -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sideba"
                                        aria-controls="sideba" class="side-nav-link">
                                        <i class="uil uil-shield"></i>
                                        <span> Tickets </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sideba">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\Ticket::class)
                                                <li>
                                                    <a href="{{ route('Ticket.list') }}">Liste</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Garage -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarGarage"
                                        aria-controls="sidebarGarage" class="side-nav-link">
                                        <i class="uil uil-tachometer-fast"></i>
                                        <span> Garage </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarGarage">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\Garage::class)
                                                <li>
                                                    <a href="{{ route('Garage.index') }}">Liste</a>
                                                </li>
                                            @endcan
                                            @can('create', App\Models\Garage::class)
                                                <li>
                                                    <a href="{{ route('Garage.create') }}">Créer</a>
                                                </li>
                                            @endcan
                                            @can('restore', App\Models\Garage::class)
                                                <li>
                                                    <a href="{{ route('Garage.deleted') }}">Restaurer</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Piéce -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarPiece"
                                        aria-controls="sidebarPiece" class="side-nav-link">
                                        <i class="uil uil-screw"></i>
                                        <span> Piéce </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarPiece">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\Piece::class)
                                                <li>
                                                    <a href="{{ route('Piece.index') }}">Liste</a>
                                                </li>
                                            @endcan
                                            @can('create', App\Models\Piece::class)
                                                <li>
                                                    <a href="{{ route('Piece.create') }}">Créer</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Assurances -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarCompanies"
                                        aria-controls="sidebarCompanies" class="side-nav-link">
                                        <i class="uil uil-clapper-board"></i>
                                        <span> Assurances </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarCompanies">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\Company::class)
                                                <li>
                                                    <a href="{{ route('Company.index') }}">Liste</a>
                                                </li>
                                            @endcan
                                            @can('create', App\Models\Company::class)
                                                <li>
                                                    <a href="{{ route('Company.create') }}">Créer</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Intermidiaire -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarinsterm"
                                        aria-controls="sidebarinsterm" class="side-nav-link">
                                        <i class="uil uil-compact-disc"></i>
                                        <span> Intermidiaire </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarinsterm">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\Intermidiaire::class)
                                                <li>
                                                    <a href="{{ route('Intermidiaire.index') }}">Liste</a>
                                                </li>
                                            @endcan
                                            @can('create', App\Models\Intermidiaire::class)
                                                <li>
                                                    <a href="{{ route('Intermidiaire.create') }}">Créer</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Vehicule -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarMarque"
                                        aria-controls="sidebarMarque" class="side-nav-link">
                                        <i class="uil uil-car-sideview"></i>
                                        <span> Vehicule </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarMarque">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\TypeVehicule::class)
                                                <li>
                                                    <a href="{{ route('TypeVehicule.index') }}">Type Vehicule</a>
                                                </li>
                                            @endcan
                                            @can('viewAny', App\Models\Brand::class)
                                                <li>
                                                    <a href="{{ route('Brand.index') }}">Marque</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Rendez Vous -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarrdv"
                                        aria-controls="sidebarrdv" class="side-nav-link">
                                        <i class="uil-calender"></i>
                                        <span> Rendez Vous </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarrdv">
                                        <ul class="side-nav-second-level">
                                            <li>
                                                <a href="{{ route('RendezVous.index') }}">Liste</a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>

                                <!-- Demande -->
                                @can('viewAny', App\Models\Demande::class)
                                    <li class="side-nav-item">
                                        <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarres"
                                            aria-controls="sidebarres" class="side-nav-link">
                                            <i class="uil uil-notes"></i>
                                            <span> Demande </span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <div class="collapse" id="sidebarres">
                                            <ul class="side-nav-second-level">
                                                <li>
                                                    <a href="{{ route('Demande.index') }}">Liste</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                @endcan

                                <!-- Middleware (Admin Only) -->
                                @if (Auth::user()->role_id == 4)
                                    <li class="side-nav-item">
                                        <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarmid"
                                            aria-controls="sidebarmid" class="side-nav-link">
                                            <i class="uil uil-play"></i>
                                            <span> Middleware </span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <div class="collapse" id="sidebarmid">
                                            <ul class="side-nav-second-level">
                                                <li>
                                                    <a href="{{ route('IP.index') }}">Ip</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('Device.index') }}">Telephone</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                @endif

                                <!-- Configurer -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarSMS"
                                        aria-controls="sidebarSMS" class="side-nav-link">
                                        <i class="uil uil-bright"></i>
                                        <span> Configurer </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarSMS">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\Sms::class)
                                                <li>
                                                    <a href="{{ route('SMS.index') }}">SMS</a>
                                                </li>
                                            @endcan
                                            @can('viewAny', App\Models\Email::class)
                                                <li>
                                                    <a href="{{ route('Email.index') }}">Email</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Statistique (Admin Only) -->
                                @if (Auth::user()->role_id == 4)
                                    <li class="side-nav-item">
                                        <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarSS"
                                            aria-controls="sidebarSS" class="side-nav-link">
                                            <i class="uil uil-chart-line"></i>
                                            <span> Statistique </span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <div class="collapse" id="sidebarSS">
                                            <ul class="side-nav-second-level">
                                                <li>
                                                    <a href="{{ route('Chart.all') }}">Tout</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('Chart.index') }}">Dossier</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                @endif

                                <!-- Ville -->
                                <li class="side-nav-item">
                                    <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarVille"
                                        aria-controls="sidebarVille" class="side-nav-link">
                                        <i class="uil uil-archway"></i>
                                        <span> Ville </span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <div class="collapse" id="sidebarVille">
                                        <ul class="side-nav-second-level">
                                            @can('viewAny', App\Models\City::class)
                                                <li>
                                                    <a href="{{ route('City.index') }}">Liste</a>
                                                </li>
                                            @endcan
                                            @can('create', App\Models\City::class)
                                                <li>
                                                    <a href="{{ route('City.create') }}">Créer</a>
                                                </li>
                                            @endcan
                                            @can('restore', App\Models\City::class)
                                                <li>
                                                    <a href="{{ route('City.deleted') }}">Restaurer</a>
                                                </li>
                                            @endcan
                                        </ul>
                                    </div>
                                </li>

                                <!-- Type (Admin Only) -->
                                @if (Auth::user()->role_id == 4)
                                    <li class="side-nav-item">
                                        <a data-bs-toggle="collapse" aria-expanded="false" href="#sidebarTypes"
                                            aria-controls="sidebarTypes" class="side-nav-link">
                                            <i class="uil uil-list-ul"></i>
                                            <span> Type </span>
                                            <span class="menu-arrow"></span>
                                        </a>
                                        <div class="collapse" id="sidebarTypes">
                                            <ul class="side-nav-second-level">
                                                <li>
                                                    <a href="{{ route('TypeExpert.index') }}">Type Expertise</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('Mode.index') }}">Mode</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('Expert.index') }}">Expert</a>
                                                </li>
                                                @can('viewAny', App\Models\Guarantee::class)
                                                    <li>
                                                        <a href="{{ route('Guarantee.index') }}">Garantie</a>
                                                    </li>
                                                @endcan
                                                <li>
                                                    <a href="{{ route('TypeReparation.index') }}">Type Reparation</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('PieceType.index') }}">Type Piece</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('Operation.index') }}">Opération Piece</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('TypeDocument.index') }}">Type Document</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('GarageService.index') }}">Garage Service</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('Currency.index') }}">Devises</a>
                                                </li>
                                                <li>
                                                    <a href="{{ route('TypeRendezVous.index') }}">Type Rendez Vous</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                @endif

                            </ul>
                            <!-- End Sidebar -->

                            <div class="clearfix"></div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="simplebar-placeholder" style="width: auto; height: 1518px;"></div>
        </div>
        <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
            <div class="simplebar-scrollbar" style="width: 0px; display: none;"></div>
        </div>
        <div class="simplebar-track simplebar-vertical" style="visibility: visible;">
            <div class="simplebar-scrollbar"
                style="height: 114px; transform: translate3d(0px, 0px, 0px); display: block;"></div>
        </div>
    </div>
    <!-- Sidebar -left -->

</div>