@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="d-flex ">
                            <div class="col-md-6">
                                <a style="float: left" href="{{ route('Dossier.show', $id) }}" class="btn btn-dark">Dossier</a>

                            </div>
                            <div class="col-md-6">
                                @can('create', App\Models\Rapport::class)
                                    <a style="float: right" href="{{ route('Rapport.create', ['id' => $id]) }}"
                                        class="btn btn-outline-primary">Créer Un
                                        Rapport</a>
                                @endcan

                            </div>
                        </div>
                    </div>

                </div>
                <div class="table-responsive">
                    <table class="table table-stripped" id="myTable">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 20px;">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="customCheck1">
                                        <label class="form-check-label" for="customCheck1">&nbsp;</label>
                                    </div>
                                </th>
                                <th>Id</th>
                                <th>Dossier</th>
                                <th>Assurance</th>
                                <th>Matricule</th>
                                <th>Status</th>
                                @can('view', App\Models\Rapport::class)
                                    <th style="width: 125px;">Afficher</th>
                                @endcan
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($rapports as $rapport)
                                <tr>
                                    <td>
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" id="customCheck2">
                                            <label class="form-check-label" for="customCheck2">&nbsp;</label>
                                        </div>
                                    </td>
                                    <td style="color: black; font-weight:bold">
                                        {{ $rapport->id ?? null }}
                                    </td>
                                    <td>
                                        {{ $rapport->dossier->ref ?? null }}
                                    </td>
                                    <td>
                                        {{ $rapport->dossier->company->company ?? null }}
                                    </td>
                                    <td>
                                        {{ $rapport->dossier->matricule ?? null }}
                                    </td>
                                    <td>
                                        <span
                                            class="badge bg-{{ $rapport->status->color ?? null }} fs-5">{{ $rapport->status->status ?? null }}</span>
                                    </td>
                                    @can('view', App\Models\Rapport::class)
                                        <td style="width: 125px;">
                                            <a href="{{ route('Rapport.show', $rapport->id) }}"><i class="mdi mdi-eye"></i></a>
                                        </td>
                                    @endcan

                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- end card-body-->
@endsection
