@extends('layouts.dashboard.app')
@section('style')
    <style>
        .img-fluid {
            height: 260px;
            width: auto;
            object-fit: contain;
            padding: 10px
                /* object-position: center; */
        }
    </style>
@endsection
@section('content')
    <form action="{{ route('pdf.technique', $dossier->id) }}" method="POST">
        @csrf
        <div class="row g-4 mt-2">
            <h4>Selectionner Une photo de Voiture :</h4>
            @foreach ($docs as $doc)
                <div class="col-md-3">
                    <span> {{ $doc->typedocument->type ?? null }}</span>
                    <div class="card h-100">
                        <input class="image-checkbox" data-image-url="{{ $doc->id }}" type="checkbox" name=""
                            id="">
                        <img src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                            class="card-img-top img-fluid">
                        <input type="hidden" name="img[]"
                            value="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                            id="{{ $doc->id }}">
                        <div class="card-body">
                            <textarea name="body[]" class="form-control" id="" cols="30" rows=5></textarea>
                        </div>
                    </div>
                </div>
            @endforeach
            <input type="hidden" name="voiture" id="voiture">

            <div class="col-12">
                <div class="col-6 mt-1">
                    <label for="">Conclusion</label>
                    <textarea required class="form-control" name="conclusion" id="" cols="30" rows="10"></textarea>
                </div>
                <div class="col-6 mt-3">
                    <label for="">Total des Dommages</label>
                    <input required class="form-control" min="0" type="number" value="0" name="dommage">
                </div>
            </div>
            <div class="col-6">
                <input type="submit" class="btn btn-success" value="Enregistrer">
            </div>
    </form>
@endsection
@section('script')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const checkboxes = document.querySelectorAll('.image-checkbox');

            checkboxes.forEach(function(checkbox) {
                checkbox.addEventListener('change', function() {
                    checkboxes.forEach(function(otherCheckbox) {
                        if (otherCheckbox !== checkbox) {
                            otherCheckbox.checked = false;
                        }
                    });

                    if (checkbox.checked) {
                        const imageUrl = checkbox.getAttribute('data-image-url');
                        document.getElementById('voiture').value = imageUrl;

                        console.log('Image URL:', imageUrl); // Replace with your desired action
                    }
                });
            });
        });
    </script>
@endsection
