<?php

namespace App\Http\Controllers;

use App\Models\Dossier;
use App\Models\Observation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ObservationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'observation' => 'required',
        ]);
        $dossier = Dossier::whereId($request->dossier_id)->first();
        if ($dossier->dossier_status_id != 3) {
            if ($request->has('rapport_id')) {
                Observation::create([
                    'observation' => $request->observation,
                    'dossier_id' => $request->dossier_id,
                    'user_id' => Auth::user()->id,
                    'for_rapport' => true
                ]);
            } else {
                Observation::create([
                    'observation' => $request->observation,
                    'dossier_id' => $request->dossier_id,
                    'user_id' => Auth::user()->id,
                    'for_rapport' => false

                ]);
            }
        }
        else{
            return redirect()->back()->with('error',"dossier est cloturer");
        }


        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Http\Response
     */
    public function show(Observation $observation)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Http\Response
     */
    public function edit(Observation $observation)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Observation $observation)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Http\Response
     */
    public function destroy(Observation $observation)
    {
        //
    }
}
