<?php

namespace App\Observers;

use App\Models\Dossier;
use App\Models\Notification;
use App\Models\Step;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class DossierObserver
{
    /**
     * Handle the Dossier "created" event.
     *
     * @param  \App\Models\Dossier  $dossier
     * @return void
     */
    public function created(Dossier $dossier)
    {
        $token = env('SMS_API_KEY');

        $body = "A Creer un nouveau Dossier Ref :".$dossier->id.'-'.date('m').'-'.date('Y');
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);
        if ($dossier->typeexpertise) {
            if ($dossier->typeexpertise->id) {

                // if ($dossier->typeexpertise->id !== 3  && $dossier->typeexpertise->id !== 8 && $dossier->typeexpertise->id !== 9) {
                //     if ($dossier->insured->telephone) {
                //         $step = Step::whereId(1)->with('sms')->first();

                //         $response = Http::withHeaders([
                //             'Authorization' => $token,
                //         ])->post('https://api.releans.com/v2/message', [
                //             "sender" => "ISTECH",
                //             "mobile" => $dossier->insured->telephone,
                //             "content" => "ff"
                //         ]);
                //     }
                // }
            }
        }
    }

    /**
     * Handle the Dossier "updated" event.
     *
     * @param  \App\Models\Dossier  $dossier
     * @return void
     */
    public function updated(Dossier $dossier)
    {
        // $body = "A Modifier Dossier Ref :";
        // Notification::create([
        //     'user_id' => Auth::user()->id,
        //     'dossier_id' => $dossier->id,
        //     'body' => $body
        // ]);
        // $step = Step::whereId(1)->with('sms')->first();
        // $token = env('SMS_API_KEY');

        // $response = Http::withHeaders([
        //     'Authorization' => $token,
        // ])->post('https://api.releans.com/v2/message', [
        //     "sender"=>"ISTECH",
        //     "mobile"=>$dossier->insured->telephone,
        //     "content"=>'l'
        // ]);
        // dd($step);


    }

    /**
     * Handle the Dossier "deleted" event.
     *
     * @param  \App\Models\Dossier  $dossier
     * @return void
     */
    public function deleted(Dossier $dossier)
    {
        //
    }

    /**
     * Handle the Dossier "restored" event.
     *
     * @param  \App\Models\Dossier  $dossier
     * @return void
     */
    public function restored(Dossier $dossier)
    {
        //
    }

    /**
     * Handle the Dossier "force deleted" event.
     *
     * @param  \App\Models\Dossier  $dossier
     * @return void
     */
    public function forceDeleted(Dossier $dossier)
    {
        //
    }
}
