<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\Dashboard;
use App\Models\Demande;
use App\Models\Dossier;
use App\Models\Rapport;
use App\Models\Rendezvous;
use App\Models\Seuil;
use App\Models\Ticket;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{

    public function front()
    {
        if (Auth::user()->role_id != 6) {
            $dossiers = Dossier::user()
                ->where('dossier_status_id', 2)
                ->where('update', 0)
                ->with('typeexpertise', 'onefacture', 'onedevis', 'currentStep', 'insured', 'status')
                ->latest()
                ->take(100)
                ->get();
        } else {

            $user = User::whereId(Auth::user()->id)->with('manygarage')->first();
            $dossiers = Dossier::whereHas('garage', function ($query) use ($user) {
                $query->whereIn('garage_id', $user->manygarage->pluck('id'));
            })
                ->where('dossier_status_id', 2)
                ->where('update', 0)
                ->with('typeexpertise', 'currentStep', 'insured', 'status')
                ->latest()
                ->take(100)

                ->get();
        }

        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {
                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step  && $stepdate) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }



        $tribunale = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->where('type_expertise_id', 9)->count();
        $dossiersfacture = Dossier::whereNull('facture')->where('dossier_status_id', 2)->where('update', 1)->count();

        if (Auth::user()->role_id == 2) {
            $rapide = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->where('type_expertise_id', 16)->whereIn('step_id', ['4,9'])->count();
        } else {
            $rapide = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->where('type_expertise_id', 16)->count();
        }
        $douteux = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->where('sinistre_douteux', 1)->count();
        $demandes = Demande::where('status_rendezvous_id', 2)->count();
        $rdv = Rendezvous::where('status_rendezvous_id', 2)->count();

        $docasigner = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereHas('document', function ($query) {
            $query->where('type_document_id', 21)->where('signer', 0)->where('rejected', 0);
        })->count();
        $docsigner = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereDoesntHave('onerapport', function ($query) {
            $query->whereIn('rapport_status_id', [2, 3]);
        })->whereHas('document', function ($query) {
            $query->where('type_document_id', 21)->where('signer', 1)->where('rejected', 0);
        })->count();
        $fasigner = Dossier::where('dossier_status_id', 2)->where('update', 0)->whereHas('document', function ($query) {
            $query->where('type_document_id', 16)->where('signer', 0);
        })->count();

        $aexpcount =  Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereDoesntHave('devis')
            ->whereDoesntHave('document', function ($query) {
                $query->where('type_document_id', 5);
            })->count();
        $enexp =  Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereHas('meeting', function ($query) {
            $query->where('meeting_status_id', 2);
        })->count();

        $areport =  Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereHas('onemeeting', function ($query) {
            $query->where('meeting_status_id', 1);
        })->whereDoesntHave('rapport')->count();


        // $factureatraiter = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
        //     ->where('step_id', 9)->count();

        $attdevis = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereDoesntHave('devis')->count();



        $attexpap = Dossier::user()->where('dossier_status_id', 2)
            ->where('update', 0)->where('type_expertise_id', '!=', 14)->where('mode_id', '!=', 7)
            ->whereDoesntHave('document', function ($query) {
                $query->where('type_document_id', 6);
            })
            ->whereHas('onedevis', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })->whereDoesntHave('facture')->count();

        $attfacture = Dossier::user()->where('dossier_status_id', 2)
            ->where('update', 0)->where('type_expertise_id', '!=', 14)->where('mode_id', '!=', 7)
            ->whereHas('document', function ($query) {
                $query->where('type_document_id', 6);
            })
            ->whereHas('onedevis', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })->whereDoesntHave('facture')->count();
        $attrapport = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })->whereDoesntHave('rapport')->count();
        $warning = 0;
        $basedoc = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereDoesntHave('document.typedocument', function ($query) {
            $query->whereIn('type_document_id', [1, 2, 3]);
        })->distinct()->with('document')->count();

        // foreach ($dossiers as $dossier) {
        //     $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
        //         $query->where('step_id', $dossier->step_id);
        //     })->first();
        //     $step = DB::table('step_dossier')
        //         ->where('dossier_id', $dossier->id)
        //         ->where('step_id', $dossier->step_id)
        //         ->first();
        //     $dateDiff = Carbon::now()->diffInHours($step->created_at);
        //     dd($company->step);
        //     if ($company->step) {
        //         if ($company->step[0]->pivot->time > 0) {
        //             if ($company->step[0]->pivot->time < $dateDiff) {
        //                 $warning++;
        //             }
        //         }
        //     }
        // }

        //Devis ZONE

        $devisaretraiter = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('devis')->with('onedevis', 'montant')->get();
        // $deviscontrol = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
        //     ->whereHas('devis')->with('onedevis')->get();


        $count = 0;
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id == 5) {
                    if (Auth::user()->role_id == 2) {
                        $seuil = Seuil::where('company_id', $value->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {

                            if ($value->onedevis->montant_devis > $seuil->min && $value->onedevis->montant_devis < $seuil->max) {
                                $count++;
                            }
                        }
                    }
                }
            }
        }

        $deuxdevis = 0;
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id === 1) {
                    $deuxdevis++;
                }
            }
        }

        $attdevisav = 0;
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis->devis_status_id == 9) {
                $attdevisav++;
            }
        }

        $traitdevis = 0;
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id === 4) {
                    if (Auth::user()->role_id == 2) {
                        $seuil = Seuil::where('company_id', $value->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {
                            if ($value->onedevis->montant_devis > $seuil->min && $value->onedevis->montant_devis < $seuil->max) {
                                $traitdevis++;
                            }
                        }
                    } else {
                        if ($value->mode_id == 3 || $value->mode_id == 2) {
                            if (isset($value->valeurvenale) || isset($value->valeurepave)) {
                                $traitdevis++;
                            } else {
                                $traitdevis++;
                            }
                        } else {
                            $traitdevis++;
                        }
                    }
                }
            }
        }

        $senddevis = 0;
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id === 2) {
                    $senddevis++;
                }
            }
        }
        $avisdevis = 0;
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id === 3) {
                    $avisdevis++;
                }
            }
        }
        $controldevis = 0;
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id === 8) {
                    if (Auth::user()->role_id == 2) {
                        $seuil = Seuil::where('company_id', $value->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        // dd($seuil,$value);
                        if ($seuil) {
                            if ($value->montant->montant_accord < $seuil->accord) {
                                $controldevis++;
                            }
                        }
                    } else if (Auth::user()->role_id == 4) {
                        $controldevis++;
                    }
                }
            }
        }

        //Facture ZONE
        $facturearetraiter = Dossier::user()->where('dossier_status_id', 2)
            ->whereHas('facture')->with('onefacture')->get();
        $count2 = 0;
        foreach ($facturearetraiter as $value) {
            if ($value->onefacture->devis_status_id == 5) {
                if (Auth::user()->role_id == 2) {
                    $seuil = Seuil::where('company_id', $value->company_id)
                        ->where('user_id', Auth::user()->id)->first();
                    if ($seuil) {
                        if ($value->onefacture->montant_facture > $seuil->min && $value->onefacture->montant_facture < $seuil->max) {
                            $count2++;
                        }
                    }
                } else {
                    $count2++;
                }
            }
        }
        $deuxfacture = 0;
        foreach ($facturearetraiter as $value) {
            if ($value->onefacture) {
                if ($value->onefacture->devis_status_id === 1) {
                    $deuxfacture++;
                }
            }
        }
        $attfactureap = 0;
        foreach ($facturearetraiter as $value) {
            if ($value->onefacture) {
                if ($value->onefacture->devis_status_id === 9) {
                    $attfactureap++;
                }
            }
        }

        $traitfacture = 0;
        foreach ($facturearetraiter as $value) {
            if ($value->onefacture) {
                if ($value->onefacture->devis_status_id === 4) {
                    if (Auth::user()->role_id == 2) {
                        $seuil = Seuil::where('company_id', $value->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {

                            if ($value->onefacture->montant_facture > $seuil->min && $value->onefacture->montant_facture < $seuil->max) {
                                $traitfacture++;
                            }
                        }
                    } else {
                        $traitfacture++;
                    }
                }
            }
        }
        $sendfacture = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereDoesntHave('rapport')
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 2);
            })->count();
        $avisfacture = 0;
        foreach ($facturearetraiter as $value) {
            if ($value->onefacture) {
                if ($value->onefacture->devis_status_id === 3) {
                    $avisfacture++;
                }
            }
        }

        //Rapport ZONE
        $rapportaretraiter = Dossier::user()->where('dossier_status_id', 2)
            ->whereHas('rapport')->with('onerapport')->get();

        $count3 = 0;
        foreach ($rapportaretraiter as $value) {
            if ($value->update == 0) {

                if ($value->onerapport->rapport_status_id == 5) {
                    $count3++;
                }
            }
        }
        $traitrapport = 0;
        foreach ($rapportaretraiter as $value) {
            if ($value->update == 0) {
                if ($value->onerapport) {
                    if ($value->onerapport->rapport_status_id === 5) {
                        $traitrapport++;
                    }
                }
            }
        }
        $sendrapport = 0;
        foreach ($rapportaretraiter as $value) {
            if ($value->onerapport) {
                if ($value->onerapport->rapport_status_id === 2) {
                    $sendrapport++;
                }
            }
        }
        $deuxrapport = 0;
        foreach ($rapportaretraiter as $value) {
            if ($value->onerapport) {
                if ($value->update == 0) {

                    if ($value->onerapport->rapport_status_id === 1) {
                        $deuxrapport++;
                    }
                }
            }
        }
        $rapportasigner = 0;
        foreach ($rapportaretraiter as $value) {
            if ($value->update == 0) {
                if ($value->onerapport) {
                    if ($value->onerapport->rapport_status_id === 4) {
                        $rapportasigner++;
                    }
                }
            }
        }
        //END
        $ticketcount  = Ticket::where('user_id', Auth::user()->id)->where('status_rendezvous_id', 2)->count();
        $ticketcountterminer  = Ticket::where('creator_id', Auth::user()->id)->where('status_rendezvous_id', 3)->count();


        return view('dashboards.front', compact('dossiers', 'ticketcount','ticketcountterminer', 'docsigner', 'attexpap', 'enexp', 'rdv', 'demandes', 'basedoc', 'docasigner', 'rapide', 'deuxrapport', 'areport', 'attrapport', 'aexpcount', 'warning', 'rapportasigner', 'attdevis', 'attfacture', 'count', 'count2', 'count3', 'traitdevis', 'traitfacture', 'traitrapport', 'avisdevis', 'avisfacture', 'senddevis', 'sendfacture', 'sendrapport', 'aexpcount',  'rapportasigner', 'attdevis', 'attfacture', 'count', 'count2', 'count3', 'traitdevis', 'traitfacture', 'traitrapport', 'avisdevis', 'avisfacture', 'senddevis', 'deuxfacture', 'deuxdevis', 'tribunale', 'douteux', 'dossiersfacture', 'controldevis', 'attdevisav', 'attfactureap'));
    }

    //Carence
    public function aexpertiser()
    {
        $this->authorize('attphav', Dashboard::class);

        $dossiers =  Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereDoesntHave('devis')
            ->whereDoesntHave('document', function ($query) {
                $query->where('type_document_id', 5);
            })->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'currentStep', 'status')
            ->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }

        return response()->json($dossiers);
    }

    public function carencedevis()
    {
        $this->authorize('attdevis', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'currentStep',  'onefacture', 'onedevis', 'mode', 'insured', 'typeexpertise', 'status')
            ->whereDoesntHave('devis')->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function carencefacture()
    {
        $this->authorize('attfacture', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)
            ->where('update', 0)->where('type_expertise_id', '!=', 14)->where('mode_id', '!=', 7)
            ->with('company', 'onefacture', 'onedevis', 'currentStep', 'mode', 'insured', 'typeexpertise', 'status')
            ->whereHas('document', function ($query) {
                $query->where('type_document_id', 6);
            })
            ->whereHas('onedevis', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })->whereDoesntHave('facture')->get();

        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function carencerapport()
    {
        $this->authorize('attrapport', Dashboard::class);

        // should check if accord
        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'currentStep', 'onefacture', 'onedevis', 'mode', 'insured', 'typeexpertise', 'status')
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })
            ->whereDoesntHave('rapport')->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }

        return response()->json($dossiers);
    }
    //A retraiter
    public function devisaretraiter()
    {
        $this->authorize('retraitdevis', Dashboard::class);

        $devisaretraiter = Dossier::user()->with('onedevis')->where('dossier_status_id', 2)->where('update', 0)->get();
        $array = [];
        foreach ($devisaretraiter as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id === 5) {
                    if (Auth::user()->role_id == 2) {
                        $seuil = Seuil::where('company_id', $value->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {
                            if ($value->onedevis->montant_devis > $seuil->min && $value->onedevis->montant_devis < $seuil->max) {
                                array_push($array, $value->onedevis->dossier_id);
                            }
                        }
                    } else {
                        array_push($array, $value->onedevis->dossier_id);
                    }
                }
            }
        }
        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereIn('id', $array)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {
                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }

        return response()->json($dossiers);
    }

    public function facturearetraiter()
    {
        $this->authorize('retraitfacture', Dashboard::class);

        $facturearetraiter = Dossier::user()->with('onefacture')->where('dossier_status_id', 2)->where('update', 0)
            ->get();
        $array = [];


        foreach ($facturearetraiter as $value) {
            if ($value->onefacture) {
                if ($value->onefacture->devis_status_id === 5) {
                    if (Auth::user()->role_id == 2) {
                        $seuil = Seuil::where('company_id', $value->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {
                            if ($value->onefacture->montant_devis > $seuil->min && $value->onefacture->montant_devis < $seuil->max) {
                                array_push($array, $value->onefacture->dossier_id);
                            }
                        }
                    } else {
                        array_push($array, $value->onefacture->dossier_id);
                    }
                }
            }
        }

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'currentStep', 'onefacture', 'onedevis', 'insured', 'typeexpertise', 'status')
            ->whereIn('id', $array)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function rapportaretraiter()
    {
        $this->authorize('instacerapport', Dashboard::class);

        $rapportaretraiter = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->whereHas('rapport')
            ->with('onerapport')->get();
        $array = [];
        foreach ($rapportaretraiter as $value) {
            if ($value->onerapport) {
                if ($value->onerapport->rapport_status_id === 5) {
                    array_push($array, $value->onerapport->dossier_id);
                }
            }
        }
        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereIn('id', $array)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function rapportasigner()
    {
        $this->authorize('rappsigner', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('rapport', function ($query) {
                $query->where('rapport_status_id', 4);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    //Traitement

    public function traitdevis()
    {
        $this->authorize('traitdevis', Dashboard::class);

        $dossierss = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 4);
            })->with('company', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();
        $except = [];
        foreach ($dossierss as $dossier) {
            if ($dossier->onedevis) {
                if ($dossier->onedevis->devis_status_id === 4) {
                    if (Auth::user()->role_id == 2) {

                        $seuil = Seuil::where('company_id', $dossier->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {

                            if ($dossier->onedevis->montant_devis > $seuil->min && $dossier->onedevis->montant_devis < $seuil->max) {
                                array_push($except, $dossier->id);
                            }
                        }
                    } else {
                        if ($dossier->mode_id == 3 || $dossier->mode_id == 2) {
                            if (isset($dossier->valeurvenale) || isset($dossier->valeurepave)) {
                                array_push($except, $dossier->id);
                            } else {
                                array_push($except, $dossier->id);
                            }
                        } else {
                            array_push($except, $dossier->id);
                        }
                    }
                    // if ($dossier->mode_id == 3 || $dossier->mode_id == 2) {
                    //     if (isset($dossier->valeurvenale) || isset($dossier->valeurepave)) {
                    //     } else {
                    //         array_push($except, $dossier->id);
                    //     }
                    // } else {
                    //     array_push($except, $dossier->id);
                    // }
                }
            }
        }

        $dossiers = Dossier::user()->whereIn('id', $except)->where('dossier_status_id', 2)
            ->where('update', 0)
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 4);
            })
            ->with('company', 'currentStep', 'insured', 'onefacture', 'onedevis', 'typeexpertise', 'status', 'mode')
            ->get();

        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {
                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function traitfacture()
    {
        $this->authorize('traitfacture', Dashboard::class);

        $dossierss = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 4);
            })->with('company', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();
        $except = [];
        foreach ($dossierss as $dossier) {

            if ($dossier->onefacture) {
                if ($dossier->onefacture->devis_status_id === 4) {
                    if (Auth::user()->role_id == 2) {
                        $seuil = Seuil::where('company_id', $dossier->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {
                            if ($dossier->onefacture->montant_facture > $seuil->min && $dossier->onefacture->montant_facture < $seuil->max) {
                                array_push($except, $dossier->id);
                            }
                        }
                    } else {
                        array_push($except, $dossier->id);
                    }
                }
            }
        }
        $dossiers = Dossier::whereIn('id', $except)->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function traitrapport()
    {

        $this->authorize('instacerapport', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('rapport', function ($query) {
                $query->where('rapport_status_id', 5);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }

        return response()->json($dossiers);
    }

    //ATTENT photo
    public function attdevisav()
    {

        $this->authorize('devisattpa', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('onedevis', function ($query) {
                $query->where('devis_status_id', 9);
            })->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }
    public function attfactureap()
    {

        $this->authorize('factureattph', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 9);
            })->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }
    //DemandeAvis

    public function avisdevis()
    {

        $this->authorize('avisdevis', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 3);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function avisfacture()
    {

        $this->authorize('avisfacture', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 3);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function senddevis()
    {
        $this->authorize('devisacc', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 2);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function controldevis()
    {

        $this->authorize('controldevis', Dashboard::class);

        $dossierss = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 8);
            })->with('company', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status', 'montant')
            ->get();
        $except = [];
        foreach ($dossierss as $dossier) {
            if ($dossier->onedevis) {
                if ($dossier->onedevis->devis_status_id === 8) {
                    if (Auth::user()->role_id == 2) {

                        $seuil = Seuil::where('company_id', $dossier->company_id)
                            ->where('user_id', Auth::user()->id)->first();
                        if ($seuil) {
                            if ($dossier->montant->montant_accord < $seuil->accord) {
                                array_push($except, $dossier->id);
                            }
                        }
                    } else {
                        // if ($dossier->mode_id == 3 || $dossier->mode_id == 2) {
                        //     if (isset($dossier->valeurvenale) || isset($dossier->valeurepave)) {
                        //     } else {
                        //         array_push($except, $dossier->id);
                        //     }
                        // } else {}
                        array_push($except, $dossier->id);
                    }
                }
            }
        }

        $dossiers = Dossier::user()->whereIn('id', $except)->where('dossier_status_id', 2)
            ->where('update', 0)
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 8);
            })
            ->with('company', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status', 'mode')
            ->get();

        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {
                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function sendfacture()
    {

        $this->authorize('factureacc', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)
            ->whereDoesntHave('rapport')
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 2);
            })->get();

        //  $facturearetraiter = Dossier::user()->where('dossier_status_id', 2)
        // ->whereHas('facture')->with('onefacture')->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function sendrapport()
    {

        $this->authorize('rapportenv', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('rapport', function ($query) {
                $query->where('rapport_status_id', 2);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function deuxdevis()
    {

        $this->authorize('att2emedevis', Dashboard::class);

        $dossiers2 = Dossier::user()->with('company', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
            ->with('onedevis')->get();

        $array = [];
        foreach ($dossiers2 as $value) {
            if ($value->onedevis) {
                if ($value->onedevis->devis_status_id === 1) {
                    array_push($array, $value->onedevis->dossier_id);
                }
            }
        }
        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereIn('id', $array)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function deuxfacture()
    {

        $this->authorize('att2emefacture', Dashboard::class);

        $dossiers2 = Dossier::user()->with('company', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
            ->with('onefacture')->get();

        $array = [];
        foreach ($dossiers2 as $value) {
            if ($value->onefacture) {
                if ($value->onefacture->devis_status_id === 1) {
                    array_push($array, $value->onefacture->dossier_id);
                }
            }
        }
        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereIn('id', $array)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function deuxrapport()
    {

        $this->authorize('rapportref', Dashboard::class);

        $dossiers2 = Dossier::user()->with('company', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
            ->with('onerapport')->get();

        $array = [];
        foreach ($dossiers2 as $value) {
            if ($value->onerapport) {
                if ($value->onerapport->rapport_status_id === 1) {
                    array_push($array, $value->onerapport->dossier_id);
                }
            }
        }

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereIn('id', $array)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }

        return response()->json($dossiers);
    }

    public function areport()
    {

        $this->authorize('attphav', Dashboard::class);

        $dossiers2 = Dossier::user()->with('company', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
            ->with('onemeeting')->get();

        $array = [];
        foreach ($dossiers2 as $value) {
            if ($value->onemeeting) {
                if ($value->onemeeting->meeting_status_id === 1) {
                    array_push($array, $value->onemeeting->dossier_id);
                }
            }
        }

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereIn('id', $array)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }
    public function douteux()
    {

        $this->authorize('douteux', Dashboard::class);

        $dossiers = Dossier::user()->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
            ->where('sinistre_douteux', 1)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function tribunale()
    {

        $this->authorize('tribunale', Dashboard::class);

        $dossiers = Dossier::user()->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
            ->where('type_expertise_id', 9)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function rapide()
    {

        $this->authorize('rapide', Dashboard::class);

        if (Auth::user()->role_id == 2) {
            $dossiers = Dossier::user()->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
                ->whereIn('step_id', ['4,9'])
                ->where('type_expertise_id', 16)->get();
        } else {
            $dossiers = Dossier::user()->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('dossier_status_id', 2)->where('update', 0)
                ->where('type_expertise_id', 16)->get();
        }
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function warning()
    {

        $this->authorize('attphav', Dashboard::class);

        $ds = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->get();
        $array = [];
        foreach ($ds as $dossier) {
            $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                $query->where('step_id', $dossier->currentStep->id);
            })->first();
            $dateDiff = Carbon::now()->diffInHours($dossier->currentStep->created_at);
            if ($company->step) {
                if ($company->step[0]->pivot->time  > 0) {
                    if ($company->step[0]->pivot->time  < $dateDiff) {
                        array_push($array, $dossier->id);
                    }
                }
            }
            $dossiers = Dossier::user()->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
                ->where('dossier_status_id', 2)->where('update', 0)
                ->whereIn('id', $array)->get();
        }
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function docasigner()
    {

        $this->authorize('docasigner', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('document', function ($query) {
                $query->where('type_document_id', 21)->where('signer', 0)->where('rejected', 0);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function docsigner()
    {

        $this->authorize('docasigner', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('document', function ($query) {
                $query->where('type_document_id', 21)->where('signer', 1)->where('rejected', 0);
            })
            ->whereDoesntHave('onerapport', function ($query) {
                $query->whereIn('rapport_status_id', [2, 3]);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function fasigner()
    {

        $this->authorize('afacturé', Dashboard::class);

        $dossiers = Dossier::where('dossier_status_id', 2)->with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->where('update', 0)->whereHas('document', function ($query) {
            $query->where('type_document_id', 16)->where('signer', 0);
        })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {
                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function basedoc()
    {
        $this->authorize('attdocbase', Dashboard::class);


        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')->whereDoesntHave('document.typedocument', function ($query) {
                $query->whereIn('type_document_id', [1, 2, 3]);
            })
            ->distinct()
            ->with('document')->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function facturation()
    {

        $this->authorize('afacturé', Dashboard::class);

        $dossiers = Dossier::with('company', 'onefacture', 'onedevis', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')->whereNull('facture')->where('dossier_status_id', 2)->where('update', 1)->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function devisentraitement()
    {

        $this->authorize('devisattacc', Dashboard::class);

        $dossierss = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 4);
            })->with('company', 'mode', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();
        $except = [];
        foreach ($dossierss as $dossier) {
            if ($dossier->onedevis) {
                if ($dossier->onedevis->devis_status_id === 4) {
                    if ($dossier->mode_id == 3 || $dossier->mode_id == 2) {
                        if (isset($dossier->valeurvenale) || isset($dossier->valeurepave)) {
                        } else {
                            array_push($except, $dossier->id);
                        }
                    } else {
                        array_push($except, $dossier->id);
                    }
                }
            }
        }
        $dossiers = Dossier::user()->whereIn('id', $except)->where('dossier_status_id', 2)
            ->where('update', 0)
            ->whereHas('devis', function ($query) {
                $query->where('devis_status_id', 4);
            })
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();

        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function factureentraitement()
    {

        $this->authorize('factureattacc', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->whereHas('facture', function ($query) {
                $query->where('devis_status_id', 4);
            })->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }

        return response()->json($dossiers);
    }

    public function enexp()
    {

        $this->authorize('enexp', Dashboard::class);

        $dossiers =  Dossier::user()->where('dossier_status_id', 2)->where('update', 0)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->whereHas('meeting', function ($query) {
                $query->where('meeting_status_id', 2);
            })->get();
        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }

    public function attexpap()
    {

        $this->authorize('attphap', Dashboard::class);

        $dossiers = Dossier::user()->where('dossier_status_id', 2)
            ->with('company', 'mode', 'onefacture', 'onedevis', 'currentStep', 'insured', 'typeexpertise', 'status')
            ->where('update', 0)->where('type_expertise_id', '!=', 14)->where('mode_id', '!=', 7)
            ->whereDoesntHave('document', function ($query) {
                $query->where('type_document_id', 6);
            })
            ->whereHas('onedevis', function ($query) {
                $query->where('devis_status_id', 2)->Orwhere('devis_status_id', 7);
            })->whereDoesntHave('facture')
            ->get();


        foreach ($dossiers as $dossier) {
            if ($dossier->company_id) {

                $company = Company::whereId($dossier->company_id)->with('step', function ($query) use ($dossier) {
                    $query->where('step_id', $dossier->step_id)->first();
                })->first();
                $stepdate = DB::table('step_dossier')
                    ->where('dossier_id', $dossier->id)
                    ->where('step_id', $dossier->currentStep->id)
                    ->latest()->first();

                if ($company->step) {
                    $monthdate = Carbon::parse($stepdate->created_at);
                    $dateDiff = Carbon::now()->diffInHours($monthdate);
                    $limit = $company->step[0]->pivot->time ?? 0;
                    $timeleft = $limit - $dateDiff;
                    $dossier->timeleft = $timeleft;
                } else {
                    $dossier->timeleft = 0;
                }
            } else {
                $dossier->timeleft = 0;
            }
        }
        return response()->json($dossiers);
    }
}
