<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\Expert;
use Illuminate\Http\Request;

class ExpertController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny', Expert::class);

        $experts = Expert::all();
        return view('configuration.expert.index',compact('experts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', Expert::class);

        $cities = City::all();
        return view('configuration.expert.create',compact('cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Expert::class);
        $request->validate([
            'name'=>'required|string',
            'email'=>'nullable|email',
            'tel'=>'nullable|min:10|unique:experts,tel',

        ]);
        Expert::create([
           'name'=>$request->name,
           'adress'=>$request->adress,
           'city_id'=>$request->city_id,
           'email'=>$request->email,
           'tel'=>$request->tel,
        ]);
        return redirect()->route('Expert.index')->with('succes','Expert est Créer Aves Succés');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Expert  $expert
     * @return \Illuminate\Http\Response
     */
    public function show(Expert $expert)
    {
        $this->authorize('view', Expert::class);

        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Expert  $expert
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', Expert::class);

        $expert = Expert::whereId($id)->first();
        $cities = City::where('id','!=',$expert->city_id)->get();
        return view('configuration.expert.edit',compact('expert','cities'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Expert  $expert
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update', Expert::class);
        $request->validate([
            'name'=>'required|string',
            'email'=>'nullable|email',
            'tel'=>'nullable|min:10|unique:experts,tel,'.$id,
        ]);
        $expert = Expert::whereId($id)->first();
        $expert->name = $request->name;
        $expert->tel = $request->tel;
        $expert->email = $request->email;
        $expert->adress = $request->adress;
        $expert->city_id = $request->city_id;
        $expert->update();

        return redirect()->route('Expert.index')->with('succes','Expert est Modifier Aves Succés');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Expert  $expert
     * @return \Illuminate\Http\Response
     */
    public function destroy(Expert $expert)
    {
        //
    }
}
