<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\NoteHonoraire;
use App\Models\TypeDossier;
use App\Models\TypeExpertise;
use Illuminate\Http\Request;

class NoteHonoraireController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny',NoteHonoraire::class);
        $notes = NoteHonoraire::with('typeexpertise','company')->get();
        // dd($notes);
        return view('configuration.notehonoraire.index',compact('notes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create',NoteHonoraire::class);

        $companies = Company::all();
        $types = TypeExpertise::all();
        return view('configuration.notehonoraire.create',compact('types','companies'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create',NoteHonoraire::class);

        $request->validate([
            'company'=>'required',
            'type'=>'required',
            'montant'=>'required|numeric'
        ]);
        NoteHonoraire::create([
            'type_expertise_id'=>$request->type,
            'company_id'=>$request->company,
            'montant'=>$request->montant
        ]);
        return redirect()->route('NoteHonoraire.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\NoteHonoraire  $noteHonoraire
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\NoteHonoraire  $noteHonoraire
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update',NoteHonoraire::class);

        $note = NoteHonoraire::whereId($id)->with('typeexpertise','company')->firstOrFail();
        return view('configuration.notehonoraire.edit',compact('note'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\NoteHonoraire  $noteHonoraire
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update',NoteHonoraire::class);

        $request->validate([
            'montant'=>'required|numeric'
        ]);
        $note = NoteHonoraire::whereId($id)->firstOrFail();
        $note->montant = $request->montant;
        $note->update();
        return redirect()->route('NoteHonoraire.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\NoteHonoraire  $noteHonoraire
     * @return \Illuminate\Http\Response
     */
    public function destroy(NoteHonoraire $noteHonoraire)
    {
        //
    }
}
