<?php

namespace App\Http\Controllers;

use App\Models\TypeReparation;
use Illuminate\Http\Request;

class TypeReparationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $types = TypeReparation::all();
        return view('configuration.Types.reparation.index',compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.Types.reparation.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        TypeReparation::create([
            'type'=>$request->type
        ]);
        return redirect()->route('TypeReparation.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $type = TypeReparation::whereId($id)->firstOrFail();
        return view('configuration.Types.reparation.edit',compact('type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $type = TypeReparation::whereId($id)->firstOrFail();
        $type->type = $request->type;
        $type->update();
        return redirect()->route('TypeReparation.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $type = TypeReparation::whereId($id)->firstOrFail();
        // $type->delete();
        return redirect()->route('TypeReparation.index');
    }
}
