<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\VehiculeModel;
use Illuminate\Http\Request;

class VehiculeModelController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny',VehiculeModel::class);
        $models = VehiculeModel::with('brand')->get();
        return view('configuration.Modele.index',compact('models'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create',VehiculeModel::class);
        $brands = Brand::all();
        return view('configuration.Modele.create',compact('brands'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create',VehiculeModel::class);

        $request->validate([
            'name'=>'required',
            'code'=>'required',
            'brand'=>'required'
        ]);
        VehiculeModel::create([
            'name'=>$request->name,
            'code'=>$request->code,
            'brand_id'=>$request->brand
        ]);
        return redirect()->route('Modele.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\VehiculeModel  $vehiculeModel
     * @return \Illuminate\Http\Response
     */
    public function show(VehiculeModel $vehiculeModel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\VehiculeModel  $vehiculeModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update',VehiculeModel::class);

        $model = VehiculeModel::whereId($id)->with('brand')->first();
        $brands = Brand::where('id','!=',$model->brand_id)->get();

        return view('configuration.Modele.edit',compact('model','brands'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\VehiculeModel  $vehiculeModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update',VehiculeModel::class);

        $request->validate([
            'name'=>'required',
            'code'=>'required',
            'brand'=>'required'
        ]);
        $vehiculeModel = VehiculeModel::whereId($id)->first();
        $vehiculeModel->name = $request->name;
        $vehiculeModel->code = $request->code;
        $vehiculeModel->brand_id = $request->brand;
        $vehiculeModel->update();

        return redirect()->route('Modele.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\VehiculeModel  $vehiculeModel
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('delete',VehiculeModel::class);

        $vehiculeModel = VehiculeModel::whereId($id)->first();
        $vehiculeModel->delete();

        return redirect()->route('Modele.index');
    }


    public function deleted()
    {
        $models = VehiculeModel::onlyTrashed()->get();
       // dd($models);
       return view('configuration.Modele.deleted',compact('models')) ;

    }

    public function restore($id)
    {
        VehiculeModel::withTrashed()->find($id)->restore();
         return redirect()->route('Modele.index');

    }

}
