<?php

namespace App\Http\Controllers;

use App\Models\Devis;
use App\Models\Dossier;
use App\Models\Facture;
use App\Models\Montant;
use Illuminate\Http\Request;

class MontantController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Montant  $montant
     * @return \Illuminate\Http\Response
     */
    public function show(Montant $montant)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Montant  $montant
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $montant = Montant::whereId($id)->with('devis','facture')->firstOrFail();
        $dossier = Dossier::whereId($montant->dossier_id)->firstOrFail();


        if($dossier->update){
            return redirect()->route('Dossier.show', $dossier->id)->with('error','Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        $devis = 0;
        $facture = 0;
        if($montant->facture){
            $facture = 1;
        }
        if($montant->devis){
            $devis = 1;
        }

        return view('montant.edit',compact('montant','devis','facture'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Montant  $montant
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $montant = Montant::whereId($id)->with('devis','facture')->firstOrFail();
        $dossier = Dossier::whereId($montant->dossier_id)->firstOrFail();
        if($dossier->update){
            return redirect()->route('Dossier.show', $dossier->id)->with('error','Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        if($montant->devis){
            $request->validate([
                'montant_devis'=>'required|numeric',
            ]);
            $devis = Devis::whereId($montant->devis_id)->first();
            $devis->montant_devis = $request->montant_devis;
            $devis->update();

        }
        if($montant->facture){
            $request->validate([
                'montant_facture'=>'required|numeric'
            ]);
            $facture = Facture::whereId($montant->facture_id)->first();
            $facture->montant_facture = $request->montant_facture;
            $facture->update();
        }


        $montant->montant_accord = $request->montant_accord;

        $montant->update();
        return redirect()->back();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Montant  $montant
     * @return \Illuminate\Http\Response
     */
    public function destroy(Montant $montant)
    {
        //
    }
}
