<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VehiculeModel extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
        'name',
        'code',
        'brand_id'
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class)->withTrashed();
    }

    public function dossier()
    {
        return $this->hasMany(VehiculeModel::class)->withTrashed();
    }
    public function piece()
    {
        return $this->hasMany(Piece::class)->withTrashed();
    }

}
