<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Auth;

class DashboardPolicy
{
    use HandlesAuthorization;

    public function enexp(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_en_expertise') || $user->hasRolePermission('naviguer_en_expertise')) {
            return true;
        }
    }

    public function attphav(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_photo_avant') || $user->hasRolePermission('naviguer_attente_photo_avant')) {
            return true;
        }
    }

    public function attdocbase(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_document_base') || $user->hasRolePermission('naviguer_attente_document_base')) {
            return true;
        }
    }

    public function attdevis(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_devis') || $user->hasRolePermission('naviguer_attente_devis')) {
            return true;
        }
    }

    public function devisattpa(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_devis_attente_photo') || $user->hasRolePermission('naviguer_devis_attente_photo')) {
            return true;
        }
    }

    public function att2emedevis(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_2eme_devis') || $user->hasRolePermission('naviguer_attente_2eme_devis')) {
            return true;
        }
    }

    public function devisattacc(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_devis_attente_accord') || $user->hasRolePermission('naviguer_devis_attente_accord')) {
            return true;
        }
    }

    public function devisacc(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_devis_accord') || $user->hasRolePermission('naviguer_devis_accord')) {
            return true;
        }
    }

    public function attphap(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_photo_apres') || $user->hasRolePermission('naviguer_attente_photo_apres')) {
            return true;
        }
    }

    public function attfacture(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_facture') || $user->hasRolePermission('naviguer_attente_facture')) {
            return true;
        }
    }

    public function factureattph(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_facture_attente_photo') || $user->hasRolePermission('naviguer_facture_attente_photo')) {
            return true;
        }
    }

    public function att2emefacture(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_2eme_facture') || $user->hasRolePermission('naviguer_attente_2eme_facture')) {
            return true;
        }
    }

    public function factureattacc(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_facture_attente_accord') || $user->hasRolePermission('naviguer_facture_attente_accord')) {
            return true;
        }
    }

    public function factureacc(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_facture_accord') || $user->hasRolePermission('naviguer_facture_accord')) {
            return true;
        }
    }

    public function attrapport(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_attente_rapport') || $user->hasRolePermission('naviguer_attente_rapport')) {
            return true;
        }
    }

    public function instacerapport(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_instance_rapport') || $user->hasRolePermission('naviguer_instance_rapport')) {
            return true;
        }
    }

    public function rapportenv(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_rapport_a_envoyer') || $user->hasRolePermission('naviguer_rapport_a_envoyer')) {
            return true;
        }
    }

    public function rapportref(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_rapport_refuser') || $user->hasRolePermission('naviguer_rapport_refuser')) {
            return true;
        }
    }

    public function docasigner(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_document_asigner') || $user->hasRolePermission('naviguer_document_asigner')) {
            return true;
        }
    }

    public function traitdevis(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_devis_a_traiter') || $user->hasRolePermission('naviguer_devis_a_traiter')) {
            return true;
        }
    }

    public function traitfacture(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_facture_a_traiter') || $user->hasRolePermission('naviguer_facture_a_traiter')) {
            return true;
        }
    }

    public function retraitdevis(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_devis_a_retraiter') || $user->hasRolePermission('naviguer_devis_a_retraiter')) {
            return true;
        }
    }

    public function retraitfacture(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_facture_a_retraiter') || $user->hasRolePermission('naviguer_facture_a_retraiter')) {
            return true;
        }
    }

    public function controldevis(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_devis_a_controler') || $user->hasRolePermission('naviguer_devis_a_controler')) {
            return true;
        }
    }

    public function rappsigner(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_rapport_a_signer') || $user->hasRolePermission('naviguer_rapport_a_signer')) {
            return true;
        }
    }

    public function avisdevis(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_devis_demande_avis') || $user->hasRolePermission('naviguer_devis_demande_avis')) {
            return true;
        }
    }

    public function avisfacture(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_facture_demande_avis') || $user->hasRolePermission('naviguer_facture_demande_avis')) {
            return true;
        }
    }

    public function douteux(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_dossiers_douteux') || $user->hasRolePermission('naviguer_dossiers_douteux')) {
            return true;
        }
    }

    public function tribunale(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_dossiers_tribunale') || $user->hasRolePermission('naviguer_dossiers_tribunale')) {
            return true;
        }
    }

    public function rdv(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_rendez_vous') || $user->hasRolePermission('naviguer_rendez_vous')) {
            return true;
        }
    }

    public function demandes(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_demandes') || $user->hasRolePermission('naviguer_demandes')) {
            return true;
        }
    }

    public function rapide(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_dossiers_rapide') || $user->hasRolePermission('naviguer_dossiers_rapide')) {
            return true;
        }
    }

    public function afacturé(User $user)
    {
        if ($user->role_id === 4 || $user->hasPermission('naviguer_dossiers_a_facturé') || $user->hasRolePermission('naviguer_dossiers_a_facturé')) {
            return true;
        }
    }


}
