<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\Company;
use App\Models\VehiculeModel;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    /**
     * Display a listing of the resurce.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny',Brand::class);
        $brands = Brand::all();
        return view('configuration.brand.index',compact('brands'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create',Brand::class);
        return view('configuration.brand.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create',Brand::class);

        $request->validate([
            'brand'=>'required|unique:brands,brand'
        ]);
        Brand::create([
            'brand'=>$request->brand,
            'code'=>$request->brand
        ]);
        return redirect()->route('Brand.index');
    }

    public function search($brand_id){
        $models = VehiculeModel::where('brand_id',$brand_id)->get()->sortBy(function ($company) {
            return strtolower($company->name);
        })
        ->values();
        return response()->json($models);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Http\Response
     */
    public function show(Brand $brand)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update',Brand::class);

        $brand = Brand::whereId($id)->firstOrFail();
        return view('configuration.brand.edit',compact('brand'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update',Brand::class);

        $brand = Brand::whereId($id)->firstOrFail();
        $request->validate([
            'brand'=>'required|unique:brands,brand,'.$id . ''
        ]);

        $brand->brand = $request->brand;
        $brand->update();
        return redirect()->route('Brand.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('delete',Brand::class);
        $brand = Brand::whereId($id)->firstOrFail();
        $brand->delete();
        return redirect()->route('Brand.index');

    }

    public function deleted()
    {
        $brands = Brand::onlyTrashed()->get();
       return view('configuration.brand.deleted',compact('brands')) ;
    }

    public function restore($id)
    {
        Brand::withTrashed()->find($id)->restore();
         return redirect()->route('Brand.index');

    }

}
