<?php

namespace App\Http\Controllers;

use App\Models\Ip;
use Illuminate\Http\Request;

class IpController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $ips = Ip::all();
        return view('configuration.ip.index',compact('ips'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.ip.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'ip'=>'required|unique:ips,ip',
            'description'=>'required'
        ]);
        Ip::create([
            'ip'=>$request->ip,
            'description'=>$request->description
        ]);
        return redirect()->route('IP.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Ip  $ip
     * @return \Illuminate\Http\Response
     */
    public function show(Ip $ip)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Ip  $ip
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ip = Ip::whereId($id)->firstOrFail();
        return view('configuration.ip.edit',compact('ip'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ip  $ip
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'ip'=>'required|unique:ips,ip,'.$id
        ]);
        $ip = Ip::whereId($id)->firstOrFail();
        $ip->ip = $request->ip;
        $ip->description = $request->description;
        $ip->update();

        return redirect()->route('IP.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ip  $ip
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $ip = Ip::whereId($id)->firstOrFail();
        $ip->delete();
        return redirect()->route('IP.index');
    }
}
