<?php

namespace App\Http\Controllers;

use App\Models\Piece;
use App\Models\PieceType;
use Illuminate\Http\Request;

class PieceTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $typepieces = PieceType::where('svg', 1)->get();
        return view('configuration.Types.piece.index', compact('typepieces'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('configuration.Types.piece.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|unique:piece_types,type'
        ]);
        PieceType::create([
            'type' => $request->type,
            'svg' => 1
        ]);
        return redirect()->route('PieceType.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Http\Response
     */
    public function filter($id)
    {
        $pieces = Piece::where('piece_type_id', $id)
        ->get()
        ->sortBy(function ($piece) {
            return strtolower($piece->piece);
        })
        ->values();
        return response()->json($pieces);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pieceType  = PieceType::whereId($id)->first();
        return view('configuration.Types.piece.edit', compact('pieceType'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'type' => 'required|unique:piece_types,type,' . $id . ''
        ]);

        $pieceType = PieceType::whereId($id)->first();
        if ($pieceType->svg == 1) {
            $pieceType->type = $request->type;
            $pieceType->svg = 1;
            $pieceType->update();
        } else {
            return redirect()->route('PieceType.index')->with('error', 'ERROR');
        }

        return redirect()->route('PieceType.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PieceType  $pieceType
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $pieceType  = PieceType::whereId($id)->first();
        $pieceType->delete();
        return redirect()->route('PieceType.index');
    }

    public function deleted()
    {
        $typepieces = PieceType::onlyTrashed()->get();
        return view('configuration.Types.piece.deleted', compact('typepieces'));
    }
    public function restore($id)
    {
        PieceType::withTrashed()->find($id)->restore();
        return redirect()->route('PieceType.index');
    }
}
