<?php

namespace App\Http\Controllers;

use App\Models\Devis;
use App\Models\Dossier;
use App\Models\Rapport;
use App\Models\Taux;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TauxController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Rapport::class);

        // $request->validate([
        //     'type_ingredient' => 'required'
        // ]);

        if ($request->has('rapport_id')) {
            $rapport = Rapport::whereId($request->rapport_id)->firstOrFail();
            $dossier = Dossier::whereId($rapport->dossier_id)->firstOrFail();
        } else {
            return redirect()->back();
        }
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        if ($rapport->rapport_status_id == 2  && $rapport->rapport_status_id == 3) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'rapport est interdit de le modifier');
        }

        if ($rapport->taux_id) {
            $taux = Taux::find($rapport->taux_id)->update(
                [
                    'taux_1' => $request->taux_1,
                    'taux_2' => $request->taux_2,
                    'taux_3' => $request->taux_3,
                    't1' => $request->t1,
                    't2' => $request->t2,
                    't3' => $request->t3,
                    'taux_electricite' => $request->taux_electricite,
                    'taux_mecanique' => $request->taux_mecanique,
                    'taux_controle' => $request->taux_controle,
                    'te' => $request->te,
                    'tm' => $request->tm,
                    'tc' => $request->tc,
                    'tp' => $request->tp,
                    'taux_mo_peinture' => $request->taux_mo_peinture,
                    'forfait_ing_pieces' => $request->forfait_ing_pieces,
                    'remise_facture' => $request->remise_facture,
                    'remise_piece' => $request->remise_piece,
                    'remise_sur_total_mo' => $request->remise_sur_total_mo,
                    'tva_deductible' => $request->tva_deductible,
                    'forfait_mo_1' => $request->forfait_mo_1,
                    'forfait_mo_2' => $request->forfait_mo_2,
                    'forfait_mo_3' => $request->forfait_mo_3,
                    'forfait_peinture' => $request->forfait_peinture,
                    'taux_ing_opaque' => $request->taux_ing_opaque,
                    'taux_ing_opaque_vernis' => $request->taux_ing_opaque_vernis,
                    'taux_ing_metal' => $request->taux_ing_metal,
                    'taux_ing_metal_vernis' => $request->taux_ing_metal_vernis,
                    'taux_ing_nacre_vernis' => $request->taux_ing_nacre_vernis,
                    'remise_facture1' => $request->remise_facture1,
                    'remise_sur_total_mo_peinture' => $request->remise_sur_total_mo_peinture,
                    'type_ingredient_id' => $request->type_ingredient,
                    'franchise' => $request->franchise,
                    'franchise_fix' => $request->franchise_fix,
                    'forfait_electricite' => $request->forfait_electricite,
                    'forfait_mecanique' => $request->forfait_mecanique,
                    'forfait_controle' => $request->forfait_controle,
                    'taux_tva' => $request->taux_tva,
                    'taux_ing' => $request->taux_ing,
                    'vetuste' => $request->vetuste,

                ]
            );
        } else {

            $taux = Taux::create(
                [
                    'taux_1' => $request->taux_1,
                    'taux_2' => $request->taux_2,
                    'taux_3' => $request->taux_3,
                    't1' => $request->t1,
                    't2' => $request->t2,
                    't3' => $request->t3,
                    'taux_electricite' => $request->taux_electricite,
                    'taux_mecanique' => $request->taux_mecanique,
                    'taux_controle' => $request->taux_controle,
                    'te' => $request->te,
                    'tm' => $request->tm,
                    'tc' => $request->tc,
                    'tp' => $request->tp,
                    'taux_mo_peinture' => $request->taux_mo_peinture,
                    'forfait_ing_pieces' => $request->forfait_ing_pieces,
                    'remise_facture' => $request->remise_facture,
                    'remise_piece' => $request->remise_piece,
                    'remise_sur_total_mo' => $request->remise_sur_total_mo,
                    'tva_deductible' => $request->tva_deductible,
                    'forfait_mo_1' => $request->forfait_mo_1,
                    'forfait_mo_2' => $request->forfait_mo_2,
                    'forfait_mo_3' => $request->forfait_mo_3,
                    'forfait_peinture' => $request->forfait_peinture,
                    'taux_ing_opaque' => $request->taux_ing_opaque,
                    'taux_ing_opaque_vernis' => $request->taux_ing_opaque_vernis,
                    'taux_ing_metal' => $request->taux_ing_metal,
                    'taux_ing_metal_vernis' => $request->taux_ing_metal_vernis,
                    'taux_ing_nacre_vernis' => $request->taux_ing_nacre_vernis,
                    'remise_facture1' => $request->remise_facture1,
                    'remise_sur_total_mo_peinture' => $request->remise_sur_total_mo_peinture,
                    'type_ingredient_id' => $request->type_ingredient,
                    'franchise' => $request->franchise,
                    'franchise_fix' => $request->franchise_fix,
                    'forfait_electricite' => $request->forfait_electricite,
                    'forfait_mecanique' => $request->forfait_mecanique,
                    'forfait_controle' => $request->forfait_controle,
                    'taux_tva' => $request->taux_tva,
                    'taux_ing' => $request->taux_ing,
                    'vetuste' => $request->vetuste,
                ]
            );
            $rapport->taux_id = $taux->id;
            $rapport->update();
        }
        return redirect()->back()->with('success', 'Taux Enregister Avec Succés');
    }

    public function storedevis(Request $request)
    {
        // $this->authorize('create', Rapport::class);

        // $request->validate([
        //     'type_ingredient' => 'required'
        // ]);
        if ($request->has('devis_id')) {
            $devis = Devis::whereId($request->devis_id)->first();
            $dossier = Dossier::whereId($devis->dossier_id)->first();
        } else {
            return redirect()->back();
        }

        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        if ($devis->devis_status_id == 2 && $devis->devis_status_id == 7 && $devis->devis_status_id == 6) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Devis est interdit de le modifier');
        }

        if ($devis->taux_id) {
            $taux = Taux::find($devis->taux_id)->update(
                [
                    'taux_1' => $request->taux_1,
                    'taux_2' => $request->taux_2,
                    'taux_3' => $request->taux_3,
                    't1' => $request->t1,
                    't2' => $request->t2,
                    't3' => $request->t3,
                    'tp' => $request->tp,
                    'taux_electricite' => $request->taux_electricite,
                    'taux_mecanique' => $request->taux_mecanique,
                    'taux_controle' => $request->taux_controle,
                    'te' => $request->te,
                    'tm' => $request->tm,
                    'tc' => $request->tc,
                    'taux_mo_peinture' => $request->taux_mo_peinture,
                    'forfait_ing_pieces' => $request->forfait_ing_pieces,
                    'remise_facture' => $request->remise_facture,
                    'remise_piece' => $request->remise_piece,
                    'remise_sur_total_mo' => $request->remise_sur_total_mo,
                    'tva_deductible' => $request->tva_deductible,
                    'forfait_mo_1' => $request->forfait_mo_1,
                    'forfait_mo_2' => $request->forfait_mo_2,
                    'forfait_mo_3' => $request->forfait_mo_3,
                    'forfait_peinture' => $request->forfait_peinture,
                    'taux_ing_opaque' => $request->taux_ing_opaque,
                    'taux_ing_opaque_vernis' => $request->taux_ing_opaque_vernis,
                    'taux_ing_metal' => $request->taux_ing_metal,
                    'taux_ing_metal_vernis' => $request->taux_ing_metal_vernis,
                    'taux_ing_nacre_vernis' => $request->taux_ing_nacre_vernis,
                    'remise_facture1' => $request->remise_facture1,
                    'remise_sur_total_mo_peinture' => $request->remise_sur_total_mo_peinture,
                    'type_ingredient_id' => $request->type_ingredient,
                    'franchise' => $request->franchise,
                    'franchise_fix' => $request->franchise_fix,
                    'forfait_electricite' => $request->forfait_electricite,
                    'forfait_mecanique' => $request->forfait_mecanique,
                    'forfait_controle' => $request->forfait_controle,
                    'taux_ing' => $request->taux_ing,
                    'taux_tva' => $request->taux_tva,
                    'vetuste' => $request->vetuste,


                ]
            );
        } else {

            $taux = Taux::create(
                [
                    'taux_1' => $request->taux_1,
                    'taux_2' => $request->taux_2,
                    'taux_3' => $request->taux_3,
                    't1' => $request->t1,
                    't2' => $request->t2,
                    't3' => $request->t3,
                    'taux_electricite' => $request->taux_electricite,
                    'taux_mecanique' => $request->taux_mecanique,
                    'taux_controle' => $request->taux_controle,
                    'te' => $request->te,
                    'tm' => $request->tm,
                    'tc' => $request->tc,
                    'tp' => $request->tp,
                    'taux_mo_peinture' => $request->taux_mo_peinture,
                    'forfait_ing_pieces' => $request->forfait_ing_pieces,
                    'remise_facture' => $request->remise_facture,
                    'remise_piece' => $request->remise_piece,
                    'remise_sur_total_mo' => $request->remise_sur_total_mo,
                    'tva_deductible' => $request->tva_deductible,
                    'forfait_mo_1' => $request->forfait_mo_1,
                    'forfait_mo_2' => $request->forfait_mo_2,
                    'forfait_mo_3' => $request->forfait_mo_3,
                    'forfait_peinture' => $request->forfait_peinture,
                    'taux_ing_opaque' => $request->taux_ing_opaque,
                    'taux_ing_opaque_vernis' => $request->taux_ing_opaque_vernis,
                    'taux_ing_metal' => $request->taux_ing_metal,
                    'taux_ing_metal_vernis' => $request->taux_ing_metal_vernis,
                    'taux_ing_nacre_vernis' => $request->taux_ing_nacre_vernis,
                    'remise_facture1' => $request->remise_facture1,
                    'remise_sur_total_mo_peinture' => $request->remise_sur_total_mo_peinture,
                    'type_ingredient_id' => $request->type_ingredient,
                    'franchise' => $request->franchise,
                    'franchise_fix' => $request->franchise_fix,
                    'forfait_electricite' => $request->forfait_electricite,
                    'forfait_mecanique' => $request->forfait_mecanique,
                    'forfait_controle' => $request->forfait_controle,
                    'taux_ing' => $request->taux_ing,
                    'taux_tva' => $request->taux_tva,
                    'vetuste' => $request->vetuste,

                ]
            );
            $devis->taux_id = $taux->id;
            $devis->update();
        }
        return redirect()->back()->with('success', 'Taux Enregister Avec Succés');
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Taux  $taux
     * @return \Illuminate\Http\Response
     */
    public function show(Taux $taux)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Taux  $taux
     * @return \Illuminate\Http\Response
     */
    public function edit(Taux $taux)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Taux  $taux
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Taux $taux)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Taux  $taux
     * @return \Illuminate\Http\Response
     */
    public function destroy(Taux $taux)
    {
        //
    }
}
