<?php

namespace App\Http\Controllers;

use App\Models\TypeDossier;
use App\Models\TypeExpertise;
use Illuminate\Http\Request;

class TypeExpertiseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $typeexpertises = TypeExpertise::all();
        return view('configuration.Types.expertise.index',compact('typeexpertises'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.Types.expertise.create');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'type'=>'required|unique:type_expertises,type'
        ]);
        TypeExpertise::create([
            'type'=>$request->type
        ]);
        return redirect()->route('TypeExpert.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TypeExpertise  $typeExpertise
     * @return \Illuminate\Http\Response
     */
    public function show(TypeExpertise $typeExpertise)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TypeExpertise  $typeExpertise
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $typeExpertise = TypeExpertise::findOrFail($id);
        return view('configuration.Types.expertise.edit',compact('typeExpertise'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TypeExpertise  $typeExpertise
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'type'=>'required|unique:type_expertises,type,'.$id.''
        ]);

        $typeExpertise = TypeExpertise::findOrFail($id);
        $typeExpertise->type = $request->type;
        $typeExpertise->update();
        return redirect()->route('TypeExpert.index');


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TypeExpertise  $typeExpertise
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $typeExpertise = TypeExpertise::findOrFail($id);
        $typeExpertise->delete();
        return redirect()->route('TypeExpert.index');

    }

    public function deleted()
    {
        $TypeExpertises = TypeExpertise::onlyTrashed()->get();
        //dd($guarantees);
       return view('configuration.Types.expertise.deleted',compact('TypeExpertises')) ;
    }

    public function restore($id)
    {
        TypeExpertise::withTrashed()->find($id)->restore();
        return redirect()->route('TypeExpert.index');

    }

}
