<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['company','ice','email','phone','adress','email_pro','password'];

    public function user()
    {
        return $this->belongsToMany(User::class,'user_company')->withTrashed();
    }

    public function seuil()
    {
        return $this->hasMany(Seuil::class);
    }

    public function step()
    {
        return $this->belongsToMany(Step::class,'company_step')->withPivot('time')->withTimestamps();
    }

    public function usertypes()
    {
        return $this->belongsToMany(TypeExpertise::class, 'user_company_type')
            ->withPivot('user_id');
    }

    public function garage()
    {
        return $this->belongsToMany(Garage::class ,'garage_company')->withTimestamps();
    }

    public function city()
    {
        return $this->belongsTo(City::class)->withTrashed();
    }

    public function opponent()
    {
        return $this->hasMany(Opponent::class)->withTrashed();
    }
    public function notehonoraire()
    {
        return $this->hasMany(NoteHonoraire::class);
    }
    public function settlement()
    {
        return $this->hasMany(Settlement::class);
    }

    public function dossier()
    {
        return $this->hasMany(Dossier::class);
    }

}
