<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Settlement extends Model
{
    use HasFactory;

    protected $fillable = [
        'numero_facture',
        'montant',
        'banque',
        'mode_paiement',
        'date_facture',
        'company_id',
        'reste',
        'date_paiement'
    ];


    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function payment()
    {
        return $this->belongsToMany(Settlement::class,'settlement_payment');
    }

}
