<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'dossier_id',
        'user_id',
        'creator_id',
        'status_rendezvous_id',
        'motif',
        'answer_at',
        'answer'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
    public function status()
    {
        return $this->belongsTo(StatusRendezvous::class, 'status_rendezvous_id');
    }
    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }
}
