<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rendezvouses', function (Blueprint $table) {
            $table->id();
            $table->string('ref');
            // $table->date('date')->nullable();
            // $table->time('heure')->nullable();
            $table->string('motif')->nullable();
            $table->foreignId('type_rendezvous_id')->constrained()->onDelete(null);
            $table->foreignId('status_rendezvous_id')->constrained()->onDelete(null);
            $table->foreignId('user_id')->constrained()->onDelete(null);


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rendezvouses');
    }
};
