<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('montants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dossier_id')->constrained()->onDelete(null);
            $table->foreignId('devis_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('facture_id')->nullable()->constrained()->onDelete(null);
            $table->decimal('montant_accord',10,2)->nullable();
            $table->decimal('montant_rapport',10,2)->nullable();


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('montants');
    }
};
