@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des Garages</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table table-striped" id="myTable">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Libelle</th>
                                    <th>Email</th>
                                    <th>Adresse</th>
                                    <th>Telephone</th>
                                    <th>Afficher</th>
                                    <th>Modifier</th>
                                    <th>Supprimer</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($garages as $garage)
                                    <tr>
                                        <td>{{ $garage->id }}</td>
                                        <td>{{ $garage->libelle }}</td>
                                        <td>{{ $garage->email ?? null}}</td>
                                        <td>{{ $garage->adress ?? null }}</td>
                                        <td>{{ $garage->tel ?? null }}</td>
                                        @can('view', $garage)
                                        <td> <a class="btn btn-sm btn-info rounded-pill" href="{{ route('Garage.show', [$garage->id]) }}"><i class="uil uil-eye fs-5"></i></a></td>
                                        @endcan
                                        @can('update', $garage)
                                        <td> <a class="btn btn-sm btn-primary rounded-pill" href="{{ route('Garage.edit', [$garage->id]) }}"><i class="uil uil-pen fs-5"></i></a></td>
                                        @endcan
                                        @can('delete', $garage)
                                        <td>
                                            <form action="{{ route('Garage.destroy', [$garage->id]) }}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-danger rounded-pill" type="submit"><i class="uil uil-trash fs-5"></i></button>
                                            </form>
                                        </td>
                                        @endcan

                                    </tr>
                                    @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

