@extends('layouts.dashboard.app')

@section('style')
    <link rel="stylesheet" href="{{ asset('css/viewer.css') }}">

    <style>
        .container {
            position: relative;
            width: 33%;
        }

        .container1 {
            position: relative;
            width: 25%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .container1:hover .image {
            opacity: 0.8;
        }

        .container1:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 15px;
        }

        .text1 {
            color: rgb(0, 0, 0);
            font-size: 20px;
        }
    </style>
@endsection

@section('content')
    <div class="row mt-2">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-left mb-2">
                    <a href="{{ route('Dossier.show', $facture->dossier_id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
                    <a href="{{ route('Facture.index', $dossier->id) }}" class="mt-2 btn btn-outline-info">
                        Facture
                    </a>
                </div>
                <div class="page-title-box">
                    @if ($facture->facturestatus)
                        @foreach ($facture->facturestatus as $item)
                            <span class="badge bg-{{ $item->color }}">{{ $item->status }}</span>
                        @endforeach
                    @endif
                </div>
            </div>
            @can('update', App\Models\Facture::class)
                @if ($facture->devis_status_id === 4)
                    @if (Auth::user()->role_id == 2 || Auth::user()->role_id == 4)
                        <div class="card mb-2">
                            <div class="card-body">
                                <div class="col-12">
                                    <div class="btn-group" role="group" aria-label="Basic example">
                                        <form action="{{ route('Facture.status', $facture->id) }}" class=""
                                            method="post">
                                            @csrf
                                            @method('PUT')
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>
                                            <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                            <button style="" name="action" value="avis" class="btn btn-warning ml-3">
                                                Demander Avis
                                            </button>
                                            <div class="col-md-12 mt-3">
                                                <label for="date" class="form-label">Observation :</label>
                                                <textarea class="form-control mb-2  @error('observation') is-invalid @enderror" name="observation" id=""
                                                    cols="10" rows="2"></textarea>
                                                @error('observation')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @elseif ($facture->devis_status_id == 3)
                    @if (Auth::user()->role_id == 4)
                        <div class="card mb-2">
                            <div class="card-body">
                                <div class="col-12">
                                    <div class="btn-group" role="group" aria-label="Basic example">
                                        <form action="{{ route('Facture.status', $facture->id) }}" class=""
                                            method="post">
                                            @csrf
                                            @method('PUT')
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>
                                            <button style="" name="action" value="retraiter"
                                                class="btn btn-warning ml-3">
                                                Retraiter
                                            </button>
                                            <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                            <div class="col-md-12 mt-3">
                                                <label for="date" class="form-label">Observation :</label>
                                                <textarea class="form-control mb-2  @error('observation') is-invalid @enderror" name="observation" id=""
                                                    cols="10" rows="2"></textarea>
                                                @error('observation')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="card mb-2">
                            <div class="card-body">
                                <div class="col-12">
                                    <span class="badge-bg-{{ $facture->status->color }}">{{ $facture->status->status }}</span>
                                </div>
                            </div>
                        </div>
                    @endif
                @elseif ($facture->devis_status_id == 2)
                    @if (Auth::user()->role_id == 4 || Auth::user()->role_id == 1)
                        <div class="card mb-2">
                            <div class="card-body">
                                <div class="col-12">
                                    <div class="btn-group" role="group" aria-label="Basic example">
                                        <form action="{{ route('Facture.status', $facture->id) }}" class=""
                                            method="post">
                                            @csrf
                                            @method('PUT')
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Modifier Accord
                                            </button>

                                        </form>
                                    </div>
                                </div>
                            </div>
                    @endif
                @elseif ($facture->devis_status_id == 5)
                    @if (Auth::user()->role_id == 4 || Auth::user()->role_id == 2)
                        <div class="card mb-2">
                            <div class="card-body">
                                <div class="col-12">
                                    <div class="btn-group" role="group" aria-label="Basic example">
                                        <form action="{{ route('Facture.status', $facture->id) }}" class=""
                                            method="post">
                                            @csrf
                                            @method('PUT')
                                            <button style="" name="action" value="accord"
                                                class="btn btn-success ml-3">
                                                Accord
                                            </button>

                                            <button style="" name="action" value="rejeter"
                                                class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                            <div class="col-md-12 mt-3">
                                                <label for="date" class="form-label">Observation :</label>
                                                <textarea class="form-control mb-2  @error('observation') is-invalid @enderror" name="observation" id=""
                                                    cols="10" rows="2"></textarea>
                                                @error('observation')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                    @endif
                @endif
            @endcan

        </div>
    </div>

    <div class="row mt-2">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="page-title-box">
                        <h4 class="page-title" style="font-size: 22px">
                            Facture
                            <span class="badge bg-{{ $facture->status->color }}">{{ $facture->status->status }}</span>
                        </h4>

                    </div>
                    <div class="table-responsive">
                        <div class="col-12">

                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Type Facture</th>
                                        <th>Montant Devis</th>
                                        <th>Montant Accord</th>
                                        <th>Montant Facture</th>
                                        <th>Montant Rapport</th>
                                        <th>Modifier</th>
                                    </tr>
                                </thead>

                                <tbody>

                                    <tr>
                                        <td class="">
                                            {{ $facture->typefacture->type ?? null }}
                                        </td>
                                        <td class="col-3">
                                            <input type="text" name="montant_devis" readonly
                                                value="{{ $montant->devis->montant_devis ?? null }}" name="montant_devis"
                                                class="form-control  @error('montant_devis') is-invalid @enderror">
                                            @error('montant_devis')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-3">
                                            <input type="text" name="montant_accord" readonly
                                                value="{{ $montant->montant_accord ?? null }}" name="montant_accord"
                                                class="form-control @error('montant_accord') is-invalid @enderror">
                                            @error('montant_accord')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-3">
                                            <input type="text"readonly
                                                value="{{ $montant->facture->montant_facture ?? null }}"
                                                name="montant_facture"
                                                class="form-control @error('montant_facture') is-invalid @enderror">
                                            @error('montant_facture')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-3">
                                            <input type="text" value="{{ $montant->montant_rapport ?? null }}"
                                                name="montant_rapport" readonly
                                                class="form-control @error('montant_rapport') is-invalid @enderror">
                                            @error('montant_rapport')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </td>
                                        <td class="col-3">
                                            <a href="{{ route('Montant.edit', $montant->id) }}"
                                                class="btn btn-sm btn-outline-primary"><i
                                                    class="uil uil-pen fs-5"></i></a>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="row mt-1" id="galley">
        <div class="col-6">
            <div class="card mb-2">
                <div class="card-body">
                    <h4 class="page-title text-dark" style="font-size: 22px">
                        Facture
                    </h4>
                    <hr>
                    @if ($docfacture)
                        <div class="row">
                            @foreach ($docfacture as $doc)
                                <div class="col-3 container">
                                    <img data-original="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                                        src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) ?? null }}"
                                        alt="img" class="img-fluid m-1" srcset="">
                                    <div class="middle">
                                        @if ($doc->facture[0]->id == $facture->id)
                                            <a href="{{ route('Facture.show', ['id' => $facture->id, 'doc_id' => $doc->id]) }}"
                                                class="text append icon dripicons-document-edit"></a>
                                        @endif

                                    </div>
                                    <span class="badge bg-primary m-1"
                                        style="display: block;">{{ $doc->facture[0]->facture ?? null }}
                                        {{ $doc->typedocument->type }}
                                        @if ($doc->facture_mo)
                                            MO
                                        @else
                                            Piece
                                        @endif

                                    </span>

                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-6">
            <div class="">
                <ul class="nav nav-tabs nav-stacked ">
                    <li class="nav-item ">
                        <button type="button" data-filter="ALL" class="link nav-link" style=" cursor: pointer;"
                            value="ALL">ALL
                        </button>
                    </li>
                    @foreach ($typedocuments as $type)
                        <li class="nav-item ">
                            <button type="button" data-filter="{{ $type->type }}" class="link nav-link"
                                style=" cursor: pointer;" value="{{ $type->id }}">{{ $type->type }} </button>
                        </li>
                    @endforeach
                </ul>
                <div class="card-body m-1" style="height: 300px; overflow-y:auto">
                    <input type="hidden" id="id" name="dossier_id" value="{{ $dossier->id }}">
                    @if ($dossier->document)
                        <ul style="list-style-type: none;" id="row" class="row">
                            @foreach ($dossier->document as $doc)
                                @if ($doc->type_document_id != 10)
                                    <li class="box container col-3 media {{ $doc->typedocument->type ?? null }} ">
                                        @php
                                            // Generate a unique cache key based on the document ID
                                            $cacheKey = 'document_' . $doc->id;

                                            // Check if the document image URL is already cached
                                            $imageUrl = Cache::remember($cacheKey, 30, function () use ($doc) {
                                                // If not cached, generate the temporary URL and return it
                                                return Storage::disk('s3')->temporaryUrl(
                                                    $doc->path,
                                                    now()->addMinutes(30),
                                                );
                                            });
                                        @endphp
                                        <img data-original="{{ $imageUrl }}" src="{{ $imageUrl }}"
                                            alt="img" class="img-fluid m-1" srcset="">
                                        <div class="middle">
                                            <a href="{{ route('Document.edit', $doc->id) }}"
                                                class="text append icon dripicons-document-edit"></a>
                                            @if (Auth::user()->role_id == 4)
                                                @if ($doc->type_document_id != 4 && $doc->type_document_id != 8)
                                                    <form class="deleteForm"
                                                        action="{{ route('Document.destroy', $doc->id) }}"
                                                        method="post">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="confirmDelete"
                                                            style="padding: 0;border: none;background: none;"
                                                            type="button"><i
                                                                class="text append icon dripicons-trash"></i></button>
                                                    </form>
                                                @endif
                                            @endif
                                        </div>
                                        @if ($doc->edited)
                                            <span class="badge  bg-success m-1"
                                                style="display: block;">{{ $doc->typedocument->type ?? null }}     @if ($doc->type_document_id == 8)
                                                @if ($doc->facture_mo)
                                                    MO
                                                @else
                                                    Piece
                                                @endif
                                            @endif</span>
                                        @else
                                            <span class="badge  bg-primary m-1"
                                                style="display: block;">{{ $doc->typedocument->type ?? null }}   @if ($doc->type_document_id == 8)
                                                @if ($doc->facture_mo)
                                                    MO
                                                @else
                                                    Piece
                                                @endif
                                            @endif</span>
                                        @endif


                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    @endif
                </div>


            </div>
        </div>

    </div>
    @if (Auth::user()->role_id == 4 || $facture->devis_status_id == 4 || $facture->devis_status_id == 3)
        @include('devis.editor_devis2')
    @endif
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-3" style="color: black">Observation</h4>
                    @if ($observations)
                        <div class="accordion" id="">
                            @foreach ($observations as $key => $observation)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse-{{ $key }}"
                                            aria-expanded="false" aria-controls="">
                                            {{ $observation->user->name }}
                                        </button>
                                    </h2>
                                    <div id="collapse-{{ $key }}" class="accordion-collapse collapse "
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <strong class="text-dark">{{ $observation->observation }}.</strong>
                                            <span>{{ $observation->created_at }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <form method="POST" action="{{ route('Observation.store') }}">
                        @csrf
                        <div class="col-md-12 mt-1 ml-3">
                            <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                            <textarea name="observation" class="form-control @error('observation') is-invalid @enderror mb-2" id="observation"
                                cols="30" rows="10"></textarea>
                            @error('observation')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                            <button class="mt-2 btn btn-info">Créer</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

@endsection
@section('script')
    <script src="{{ asset('js/viewer.js') }}"></script>

    <script>
        window.addEventListener('DOMContentLoaded', function() {
            var galley = document.getElementById('galley');
            var maxOffsetPercentage = 0.9;
            var viewer = new Viewer(galley, {
                url: 'data-original',
                backdrop: 'static',
                move: function(event) {
                    var viewerData = viewer.viewerData;
                    var imageData = viewer.imageData;
                    var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                    var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                    var detail = event.detail;
                    var left = detail.x;
                    var top = detail.y;
                    var right = viewerData.width - (left + imageData.width);
                    var bottom = viewerData.height - (top + imageData.height);
                    if (
                        // Move left
                        (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                        // Move right
                        ||
                        (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                        // Move up
                        ||
                        (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                        // Move down
                        ||
                        (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                    ) {
                        event.preventDefault();
                    }
                },
                zoomed: function(event) {
                    var detail = event.detail;
                    // Zoom out
                    if (detail.ratio < detail.oldRatio) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var left = imageData.x;
                        var top = imageData.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        var x = 0;
                        var y = 0;
                        if (right > 0 && right > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - right;
                        }
                        if (left > 0 && left > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - left;
                        }

                        if (bottom > 0 && bottom > maxOffsetVertical) {
                            y = bottom - maxOffsetVertical;
                        }

                        if (top > 0 && top > maxOffsetVertical) {
                            y = top - maxOffsetVertical;
                        }

                        // Move the image into view if it is invisible
                        if (x !== 0 || y !== 0) {
                            viewer.move(x, y);
                        }
                    }
                },
            });
        });
        var links = document.getElementsByClassName('link');
        for (var i = 0; i < links.length; i++) {

            links[i].addEventListener('click', function() {
                console.log('clcl');
                var galley = document.getElementById('galley');
                var maxOffsetPercentage = 0.9;
                var viewer = new Viewer(galley, {
                    url: 'data-original',
                    backdrop: 'static',
                    move: function(event) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var detail = event.detail;
                        var left = detail.x;
                        var top = detail.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        if (
                            // Move left
                            (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                            // Move right
                            ||
                            (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                            // Move up
                            ||
                            (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                            // Move down
                            ||
                            (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                        ) {
                            event.preventDefault();
                        }
                    },
                    zoomed: function(event) {
                        var detail = event.detail;
                        // Zoom out
                        if (detail.ratio < detail.oldRatio) {
                            var viewerData = viewer.viewerData;
                            var imageData = viewer.imageData;
                            var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                            var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                            var left = imageData.x;
                            var top = imageData.y;
                            var right = viewerData.width - (left + imageData.width);
                            var bottom = viewerData.height - (top + imageData.height);
                            var x = 0;
                            var y = 0;
                            if (right > 0 && right > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - right;
                            }
                            if (left > 0 && left > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - left;
                            }

                            if (bottom > 0 && bottom > maxOffsetVertical) {
                                y = bottom - maxOffsetVertical;
                            }

                            if (top > 0 && top > maxOffsetVertical) {
                                y = top - maxOffsetVertical;
                            }

                            // Move the image into view if it is invisible
                            if (x !== 0 || y !== 0) {
                                viewer.move(x, y);
                            }
                        }
                    },
                });
            });
        }
    </script>
@endsection
