<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="menuitem-active">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

    <link rel="shortcut icon" href="{{ asset('img/icon.png') }}" type="image/png">
    <title>{{ config('app.name', 'AMEA') }}</title>


    {{-- dataTables --}}
    {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous"> --}}

    {{-- Styles --}}
    {{-- <script>
        window.onload = function() {
            document.getElementById('content').style.display = "block";
            document.getElementById('content').style.backgroundColor = "#ffffff";
            document.getElementById('loading').style.display = "none";
        }
    </script> --}}
    {{-- <style>
        body {
            background: #b6cdff !important;
        }

        #content {
            /* margin: 0;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgb(237, 222, 222); */
            display: none;


        }

        #loading {
            width: 100%;
            height: 100%;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgba(255, 255, 255, 0.3);
            z-index: 1;
        }

        .loader {
            width: 11.7em;
            height: 4.2em;
            font-size: 20px;
            position: absolute;
            color: #313a46;
            z-index: 9999;
            position: fixed;
            top: 40%;
            left: 40%;

        }

        .car {
            position: absolute;
            width: inherit;
            height: 2em;
            background-color: #313a46;
            top: 1.5em;
            border-radius: 0 5em 1em 0 / 0 4em 1em 0;
            animation: run 0.25s linear infinite;
        }

        @keyframes run {
            0% {
                transform: translate(0.2em, 0.1em);
            }

            20% {
                transform: translate(0.1em, 0.2em);
            }

            40% {
                transform: translate(0.1em, -0.1em);
            }

            60% {
                transform: translate(-0.1em, 0.2em);
            }

            80% {
                transform: translate(-0.1em, 0.1em);
            }

            100% {
                transform: translate(0.2em, 0.1em);
            }
        }

        .car::before {
            content: '';
            position: absolute;
            width: 0;
            height: 0;
            border: 0.6em solid transparent;
            top: -0.5em;
            border-left-width: 0;
            border-right-color: currentColor;
            transform-origin: left;
            transform: rotate(-45deg);
        }

        .body {
            position: absolute;
            width: 7.5em;
            height: 3.5em;
            box-sizing: border-box;
            border: 0.4em solid;
            top: -1.5em;
            left: 1.2em;
            border-radius: 3em 4.5em 0 0 / 3em 4em 0 0;
        }

        .body::before {
            content: '';
            position: absolute;
            width: 3.5em;
            height: inherit;
            background-color: #313a46;
            border-top-left-radius: inherit;
            top: -0.4em;
            left: -0.4em;
        }

        .wheels::before,
        .wheels::after {
            content: '';
            position: absolute;
            box-sizing: border-box;
            width: 2.6em;
            height: 2.6em;
            background-color: rgb(188, 228, 231);
            border-radius: 50%;
            bottom: -1em;
            border: 0.3em solid rgb(188, 228, 231);
            background-image:
                linear-gradient(135deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                linear-gradient(90deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                linear-gradient(45deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                linear-gradient(0deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                radial-gradient(currentColor 29%,
                    transparent 30%, transparent 50%,
                    currentColor 51%);
            animation: rotating 0.5s linear infinite;
        }

        .wheels::before {
            left: 1.2em;
        }

        .wheels::after {
            right: 0.8em;
        }

        @keyframes rotating {
            to {
                transform: rotate(1turn);
            }
        }

        .strikes {
            position: absolute;
            width: 1em;
            height: inherit;
            left: -1em;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .strikes span {
            height: 0.1em;
            background-color: #313a46;
            animation: drift 0.2s linear infinite;
            animation-delay: calc(var(--n) * -0.05s);
        }

        @keyframes drift {
            from {
                transform: translate(3.5em);
            }

            to {
                transform: translate(-8em);
                filter: opacity(0);
            }
        }

        .strikes span:nth-child(1) {
            --n: 1;
        }

        .strikes span:nth-child(2) {
            --n: 2;
        }

        .strikes span:nth-child(3) {
            --n: 3;
        }

        .strikes span:nth-child(4) {
            --n: 4;
        }

        .strikes span:nth-child(5) {
            --n: 5;
        }
    </style> --}}

    <link rel="stylesheet" href="{{ asset('css/dataTables/dataTables.bootstrap.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link rel="stylesheet" href="{{ asset('css/icons.css') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/search.css') }}">
    <link rel="stylesheet" href="{{ asset('css/viewer.css') }}">
    <style>
        .scrollable-container {
            overflow: auto;
            /* or overflow: scroll; */
        }
    </style>
    @yield('style')
    @livewireStyles()


</head>

<body id="body" data-layout-color="light" data-layout-mode="fluid" data-rightbar-onstart="true"
    data-leftbar-theme="dark" style="">
    {{-- <div id="loading">
        <figure class="loader">
            <div class="car">
                <span class="body"></span>
                <span class="wheels"></span>
            </div>
            <div class="strikes">
                <span></span>
                <span></span>
                <span></span>
                <span></span>
                <span></span>
            </div>
        </figure>
    </div> --}}



    <div class="wrapper" id="content">
        @include('layouts.dashboard.partials.sidebar')
        <div class="content-page">
            <div class="content">
                @include('layouts.config_dashboard.partials.topbar')
                <div class="container-fluid m-0 p-0 mt-1 ">

                    @include('errors.alert')
                    @yield('content')
                </div>
            </div>

            <footer class="footer mt-3">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            ENGI - BLK consulting
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- Scripts -->

    <script src="{{ asset('js/vendor.js') }}"></script>
    <script src="{{ asset('js/app.js') }}" defer></script>
    {{-- dataTables --}}

    <script src="{{ asset('js/dataTables.js/dataTables.js') }}"></script>
    <script src="{{ asset('js/viewer.js') }}"></script>
    <script
        src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"
        defer></script>

    {{-- editor --}}

    <script>
        $(document).ready(function() {
            
            $('.selectGarage').select2();

            var allTables = $('table.dataTable').DataTable();
            allTables.column(0).search('mySearchTerm').draw();
            $('#myTable').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                },
                // dom: 'Bfrtip',
                // buttons: [
                //     'copy', 'csv', 'excel', 'pdf', 'print'
                // ],
                // pagingType: "numbers"
            });
            $('#myTable2').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                } //,
                // pagingType: "numbers"
            });
            $('#myTable3').DataTable();

        });
    </script>
    @livewireScripts()
    @yield('script')
    <script>
        var $mediaElements = $('.media');

        $('.link').click(function(e) {
            e.preventDefault();

            var filterVal = $(this).data('filter');

            if (filterVal === 'ALL') {
                $mediaElements.show();
            } else {
                // Enclose filterVal in quotes to handle spaces
                $mediaElements.hide().filter('.' + CSS.escape(filterVal)).show();
            }
        });

    </script>

    <script>
        window.addEventListener('load', function() {
            console.log('DOM fully loaded and parsed');
            var galley = document.getElementById('galley');
            var maxOffsetPercentage = 0.9;
            var viewer = new Viewer(galley, {
                url: 'data-original',
                backdrop: 'static',
                move: function(event) {
                    var viewerData = viewer.viewerData;
                    var imageData = viewer.imageData;
                    var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                    var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                    var detail = event.detail;
                    var left = detail.x;
                    var top = detail.y;
                    var right = viewerData.width - (left + imageData.width);
                    var bottom = viewerData.height - (top + imageData.height);
                    if (
                        // Move left
                        (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                        // Move right
                        ||
                        (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                        // Move up
                        ||
                        (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                        // Move down
                        ||
                        (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                    ) {
                        event.preventDefault();
                    }
                },
                zoomed: function(event) {
                    var detail = event.detail;
                    // Zoom out
                    if (detail.ratio < detail.oldRatio) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var left = imageData.x;
                        var top = imageData.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        var x = 0;
                        var y = 0;
                        if (right > 0 && right > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - right;
                        }
                        if (left > 0 && left > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - left;
                        }

                        if (bottom > 0 && bottom > maxOffsetVertical) {
                            y = bottom - maxOffsetVertical;
                        }

                        if (top > 0 && top > maxOffsetVertical) {
                            y = top - maxOffsetVertical;
                        }

                        // Move the image into view if it is invisible
                        if (x !== 0 || y !== 0) {
                            viewer.move(x, y);
                        }
                    }
                },
            });
        });
        var links = document.getElementsByClassName('link');
        for (var i = 0; i < links.length; i++) {

            links[i].addEventListener('click', function() {
                console.log('clcl');
                var galley = document.getElementById('galley');
                var maxOffsetPercentage = 0.9;
                var viewer = new Viewer(galley, {
                    url: 'data-original',
                    backdrop: 'static',
                    move: function(event) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var detail = event.detail;
                        var left = detail.x;
                        var top = detail.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        if (
                            // Move left
                            (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                            // Move right
                            ||
                            (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                            // Move up
                            ||
                            (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                            // Move down
                            ||
                            (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                        ) {
                            event.preventDefault();
                        }
                    },
                    zoomed: function(event) {
                        var detail = event.detail;
                        // Zoom out
                        if (detail.ratio < detail.oldRatio) {
                            var viewerData = viewer.viewerData;
                            var imageData = viewer.imageData;
                            var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                            var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                            var left = imageData.x;
                            var top = imageData.y;
                            var right = viewerData.width - (left + imageData.width);
                            var bottom = viewerData.height - (top + imageData.height);
                            var x = 0;
                            var y = 0;
                            if (right > 0 && right > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - right;
                            }
                            if (left > 0 && left > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - left;
                            }

                            if (bottom > 0 && bottom > maxOffsetVertical) {
                                y = bottom - maxOffsetVertical;
                            }

                            if (top > 0 && top > maxOffsetVertical) {
                                y = top - maxOffsetVertical;
                            }

                            // Move the image into view if it is invisible
                            if (x !== 0 || y !== 0) {
                                viewer.move(x, y);
                            }
                        }
                    },
                });
            });
        }
    </script>


</body>

</html>
