
<!-- Signup modal-->
<div id="signup-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalToggleLabel">Assigner Une Piéce </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form class="ps-3 pe-3" method="POST" action="{{ route('Piece.rapport') }}">

                <div class="modal-body">
                    {{-- <div class="text-center text-dark mt-2 mb-4 fs-4"> Créer Une Piéce </div> --}}
                    @csrf
                    <input type="hidden" id="vehicule_model_id" name="vehicule_model_id" value="{{ $rapport->dossier->vehicule_model_id }}"
                        id="">
                    <input type="hidden" name="rapport_id" value="{{ $rapport->id }}" id="">
                    <div class="row">
                        <div class="form-group col-6 mb-3">
                            <label for="piece_type_id">Type Piéce *:</label>
                            <select name="piece_type_id" id="piece_type_id"
                                class="form-control @error('piece_type_id') is-invalid @enderror">
                                <option value="">Selectionner Type :</option>
                                @foreach ($piecetypes as $type)
                                    <option value="{{ $type->id }}">
                                        {{ $type->type }}</option>
                                @endforeach
                            </select>
                            @error('piece_type_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-6 mb-1">
                            <label for="piece">Piéce :</label>
                            <select name="piece" id="existingOption"
                                class="form-control @error('piece') is-invalid @enderror">
                               <option value="">Selectionner :</option>
                            </select>

                            @error('piece')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group col-6 mb-1">
                            <label for="prix_unitaire">Prix Unitaire *:</label>
                            <input type="number" step="0.01" name="prix_unitaire" required id="prix_unitaire"
                                class="form-control @error('prix_unitaire') is-invalid @enderror">
                            @error('prix_unitaire')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group col-6 mb-3">
                            <label for="brand">Type Reparation *:</label>
                            <select name="type_reparation_id" id="type_reparation_id"
                                class="form-control @error('type_reparation_id') is-invalid @enderror">
                                @foreach ($types as $type)
                                    <option value="{{ $type->id }}">
                                        {{ $type->type }}</option>
                                @endforeach
                            </select>
                            @error('type_reparation_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group col-6 mb-3">
                            <label for="brand">Operation Piéce *:</label>
                            <select name="operation" id="operation"
                                class="form-control @error('operation') is-invalid @enderror">
                                @foreach ($operations as $operation)
                                    <option value="{{ $operation->id }}">
                                        {{ $operation->operation }}</option>
                                @endforeach
                            </select>
                            @error('operation')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-6 mb-3">
                            <label for="qte">Qte *:</label>
                            <input type="number" name="qte" id="qte" min="1" value="1"
                                class="form-control @error('qte') is-invalid @enderror">

                            @error('qte')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-6 mb-3">
                            <label for="gravite">Gravite *:</label>
                            <select name="gravite" id="gravite" class="form-control ">
                                <option value="">Sélectionner :</option>
                                <option value="Moyen">Moyen</option>
                                <option value="Faible">Faible</option>
                            </select>
                        </div>

                        <div class="form-group col-6 mb-3">
                            <label for="gravite">Etat *:</label>
                            <select name="etat" id="etat" class="form-control ">
                                <option value="">Sélectionner :</option>
                                <option value="OUI">OUI</option>
                                <option value="NON">NON</option>
                            </select>
                        </div>

                        <div class="form-group col-6 mb-3">
                            <label for="vetuste">Vétuste :</label>
                            <input type="number" name="vetuste" id="vetuste" min="0" value="0"
                                class="form-control @error('vetuste') is-invalid @enderror">

                            @error('vetuste')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-6 mb-3">
                            <label for="remise">Remise :</label>
                            <input type="number" name="remise" id="remise" min="0" value="0"
                                class="form-control @error('remise') is-invalid @enderror">

                            @error('remise')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>


                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-target="#exampleModalToggle" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Fermer</button>
                    <button class="btn btn-primary" type="submit" type="submit">Ajouter</button>
                </div>
        </div>
        </form><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<script src="{{ asset('js/vendor.js') }}"></script>
<script>

    $('#piece_type_id').on('change', function() {
        var type_id = this.value;
        $.ajax({
            url: '/TypePiece/' + type_id,
            type: 'get',
            success: function(result) {
                $('#vehicule_model_id').html(
                    '<option  value="">Selectionner Piece </option>');
                // console.log(result);
                var selectElement = $("#existingOption"); // Corrected line

                selectElement.empty(); // Clear previous options

                $.each(result, function(key, value) {
                    selectElement.append('<option value="' + value.id + '">' + value.piece +
                        '</option>');
                });

            }
        });
    });
    $('#existingOption').on('change', function() {
        console.log(this);
        var vehicule_id = $('#vehicule_model_id').val();
        var piece_id = this.value;
        var piecetype = $('#piece_type_id').val();
        var operation_id = $('#operation').val();
        var type = $('#type_reparation_id').val();


        $.ajax({
            url: '/Devis/Piece/Prix',
            type: 'get',
            data: {
                vehicule_id,
                piece_id,
                operation_id,
                type
            },
            success: function(result) {
                console.log(result);
                var selectElement = $("#prix_unitaire"); // Corrected line
                selectElement.empty();
                document.getElementById('prix_unitaire').value = result;
            }
        });
    });

</script>
