<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\Guarantee;
use Illuminate\Http\Request;

class GuaranteeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny', Guarantee::class);

        $guarantees = Guarantee::all();
        return view('configuration.guarantee.index', compact('guarantees'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', Guarantee::class);

        return view('configuration.guarantee.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Guarantee::class);

        $request->validate([
            'guarantee' => 'required|unique:guarantees,guarantee',
        ]);

        Guarantee::create([
            'guarantee' => $request->guarantee,
            'tauxRP' => $request->tauxRP
        ]);

        return redirect()->route('Guarantee.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Guarantee  $guarantee
     * @return \Illuminate\Http\Response
     */
    public function show(Guarantee $guarantee)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Guarantee  $guarantee
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', Guarantee::class);

        $guarantee = Guarantee::whereId($id)->first();
        return view('configuration.guarantee.edit', compact('guarantee'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Guarantee  $guarantee
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update', Guarantee::class);

        $guarantee = Guarantee::whereId($id)->first();
        $request->validate([
            'guarantee' => 'required|unique:guarantees,guarantee,' . $id . ''

        ]);
        $guarantee->guarantee = $request->guarantee;
        $guarantee->tauxRP = $request->tauxRP;
        $guarantee->update();

        return redirect()->route('Guarantee.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Guarantee  $guarantee
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('delete', Guarantee::class);

        $guarantee = Guarantee::whereId($id)->first();
        $guarantee->delete();
        return redirect()->route('Guarantee.index');
    }

    public function deleted()
    {
        $this->authorize('delete', Guarantee::class);
        $guarantees = Guarantee::onlyTrashed()->get();
        //dd($guarantees);
        return view('configuration.guarantee.deleted', compact('guarantees'));
    }

    public function restore($id)
    {
        $this->authorize('delete', Guarantee::class);

        Guarantee::withTrashed()->find($id)->restore();
        return redirect()->route('Guarantee.index');
    }
}
